/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.watcher;

import com.intellij.core.CoreBundle;
import com.intellij.ide.macro.FileDirMacro;
import com.intellij.ide.macro.FileNameMacro;
import com.intellij.ide.macro.FileNameWithoutExtension;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.PsiFile;
import com.intellij.tools.FilterInfo;
import org.coffeescript.CoffeeScriptLanguage;
import org.coffeescript.lang.psi.CoffeeScriptFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeTaskConsumer
extends BackgroundTaskConsumer {
    public boolean isAvailable(PsiFile file) {
        return file instanceof CoffeeScriptFile;
    }

    public String getConsumeMessage() {
        return "Enable File Watcher to compile CoffeeScript to JavaScript?";
    }

    @NotNull
    public TaskOptions getOptionsTemplate() {
        TaskOptions options = new TaskOptions();
        options.setName(CoffeeScriptLanguage.INSTANCE.getDisplayName());
        options.setDescription("Compiles .coffee files into .js files");
        options.setFileExtension("coffee");
        options.setScopeName(CoreBundle.message((String)"psi.search.scope.project", (Object[])new Object[0]));
        options.setWorkingDir("$" + new FileDirMacro().getName() + "$");
        options.setArguments("--compile $" + new FileNameMacro().getName() + "$");
        options.setOutput("$" + new FileNameWithoutExtension().getName() + "$.js");
        options.setOutputFilters(new FilterInfo[]{new FilterInfo("$FILE_PATH$:$LINE$:$COLUMN$: $MESSAGE$$", "coffee", "coffee error format")});
        TaskOptions taskOptions = options;
        if (taskOptions == null) {
            CoffeeTaskConsumer.$$$reportNull$$$0(0);
        }
        return taskOptions;
    }

    public void configureWithLastOptions(TaskOptions options, @Nullable TaskOptions defaultOptions) {
        super.configureWithLastOptions(options, defaultOptions);
        if (defaultOptions != null) {
            options.setArguments(defaultOptions.getArguments());
            options.setOutput(defaultOptions.getOutput());
            options.setOutputFromStdout(defaultOptions.isOutputFromStdout());
        }
    }

    public void additionalConfiguration(@NotNull Project project, @Nullable PsiFile file, @NotNull TaskOptions options) {
        if (project == null) {
            CoffeeTaskConsumer.$$$reportNull$$$0(1);
        }
        if (options == null) {
            CoffeeTaskConsumer.$$$reportNull$$$0(2);
        }
        super.additionalConfiguration(project, file, options);
        options.setProgram("coffee");
        options.setArguments("--map " + options.getArguments());
        String fileNameWithoutExtensionMacroName = new FileNameWithoutExtension().getName();
        options.setOutput(options.getOutput() + ":$" + fileNameWithoutExtensionMacroName + "$.map:$" + fileNameWithoutExtensionMacroName + "$.js.map");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/coffeescript/watcher/CoffeeTaskConsumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsTemplate";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/coffeescript/watcher/CoffeeTaskConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "additionalConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

