/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.DirectoryBasedSaveSessionProducer;
import com.intellij.configurationStore.DirectoryBasedStorageBase;
import com.intellij.configurationStore.DirectoryBasedStorageKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.ReadOnlyModificationException;
import com.intellij.configurationStore.SaveSession;
import com.intellij.configurationStore.SaveSessionBase;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateMapKt;
import com.intellij.configurationStore.StorageManagerFileWriteRequestor;
import com.intellij.configurationStore.TrackingPathMacroSubstitutorImpl;
import com.intellij.configurationStore.XmlDataWriter;
import com.intellij.configurationStore.schemeManager.SchemeLoaderKt;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.JdomKt;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.io.PathKt;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001bB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0017\u0010\u0017\u001a\u00020\u00142\b\u0010\u0002\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/configurationStore/DirectoryBasedStorage;", "Lcom/intellij/configurationStore/DirectoryBasedStorageBase;", "dir", "Ljava/nio/file/Path;", "splitter", "Lcom/intellij/openapi/components/StateSplitter;", "pathMacroSubstitutor", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "(Ljava/nio/file/Path;Lcom/intellij/openapi/components/StateSplitter;Lcom/intellij/openapi/components/PathMacroSubstitutor;)V", "cachedVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isUseVfsForWrite", "", "()Z", "virtualFile", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "createSaveSessionProducer", "Lcom/intellij/configurationStore/SaveSessionProducer;", "setStorageData", "", "newStates", "Lcom/intellij/configurationStore/StateMap;", "setVirtualDir", "setVirtualDir$intellij_platform_configurationStore_impl", "toString", "", "MySaveSession", "intellij.platform.configurationStore.impl"})
public class DirectoryBasedStorage
extends DirectoryBasedStorageBase {
    private volatile VirtualFile cachedVirtualFile;
    private final Path dir;

    public boolean isUseVfsForWrite() {
        return true;
    }

    @Override
    @Nullable
    protected VirtualFile getVirtualFile() {
        VirtualFile result = this.cachedVirtualFile;
        if (result == null) {
            this.cachedVirtualFile = result = LocalFileSystem.getInstance().findFileByPath(PathKt.getSystemIndependentPath((Path)this.dir));
        }
        return result;
    }

    public final void setVirtualDir$intellij_platform_configurationStore_impl(@Nullable VirtualFile dir) {
        this.cachedVirtualFile = dir;
    }

    @Override
    @Nullable
    public SaveSessionProducer createSaveSessionProducer() {
        return this.checkIsSavingDisabled() ? null : (SaveSessionProducer)new MySaveSession(this, (StateMap)this.getStorageData());
    }

    private final void setStorageData(StateMap newStates) {
        this.getStorageDataRef().set(newStates);
    }

    @NotNull
    public String toString() {
        VirtualFile virtualFile = this.getVirtualFile();
        return ((Object)((Object)this)).getClass().getSimpleName() + "(file=" + (virtualFile != null ? virtualFile.getPath() : null) + ", componentName=" + this.getComponentName() + ')';
    }

    public DirectoryBasedStorage(@NotNull Path dir, @NotNull StateSplitter splitter, @Nullable PathMacroSubstitutor pathMacroSubstitutor) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)splitter, (String)"splitter");
        super(splitter, pathMacroSubstitutor);
        this.dir = dir;
    }

    public /* synthetic */ DirectoryBasedStorage(Path path, StateSplitter stateSplitter, PathMacroSubstitutor pathMacroSubstitutor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            pathMacroSubstitutor = null;
        }
        this(path, stateSplitter, pathMacroSubstitutor);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0000H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\"\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010\u0019H\u0016J\u001a\u0010!\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010\u0019H\u0016R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/configurationStore/DirectoryBasedStorage$MySaveSession;", "Lcom/intellij/configurationStore/SaveSessionBase;", "Lcom/intellij/configurationStore/SaveSession;", "Lcom/intellij/configurationStore/DirectoryBasedSaveSessionProducer;", "storage", "Lcom/intellij/configurationStore/DirectoryBasedStorage;", "originalStates", "Lcom/intellij/configurationStore/StateMap;", "(Lcom/intellij/configurationStore/DirectoryBasedStorage;Lcom/intellij/configurationStore/StateMap;)V", "copiedStorageData", "", "", "", "dirtyFileNames", "Lcom/intellij/util/containers/SmartHashSet;", "isSomeFileRemoved", "", "createSaveSession", "deleteFiles", "", "dir", "Lcom/intellij/openapi/vfs/VirtualFile;", "doSetState", "fileName", "subState", "Lorg/jdom/Element;", "removeFileData", "save", "saveStates", "states", "setFileState", "componentName", "element", "setSerializedState", "intellij.platform.configurationStore.impl"})
    private static final class MySaveSession
    extends SaveSessionBase
    implements SaveSession,
    DirectoryBasedSaveSessionProducer {
        private Map<String, Object> copiedStorageData;
        private final SmartHashSet<String> dirtyFileNames;
        private boolean isSomeFileRemoved;
        private final DirectoryBasedStorage storage;
        private final StateMap originalStates;

        @Override
        public void setSerializedState(@NotNull String componentName, @Nullable Element element) {
            List list;
            Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
            this.storage.setComponentName(componentName);
            if (JdomKt.isEmpty((Element)element)) {
                list = CollectionsKt.emptyList();
            } else {
                StateSplitter stateSplitter = this.storage.getSplitter();
                Element element2 = element;
                if (element2 == null) {
                    Intrinsics.throwNpe();
                }
                list = stateSplitter.splitState(element2);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"if (element.isEmpty()) e\u2026ter.splitState(element!!)");
            List stateAndFileNameList = list;
            if (stateAndFileNameList.isEmpty()) {
                if (this.copiedStorageData != null) {
                    Map<String, Object> map = this.copiedStorageData;
                    if (map == null) {
                        Intrinsics.throwNpe();
                    }
                    map.clear();
                } else if (!this.originalStates.isEmpty()) {
                    this.copiedStorageData = (Map)new THashMap();
                }
                return;
            }
            THashSet existingFiles = new THashSet(stateAndFileNameList.size());
            for (com.intellij.openapi.util.Pair pair : stateAndFileNameList) {
                Object object = pair.second;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"pair.second");
                String string = (String)object;
                Object object2 = pair.first;
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"pair.first");
                this.doSetState(string, (Element)object2);
                existingFiles.add(pair.second);
            }
            for (String key : this.originalStates.keys()) {
                if (existingFiles.contains((Object)key)) continue;
                this.removeFileData(key);
            }
        }

        @Override
        public void setFileState(@NotNull String fileName, @NotNull String componentName, @Nullable Element element) {
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
            this.storage.setComponentName(componentName);
            if (element != null) {
                this.doSetState(fileName, element);
            } else {
                this.removeFileData(fileName);
            }
        }

        private final void removeFileData(String fileName) {
            if (this.copiedStorageData == null) {
                this.copiedStorageData = this.originalStates.toMutableMap();
            }
            this.isSomeFileRemoved = true;
            Map<String, Object> map = this.copiedStorageData;
            if (map == null) {
                Intrinsics.throwNpe();
            }
            map.remove(fileName);
        }

        private final void doSetState(String fileName, Element subState) {
            if (this.copiedStorageData == null) {
                this.copiedStorageData = StateMapKt.setStateAndCloneIfNeeded$default(fileName, subState, this.originalStates, null, 8, null);
                if (this.copiedStorageData != null) {
                    this.dirtyFileNames.add((Object)fileName);
                }
            } else {
                Map<String, Object> map = this.copiedStorageData;
                if (map == null) {
                    Intrinsics.throwNpe();
                }
                if (StateMapKt.updateState$default(map, fileName, subState, null, 8, null)) {
                    this.dirtyFileNames.add((Object)fileName);
                }
            }
        }

        @Nullable
        public MySaveSession createSaveSession() {
            return this.storage.checkIsSavingDisabled() || this.copiedStorageData == null ? null : this;
        }

        public void save() {
            VirtualFile dir;
            Map<String, Object> map = this.copiedStorageData;
            if (map == null) {
                Intrinsics.throwNpe();
            }
            StateMap stateMap = StateMap.Companion.fromMap(map);
            Map<String, Object> map2 = this.copiedStorageData;
            if (map2 == null) {
                Intrinsics.throwNpe();
            }
            if (map2.isEmpty()) {
                VirtualFile dir2 = this.storage.getVirtualFile();
                if (dir2 != null && dir2.exists()) {
                    dir2.delete((Object)this);
                }
                this.storage.setStorageData(stateMap);
                return;
            }
            if (!this.dirtyFileNames.isEmpty()) {
                this.saveStates(stateMap);
            }
            if (this.isSomeFileRemoved && (dir = this.storage.getVirtualFile()) != null && dir.exists()) {
                this.deleteFiles(dir);
            }
            this.storage.setStorageData(stateMap);
        }

        private final void saveStates(StateMap states) {
            VirtualFile dir = this.storage.cachedVirtualFile;
            for (String fileName : states.keys()) {
                if (!this.dirtyFileNames.contains((Object)fileName)) continue;
                if (StateMap.getElement$default(states, fileName, null, 2, null) == null) {
                    continue;
                }
                if (!(dir != null && dir.exists() || (dir = this.storage.getVirtualFile()) != null && dir.exists())) {
                    dir = SchemeLoaderKt.createDir(this.storage.dir, (StorageManagerFileWriteRequestor)this);
                    this.storage.cachedVirtualFile = dir;
                }
                try {
                    Element element;
                    PathMacroManager pathMacroManager;
                    VirtualFile file = SchemeLoaderKt.getOrCreateChild(dir, fileName, (StorageManagerFileWriteRequestor)this);
                    if (this.storage.getPathMacroSubstitutor() == null) {
                        pathMacroManager = null;
                    } else {
                        PathMacroSubstitutor pathMacroSubstitutor = this.storage.getPathMacroSubstitutor();
                        if (pathMacroSubstitutor == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.TrackingPathMacroSubstitutorImpl");
                        }
                        pathMacroManager = ((TrackingPathMacroSubstitutorImpl)pathMacroSubstitutor).getMacroManager$intellij_platform_configurationStore_impl();
                    }
                    PathMacroManager macroManager = pathMacroManager;
                    List list = CollectionsKt.listOf((Object)element);
                    String string = this.storage.getComponentName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)string));
                    String string2 = dir.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dir.path");
                    XmlDataWriter xmlDataWriter = new XmlDataWriter("component", list, map, macroManager, string2);
                    StorageManagerFileWriteRequestor storageManagerFileWriteRequestor = (StorageManagerFileWriteRequestor)this;
                    DataWriter dataWriter = xmlDataWriter;
                    LineSeparator lineSeparator = DirectoryBasedStorageKt.access$getOrDetectLineSeparator(file);
                    if (lineSeparator == null) {
                        LineSeparator lineSeparator2 = LineSeparator.getSystemLineSeparator();
                        lineSeparator = lineSeparator2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)lineSeparator2, (String)"LineSeparator.getSystemLineSeparator()");
                    }
                    FileBasedStorageKt.writeFile(null, storageManagerFileWriteRequestor, file, dataWriter, lineSeparator, false);
                }
                catch (IOException e) {
                    ComponentStoreImplKt.getLOG().error((Throwable)e);
                }
            }
        }

        private final void deleteFiles(VirtualFile dir) {
            Map<String, Object> map = this.copiedStorageData;
            if (map == null) {
                Intrinsics.throwNpe();
            }
            Map<String, Object> copiedStorageData = map;
            VirtualFile[] virtualFileArray = dir.getChildren();
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                String fileName;
                VirtualFile file;
                VirtualFile virtualFile = file = virtualFileArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile.getName(), (String)"file.name");
                if (!StringsKt.endsWith$default((String)fileName, (String)".xml", (boolean)false, (int)2, null) || copiedStorageData.containsKey(fileName)) continue;
                if (file.isWritable()) {
                    file.delete((Object)this);
                    continue;
                }
                throw (Throwable)new ReadOnlyModificationException(file, null);
            }
        }

        public MySaveSession(@NotNull DirectoryBasedStorage storage2, @NotNull StateMap originalStates) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)storage2), (String)"storage");
            Intrinsics.checkParameterIsNotNull((Object)originalStates, (String)"originalStates");
            this.storage = storage2;
            this.originalStates = originalStates;
            this.dirtyFileNames = new SmartHashSet();
        }
    }
}

