/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8.value;

import com.intellij.util.ThreeState;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.v8.protocol.FunctionValueHandle;
import org.jetbrains.v8.protocol.ScopeDescriptor;
import org.jetbrains.v8.protocol.ScopeHost;
import org.jetbrains.v8.protocol.ValueHandle;
import org.jetbrains.v8.value.V8Object;
import org.jetbrains.v8.value.V8Scope;
import org.jetbrains.v8.value.V8ScopeKt;
import org.jetbrains.v8.value.V8ValueManager;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001aH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001c\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/v8/value/V8Function;", "Lorg/jetbrains/v8/value/V8Object;", "Lorg/jetbrains/debugger/values/FunctionValue;", "valueHandle", "Lorg/jetbrains/v8/protocol/ValueHandle;", "valueManager", "Lorg/jetbrains/v8/value/V8ValueManager;", "(Lorg/jetbrains/v8/protocol/ValueHandle;Lorg/jetbrains/v8/value/V8ValueManager;)V", "functionValueHandle", "Lorg/jetbrains/v8/protocol/FunctionValueHandle;", "openParenColumn", "", "getOpenParenColumn", "()I", "openParenLine", "getOpenParenLine", "scopes", "", "Lorg/jetbrains/debugger/Scope;", "getScopes", "()[Lorg/jetbrains/debugger/Scope;", "scriptId", "getScriptId", "hasScopes", "Lcom/intellij/util/ThreeState;", "resolve", "Lorg/jetbrains/concurrency/Promise;", "intellij.javascript.v8.backend"})
public final class V8Function
extends V8Object
implements FunctionValue {
    private final FunctionValueHandle functionValueHandle;
    private final int openParenLine;
    private final int openParenColumn;

    @NotNull
    public Promise<FunctionValue> resolve() {
        return Promises.resolvedPromise((Object)this);
    }

    public final int getScriptId() {
        return this.functionValueHandle.scriptId();
    }

    public int getOpenParenLine() {
        return this.openParenLine;
    }

    public int getOpenParenColumn() {
        return this.openParenColumn;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Scope[] getScopes() {
        List<ScopeDescriptor> rawScopes = this.functionValueHandle.scopes();
        if (rawScopes.isEmpty()) {
            return null;
        }
        int n = rawScopes.size();
        Scope[] scopeArray = new Scope[n];
        int n2 = 0;
        while (n2 < n) {
            void it;
            int n3 = n2;
            int n4 = n2++;
            Scope[] scopeArray2 = scopeArray;
            boolean bl = false;
            ScopeHost scopeHost = this;
            ScopeDescriptor scopeDescriptor = rawScopes.get((int)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)scopeDescriptor, (String)"rawScopes.get(it)");
            ValueManager valueManager = this.getChildrenManager().valueManager;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueManager, (String)"childrenManager.valueManager");
            V8Scope v8Scope = V8ScopeKt.V8Scope(scopeHost, scopeDescriptor, (V8ValueManager)valueManager);
            scopeArray2[n4] = v8Scope;
        }
        return scopeArray;
    }

    @NotNull
    public ThreeState hasScopes() {
        return UtilKt.isNullOrEmpty((Collection)this.functionValueHandle.scopes()) ? ThreeState.NO : ThreeState.YES;
    }

    public V8Function(@NotNull ValueHandle valueHandle, @NotNull V8ValueManager valueManager) {
        Intrinsics.checkParameterIsNotNull((Object)valueHandle, (String)"valueHandle");
        Intrinsics.checkParameterIsNotNull((Object)((Object)valueManager), (String)"valueManager");
        super(ValueType.FUNCTION, valueHandle, valueManager);
        this.functionValueHandle = valueHandle.asObject().asFunction();
        this.openParenLine = this.functionValueHandle.line();
        this.openParenColumn = this.functionValueHandle.column();
    }
}

