/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkTableImpl;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexableFileSet;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class LightProjectDescriptor {
    public static final LightProjectDescriptor EMPTY_PROJECT_DESCRIPTOR = new LightProjectDescriptor();
    public static final String TEST_MODULE_NAME = "light_idea_test_case";

    public void setUpProject(@NotNull Project project2, @NotNull SetupHandler handler) throws Exception {
        if (project2 == null) {
            LightProjectDescriptor.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            LightProjectDescriptor.$$$reportNull$$$0(1);
        }
        WriteAction.run(() -> {
            Module module2 = this.createMainModule(project2);
            handler.moduleCreated(module2);
            VirtualFile sourceRoot = this.createSourcesRoot(module2);
            if (sourceRoot != null) {
                handler.sourceRootCreated(sourceRoot);
                this.createContentEntry(module2, sourceRoot);
            }
        });
    }

    public void registerSdk(Disposable disposable) {
        Sdk sdk = this.getSdk();
        if (sdk != null) {
            LightProjectDescriptor.registerJdk(sdk, disposable);
        }
    }

    @NotNull
    public Module createMainModule(@NotNull Project project2) {
        if (project2 == null) {
            LightProjectDescriptor.$$$reportNull$$$0(2);
        }
        Module module2 = this.createModule(project2, FileUtil.join((String[])new String[]{FileUtil.getTempDirectory(), "light_idea_test_case.iml"}));
        if (module2 == null) {
            LightProjectDescriptor.$$$reportNull$$$0(3);
        }
        return module2;
    }

    protected Module createModule(@NotNull Project project2, @NotNull String moduleFilePath) {
        if (project2 == null) {
            LightProjectDescriptor.$$$reportNull$$$0(4);
        }
        if (moduleFilePath == null) {
            LightProjectDescriptor.$$$reportNull$$$0(5);
        }
        return (Module)WriteAction.compute(() -> {
            File imlFile = new File(moduleFilePath);
            if (imlFile.exists()) {
                FileUtil.delete((File)imlFile);
            }
            return ModuleManager.getInstance((Project)project2).newModule(moduleFilePath, this.getModuleTypeId());
        });
    }

    @NotNull
    public String getModuleTypeId() {
        return "EMPTY_MODULE";
    }

    @Nullable
    public VirtualFile createSourcesRoot(@NotNull Module module2) {
        if (module2 == null) {
            LightProjectDescriptor.$$$reportNull$$$0(6);
        }
        return this.createSourceRoot(module2, "src");
    }

    protected VirtualFile createSourceRoot(@NotNull Module module2, String srcPath) {
        if (module2 == null) {
            LightProjectDescriptor.$$$reportNull$$$0(7);
        }
        VirtualFile dummyRoot = VirtualFileManager.getInstance().findFileByUrl("temp:///");
        assert (dummyRoot != null);
        dummyRoot.refresh(false, false);
        VirtualFile srcRoot = this.doCreateSourceRoot(dummyRoot, srcPath);
        this.registerSourceRoot(module2.getProject(), srcRoot);
        return srcRoot;
    }

    protected VirtualFile doCreateSourceRoot(VirtualFile root, String srcPath) {
        VirtualFile srcRoot;
        try {
            srcRoot = root.createChildDirectory((Object)this, srcPath);
            this.cleanSourceRoot(srcRoot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return srcRoot;
    }

    protected void registerSourceRoot(final Project project2, final VirtualFile srcRoot) {
        IndexableFileSet indexableFileSet = new IndexableFileSet(){

            public boolean isInSet(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return file2.getFileSystem() == srcRoot.getFileSystem() && project2.isOpen();
            }

            public void iterateIndexableFilesIn(@NotNull VirtualFile file2, final @NotNull ContentIterator iterator) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (iterator == null) {
                    1.$$$reportNull$$$0(2);
                }
                VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                    public boolean visitFile(@NotNull VirtualFile file2) {
                        if (file2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        iterator.processFile(file2);
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/LightProjectDescriptor$1$1", "visitFile"));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "iterator";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/testFramework/LightProjectDescriptor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isInSet";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "iterateIndexableFilesIn";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        FileBasedIndex.getInstance().registerIndexableSet(indexableFileSet, null);
        Disposer.register((Disposable)project2, () -> FileBasedIndex.getInstance().removeIndexableSet(indexableFileSet));
    }

    protected void createContentEntry(@NotNull Module module2, @NotNull VirtualFile srcRoot) {
        if (module2 == null) {
            LightProjectDescriptor.$$$reportNull$$$0(8);
        }
        if (srcRoot == null) {
            LightProjectDescriptor.$$$reportNull$$$0(9);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            Sdk sdk = this.getSdk();
            if (sdk != null) {
                model.setSdk(sdk);
            }
            ContentEntry contentEntry = model.addContentEntry(srcRoot);
            contentEntry.addSourceFolder(srcRoot, this.getSourceRootType());
            this.configureModule(module2, (ModifiableRootModel)model, contentEntry);
        });
    }

    private static void registerJdk(Sdk jdk, Disposable parentDisposable) {
        WriteAction.run(() -> {
            ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
            ((ProjectJdkTableImpl)jdkTable).addTestJdk(jdk, parentDisposable);
        });
    }

    @NotNull
    protected JpsModuleSourceRootType<?> getSourceRootType() {
        JavaSourceRootType javaSourceRootType = JavaSourceRootType.SOURCE;
        if (javaSourceRootType == null) {
            LightProjectDescriptor.$$$reportNull$$$0(10);
        }
        return javaSourceRootType;
    }

    @Nullable
    public Sdk getSdk() {
        return null;
    }

    private void cleanSourceRoot(@NotNull VirtualFile contentRoot) throws IOException {
        if (contentRoot == null) {
            LightProjectDescriptor.$$$reportNull$$$0(11);
        }
        TempFileSystem tempFs = (TempFileSystem)contentRoot.getFileSystem();
        for (VirtualFile child : contentRoot.getChildren()) {
            if (!tempFs.exists(child)) {
                tempFs.createChildFile((Object)this, contentRoot, child.getName());
            }
            child.delete((Object)this);
        }
    }

    protected void configureModule(@NotNull Module module2, @NotNull ModifiableRootModel model, @NotNull ContentEntry contentEntry) {
        if (module2 == null) {
            LightProjectDescriptor.$$$reportNull$$$0(12);
        }
        if (model == null) {
            LightProjectDescriptor.$$$reportNull$$$0(13);
        }
        if (contentEntry == null) {
            LightProjectDescriptor.$$$reportNull$$$0(14);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LightProjectDescriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFilePath";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcRoot";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LightProjectDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setUpProject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createMainModule";
                break;
            }
            case 3: 
            case 10: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSourcesRoot";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createSourceRoot";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createContentEntry";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "cleanSourceRoot";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "configureModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface SetupHandler {
        default public void moduleCreated(@NotNull Module module2) {
            if (module2 == null) {
                SetupHandler.$$$reportNull$$$0(0);
            }
        }

        default public void sourceRootCreated(@NotNull VirtualFile sourceRoot) {
            if (sourceRoot == null) {
                SetupHandler.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceRoot";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/testFramework/LightProjectDescriptor$SetupHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moduleCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sourceRootCreated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

