/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ws.http.request.cookies.CookieStorageInvalidFileException;
import com.intellij.ws.http.request.cookies.HttpRequestCookiesStorage;
import com.intellij.ws.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.ws.http.request.run.HttpClientResponseHandler;
import com.intellij.ws.http.request.run.HttpRequestCompositePostProcessor;
import com.intellij.ws.http.request.run.HttpRequestConsolePostProcessor;
import com.intellij.ws.http.request.run.HttpRequestHistoryManager;
import com.intellij.ws.http.request.run.HttpRequestNotifications;
import com.intellij.ws.http.request.run.HttpRequestPostProcessor;
import com.intellij.ws.http.request.run.HttpRequestValidationException;
import com.intellij.ws.http.request.run.HttpRunRequestInfo;
import com.intellij.ws.http.request.run.console.HttpResponseConsole;
import com.intellij.ws.http.request.run.console.HttpResponseOutputAdapter;
import com.intellij.ws.http.request.run.console.HttpResponsePresentation;
import com.intellij.ws.http.request.run.console.HttpSingleResponseConsole;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientControllerImpl;
import com.intellij.ws.rest.client.RestClientFileUtil;
import com.intellij.ws.rest.client.RestClientRequest;
import com.intellij.ws.rest.client.RestClientRequestProcessor;
import com.intellij.ws.rest.client.RestClientResponse;
import com.intellij.ws.rest.client.RestClientResponseListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpClientExecutionController
extends RestClientControllerImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.http.request.run.HttpClientExecutionController");
    private static final int MAX_INPLACE_SIZE = 0x100000;
    private final Project myProject;
    private final String myRequestId;
    private final RestClientRequest myRequest;
    private final HttpResponseConsole myConsole;
    private final HttpClientRequestProcessHandler myProcessHandler;
    private final HttpClientResponseHandler myResponseHandler;
    private final HttpRequestPostProcessor myRequestPostProcessor;
    private final Runnable myOnRequestFinished;
    private final boolean myForceShowResponseInplace;

    public HttpClientExecutionController(@NotNull Project project, @NotNull RestClientRequest request, @NotNull String requestId, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull HttpResponseConsole console, @Nullable HttpClientResponseHandler responseHandler, @NotNull HttpRequestPostProcessor requestPostProcessor, boolean forceShowResponseInplace, @NotNull Runnable onRequestFinished) {
        if (project == null) {
            HttpClientExecutionController.$$$reportNull$$$0(0);
        }
        if (request == null) {
            HttpClientExecutionController.$$$reportNull$$$0(1);
        }
        if (requestId == null) {
            HttpClientExecutionController.$$$reportNull$$$0(2);
        }
        if (processHandler == null) {
            HttpClientExecutionController.$$$reportNull$$$0(3);
        }
        if (console == null) {
            HttpClientExecutionController.$$$reportNull$$$0(4);
        }
        if (requestPostProcessor == null) {
            HttpClientExecutionController.$$$reportNull$$$0(5);
        }
        if (onRequestFinished == null) {
            HttpClientExecutionController.$$$reportNull$$$0(6);
        }
        super(project);
        this.myProject = project;
        this.myRequest = request;
        this.myRequestId = requestId;
        this.myConsole = console;
        this.myProcessHandler = processHandler;
        this.myResponseHandler = responseHandler;
        this.myRequestPostProcessor = requestPostProcessor;
        this.myOnRequestFinished = onRequestFinished;
        this.myForceShowResponseInplace = forceShowResponseInplace;
    }

    @NotNull
    public static HttpClientExecutionController create(@NotNull Project project, @NotNull HttpRunRequestInfo info, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull HttpResponseConsole console, @NotNull Runnable onRequestFinished, boolean showResponseInplace) throws HttpRequestValidationException {
        if (project == null) {
            HttpClientExecutionController.$$$reportNull$$$0(7);
        }
        if (info == null) {
            HttpClientExecutionController.$$$reportNull$$$0(8);
        }
        if (processHandler == null) {
            HttpClientExecutionController.$$$reportNull$$$0(9);
        }
        if (console == null) {
            HttpClientExecutionController.$$$reportNull$$$0(10);
        }
        if (onRequestFinished == null) {
            HttpClientExecutionController.$$$reportNull$$$0(11);
        }
        RestClientRequest request = info.getRequest();
        HttpClientExecutionController.loadCookiesFromJar(project, request);
        HttpClientExecutionController.convertCookieHeadersToBiscuits(request);
        String id = HttpClientExecutionController.toRequestId(request);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Executing: " + id);
        }
        HttpClientResponseHandler handler = info.getResponseHandler();
        Runnable onFinished = () -> {
            console.onRequestEnd(id);
            onRequestFinished.run();
        };
        return new HttpClientExecutionController(project, request, id, processHandler, console, handler, info.getPostProcessor(), showResponseInplace, onFinished);
    }

    private static void loadCookiesFromJar(@NotNull Project project, @NotNull RestClientRequest request) {
        if (project == null) {
            HttpClientExecutionController.$$$reportNull$$$0(12);
        }
        if (request == null) {
            HttpClientExecutionController.$$$reportNull$$$0(13);
        }
        try {
            if (request.config.isSaveCookies()) {
                HttpRequestCookiesStorage.getInstance(project).saveToRequest(request);
            }
        }
        catch (CookieStorageInvalidFileException e) {
            LOG.warn("Failed loading cookies, " + e.getMessage());
        }
    }

    @NotNull
    private static String toRequestId(@NotNull RestClientRequest request) {
        if (request == null) {
            HttpClientExecutionController.$$$reportNull$$$0(14);
        }
        String string = request.getURL();
        if (string == null) {
            HttpClientExecutionController.$$$reportNull$$$0(15);
        }
        return string;
    }

    public static void convertCookieHeadersToBiscuits(@NotNull RestClientRequest request) {
        List<String> cookieHeaders;
        if (request == null) {
            HttpClientExecutionController.$$$reportNull$$$0(16);
        }
        if ((cookieHeaders = request.getHeadersValue("Cookie")) == null || cookieHeaders.isEmpty()) {
            return;
        }
        URI uri = HttpClientExecutionController.getUrlForCookieDomain(request.urlBase);
        for (String cookieHeader : cookieHeaders) {
            for (String cookie : StringUtil.split((String)cookieHeader.trim(), (String)";")) {
                BasicClientCookie newCookie;
                String trimmedCookie = StringUtil.trimLeading((String)cookie);
                int separatorPos = trimmedCookie.indexOf(61);
                if (separatorPos == -1) {
                    newCookie = new BasicClientCookie(trimmedCookie, null);
                } else {
                    String cookieName = trimmedCookie.substring(0, separatorPos);
                    String cookieValue = trimmedCookie.substring(separatorPos + 1);
                    newCookie = new BasicClientCookie(cookieName, cookieValue);
                }
                if (uri != null) {
                    newCookie.setDomain(uri.getHost());
                    newCookie.setPath(uri.getPath());
                }
                request.addBiscuit((Cookie)newCookie);
            }
        }
        request.deleteHeader("Cookie");
    }

    @Nullable
    private static URI getUrlForCookieDomain(@Nullable String url) {
        try {
            if (StringUtil.isNotEmpty((String)url)) {
                return new URI(url);
            }
        }
        catch (URISyntaxException e) {
            LOG.warn("Cannot detect request url to set domain to cookies: " + e);
        }
        return null;
    }

    public void execute() {
        int size = this.myResponseHandler != null ? 2 : 1;
        this.myConsole.onRequestStart(this.myRequestId, size);
        final boolean saveCookies = this.myRequest.config.isSaveCookies();
        RestClientResponseListener listener = new RestClientResponseListener(){

            @Override
            public void onResponse(@Nullable String header, @NotNull String response, @Nullable String mimeType, @NotNull String status) {
                if (response == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (status == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!HttpClientExecutionController.isInterrupted(HttpClientExecutionController.this.myProcessHandler)) {
                    FileType fileType = RestClientFileUtil.findFileType(mimeType);
                    boolean inplace = response.length() < 0x100000 && HttpClientExecutionController.this.myForceShowResponseInplace;
                    HttpClientExecutionController.this.myConsole.setResponse(HttpClientExecutionController.this.myRequestId, HttpResponsePresentation.createResponse(header, response, status, inplace, saveCookies), fileType);
                }
            }

            @Override
            public void onErrorResponse(String response) {
                if (!HttpClientExecutionController.isInterrupted(HttpClientExecutionController.this.myProcessHandler)) {
                    HttpClientExecutionController.this.myConsole.setErrorResponse(HttpClientExecutionController.this.myRequestId, HttpResponsePresentation.createErrorResponse(StringUtil.notNullize((String)response)));
                }
            }

            @Override
            public void onSetCookies(Collection<Cookie> cookies) {
                HttpClientExecutionController.saveCookiesToJar(HttpClientExecutionController.this.myProject, cookies);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "response";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "status";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ws/http/request/run/HttpClientExecutionController$1";
                objectArray[2] = "onResponse";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.onGoButtonClick(this.myRequest, false, listener, new RestClientRequestProcessor[0]);
    }

    private static void saveCookiesToJar(@NotNull Project project, Collection<Cookie> cookies) {
        if (project == null) {
            HttpClientExecutionController.$$$reportNull$$$0(17);
        }
        try {
            HttpRequestCookiesStorage.getInstance(project).setCookies(cookies);
        }
        catch (CookieStorageInvalidFileException e) {
            LOG.warn("Failed saving cookies, " + e.getMessage());
        }
    }

    @Override
    protected void addToHistory(final @NotNull Project project, @NotNull RestClientRequest request, final @Nullable RestClientResponse response) {
        if (project == null) {
            HttpClientExecutionController.$$$reportNull$$$0(18);
        }
        if (request == null) {
            HttpClientExecutionController.$$$reportNull$$$0(19);
        }
        if (HttpClientExecutionController.isInterrupted(this.myProcessHandler)) {
            return;
        }
        HttpRequestPostProcessor processor = HttpClientExecutionController.createProcessor(this.myRequestId, this.myConsole, this.myRequestPostProcessor);
        HttpRequestHistoryManager.getInstance(project).addToHistory(request, response, processor);
        if (response != null && this.myResponseHandler != null) {
            EmptyProgressIndicator progressIndicator = new EmptyProgressIndicator();
            this.myProcessHandler.setPostProcessorIndicator((ProgressIndicator)progressIndicator);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(project, RestClientBundle.message("rest.client.request.response.handler.execution", new Object[0]), false){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    try {
                        HttpResponseOutputAdapter handlerPrinter = HttpClientExecutionController.this.myConsole.getResponseHandlerPrinter();
                        HttpResponseOutputAdapter testPrinter = HttpClientExecutionController.this.myConsole.getResponseHandlerTestPrinter();
                        HttpClientExecutionController.this.myResponseHandler.handle(project, response, handlerPrinter, testPrinter, HttpClientExecutionController.this.myConsole instanceof HttpSingleResponseConsole);
                    }
                    catch (ExecutionException e) {
                        String title = RestClientBundle.message("rest.client.cannot.execute.response.handler.failed.title", new Object[0]);
                        HttpRequestNotifications.showWarningBalloon(this.myProject, title, e.getMessage());
                    }
                    finally {
                        HttpClientExecutionController.this.myOnRequestFinished.run();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ws/http/request/run/HttpClientExecutionController$2", "run"));
                }
            }, (ProgressIndicator)progressIndicator);
        } else {
            this.myOnRequestFinished.run();
        }
    }

    @NotNull
    private static HttpRequestPostProcessor createProcessor(@NotNull String requestId, @NotNull HttpResponseConsole console, @NotNull HttpRequestPostProcessor processor) {
        if (requestId == null) {
            HttpClientExecutionController.$$$reportNull$$$0(20);
        }
        if (console == null) {
            HttpClientExecutionController.$$$reportNull$$$0(21);
        }
        if (processor == null) {
            HttpClientExecutionController.$$$reportNull$$$0(22);
        }
        return new HttpRequestCompositePostProcessor(processor, new HttpRequestConsolePostProcessor(requestId, console));
    }

    private static boolean isInterrupted(@NotNull ProcessHandler handler) {
        Integer code;
        if (handler == null) {
            HttpClientExecutionController.$$$reportNull$$$0(23);
        }
        return (code = handler.getExitCode()) != null && code != 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestId";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 4: 
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestPostProcessor";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onRequestFinished";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/HttpClientExecutionController";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/HttpClientExecutionController";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toRequestId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadCookiesFromJar";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toRequestId";
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "convertCookieHeadersToBiscuits";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "saveCookiesToJar";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addToHistory";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createProcessor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isInterrupted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

