/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.ws.http.request.HttpRequestVariableSubstitutor;
import com.intellij.ws.http.request.psi.HttpFilePath;
import com.intellij.ws.http.request.psi.HttpHeaderField;
import com.intellij.ws.http.request.psi.HttpHeaderFieldValue;
import com.intellij.ws.http.request.psi.HttpHost;
import com.intellij.ws.http.request.psi.HttpMethod;
import com.intellij.ws.http.request.psi.HttpMultipartField;
import com.intellij.ws.http.request.psi.HttpPathAbsolute;
import com.intellij.ws.http.request.psi.HttpPort;
import com.intellij.ws.http.request.psi.HttpQueryParameter;
import com.intellij.ws.http.request.psi.HttpQueryParameterKey;
import com.intellij.ws.http.request.psi.HttpQueryParameterValue;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestElementTypes;
import com.intellij.ws.http.request.psi.HttpRequestFilePathReferenceProvider;
import com.intellij.ws.http.request.psi.HttpRequestMessage;
import com.intellij.ws.http.request.psi.HttpRequestMessagesGroup;
import com.intellij.ws.http.request.psi.HttpRequestTarget;
import com.intellij.ws.http.request.psi.HttpResponseHandler;
import com.intellij.ws.http.request.psi.HttpResponseScript;
import com.intellij.ws.http.request.psi.HttpScheme;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestPsiImplUtil {
    private static final TokenSet PATH_TOKENS = TokenSet.create((IElementType[])new IElementType[]{HttpRequestElementTypes.SEGMENT, HttpRequestElementTypes.SEPARATOR});
    private static final Condition<PsiElement> REQUEST_PATH = element -> element != null && HttpRequestPsiImplUtil.isOfType(element, PATH_TOKENS);
    private static final Condition<PsiElement> NOT_WHITESPACE = element -> !(element instanceof PsiWhiteSpace);
    private static final String DEFAULT_HTTP_METHOD = "GET";
    private static final String DEFAULT_SCHEME = "http";
    public static final String SCHEME_SEPARATOR = "://";

    @NotNull
    public static String getHttpMethod(@NotNull HttpRequest request) {
        HttpMethod method;
        if (request == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(0);
        }
        return (method = request.getMethod()) != null ? method.getText() : DEFAULT_HTTP_METHOD;
    }

    @Nullable
    public static String getHttpUrl(@NotNull HttpRequest request, @NotNull HttpRequestVariableSubstitutor substitutor) {
        if (request == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(1);
        }
        if (substitutor == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(2);
        }
        String host = HttpRequestPsiImplUtil.getHttpHost(request, substitutor);
        HttpRequestTarget target = request.getRequestTarget();
        if (target == null) {
            return StringUtil.isNotEmpty((String)host) ? HttpRequestPsiImplUtil.addScheme(host, null) : null;
        }
        String url = HttpRequestPsiImplUtil.join(host, target.getHttpPath(substitutor));
        return StringUtil.isNotEmpty((String)url) ? HttpRequestPsiImplUtil.addScheme(url, target) : null;
    }

    @Nullable
    public static String join(@Nullable String host, @Nullable String path) {
        if (StringUtil.isEmpty((String)host)) {
            return path;
        }
        if (StringUtil.isEmpty((String)path)) {
            return host;
        }
        return StringUtil.trimEnd((String)host, (char)'/') + "/" + StringUtil.trimLeading((String)path, (char)'/');
    }

    @Nullable
    public static String getHttpHost(@NotNull HttpRequest request, @NotNull HttpRequestVariableSubstitutor substitutor) {
        HttpRequestTarget target;
        HttpHost host;
        if (request == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(3);
        }
        if (substitutor == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(4);
        }
        HttpHost httpHost = host = (target = request.getRequestTarget()) != null ? target.getHost() : null;
        if (host == null) {
            HttpHeaderField field = request.getHeaderField("Host");
            return field != null ? field.getValue(substitutor) : null;
        }
        String port = target.getPort(substitutor);
        return substitutor.getValue((PsiElement)host) + (StringUtil.isNotEmpty((String)port) ? ":" + port : "");
    }

    @NotNull
    private static String addScheme(@NotNull String url, @Nullable HttpRequestTarget target) {
        if (url == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(5);
        }
        if (URLUtil.containsScheme((String)url)) {
            String string = url;
            if (string == null) {
                HttpRequestPsiImplUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        HttpScheme scheme = target != null ? target.getScheme() : null;
        String string = (scheme != null ? scheme.getText() : DEFAULT_SCHEME) + SCHEME_SEPARATOR + url;
        if (string == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static String getPort(@NotNull HttpRequestTarget target, @NotNull HttpRequestVariableSubstitutor substitutor) {
        HttpPort port;
        if (target == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(8);
        }
        if (substitutor == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(9);
        }
        return (port = target.getPort()) != null ? substitutor.getValue((PsiElement)port) : null;
    }

    @NotNull
    public static String getHttpPath(@NotNull HttpRequestTarget target, @NotNull HttpRequestVariableSubstitutor substitutor) {
        HttpPathAbsolute absolute;
        if (target == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(10);
        }
        if (substitutor == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(11);
        }
        return (absolute = target.getPathAbsolute()) != null ? absolute.getHttpPath(substitutor) : "";
    }

    @NotNull
    public static String getHttpPath(@NotNull HttpPathAbsolute absolute, @NotNull HttpRequestVariableSubstitutor substitutor) {
        if (absolute == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(12);
        }
        if (substitutor == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(13);
        }
        String string = StringUtil.trimStart((String)substitutor.getValue((PsiElement)absolute, REQUEST_PATH), (String)"/");
        if (string == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static String getKey(@NotNull HttpQueryParameter parameter, @NotNull HttpRequestVariableSubstitutor substitutor) {
        if (parameter == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(15);
        }
        if (substitutor == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(16);
        }
        HttpQueryParameterKey key = parameter.getQueryParameterKey();
        return HttpRequestPsiImplUtil.decodeQueryParameter((PsiElement)key, substitutor);
    }

    @Nullable
    public static String getValue(@NotNull HttpQueryParameter parameter, @NotNull HttpRequestVariableSubstitutor substitutor) {
        HttpQueryParameterValue value;
        if (parameter == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(17);
        }
        if (substitutor == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(18);
        }
        return (value = parameter.getQueryParameterValue()) != null ? HttpRequestPsiImplUtil.decodeQueryParameter((PsiElement)value, substitutor) : null;
    }

    @NotNull
    private static String decodeQueryParameter(@NotNull PsiElement element, @NotNull HttpRequestVariableSubstitutor substitutor) {
        if (element == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(19);
        }
        if (substitutor == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(20);
        }
        String string = URLUtil.decode((String)substitutor.getValue(element, NOT_WHITESPACE));
        if (string == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static String getName(@NotNull HttpHeaderField field) {
        if (field == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(22);
        }
        String string = field.getHeaderFieldName().getText();
        if (string == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static String getValue(@NotNull HttpHeaderField field, @NotNull HttpRequestVariableSubstitutor substitutor) {
        HttpHeaderFieldValue element;
        if (field == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(24);
        }
        if (substitutor == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(25);
        }
        return (element = field.getHeaderFieldValue()) != null ? substitutor.getValue((PsiElement)element) : "";
    }

    @NotNull
    public static String getPresentablePath(@NotNull HttpFilePath filePath) {
        if (filePath == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(26);
        }
        String string = filePath.getText();
        if (string == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    public static PsiReference @NotNull [] getReferences(@NotNull HttpFilePath filePath) {
        if (filePath == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(28);
        }
        ArrayList references = new ArrayList();
        new HttpRequestFilePathReferenceProvider().createReferences((PsiElement)filePath, references, true);
        PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(29);
        }
        return psiReferenceArray;
    }

    @NotNull
    public static List<HttpRequestMessage> getRequestMessages(@NotNull HttpMultipartField part) {
        HttpRequestMessagesGroup group;
        if (part == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(30);
        }
        List<HttpRequestMessage> list = (group = part.getRequestMessagesGroup()) != null ? group.getRequestMessageList() : ContainerUtil.emptyList();
        if (list == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(31);
        }
        return list;
    }

    @Nullable
    public static HttpHeaderFieldValue getMultipartFieldDescription(@NotNull HttpMultipartField part) {
        HttpHeaderField description;
        if (part == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(32);
        }
        return (description = part.getHeaderField("Content-Disposition")) != null ? description.getHeaderFieldValue() : null;
    }

    @Nullable
    public static String getHeaderFieldOption(@NotNull HttpHeaderFieldValue value, @NotNull String optionName) {
        if (value == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(33);
        }
        if (optionName == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(34);
        }
        for (PsiElement child = value.getFirstChild(); child != null; child = child.getNextSibling()) {
            String option;
            if (!HttpRequestPsiImplUtil.isOfType(child, HttpRequestElementTypes.FIELD_VALUE) || (option = child.getText().trim()).length() <= optionName.length() + 1 || !option.startsWith(optionName) || option.charAt(optionName.length()) != '=') continue;
            return StringUtil.unquoteString((String)option.substring(optionName.length() + 1));
        }
        return null;
    }

    @Nullable
    public static PsiElement getResponseScriptHolder(@NotNull HttpResponseHandler responseHandler) {
        HttpResponseScript script;
        if (responseHandler == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(35);
        }
        if ((script = responseHandler.getResponseScript()) != null) {
            return script;
        }
        return responseHandler.getFilePath();
    }

    private static boolean isOfType(@NotNull PsiElement element, @NotNull IElementType type) {
        ASTNode node;
        if (element == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(36);
        }
        if (type == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(37);
        }
        return (node = element.getNode()) != null && node.getElementType() == type;
    }

    private static boolean isOfType(@NotNull PsiElement element, @NotNull TokenSet types) {
        ASTNode node;
        if (element == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(38);
        }
        if (types == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(39);
        }
        return (node = element.getNode()) != null && types.contains(node.getElementType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/psi/impl/HttpRequestPsiImplUtil";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolute";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 19: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionName";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseHandler";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/psi/impl/HttpRequestPsiImplUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addScheme";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getHttpPath";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeQueryParameter";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHttpMethod";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHttpUrl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHttpHost";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addScheme";
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 31: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPort";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHttpPath";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 17: 
            case 18: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "decodeQueryParameter";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getRequestMessages";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getMultipartFieldDescription";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderFieldOption";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getResponseScriptHolder";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

