/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.http;

import com.yourkit.util.Strings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum MediaType {
    APPLICATION_JSON("application/json", Strings.UTF_8.name()),
    APPLICATION_OCTET_STREAM("application/octet-stream", null),
    APPLICATION_PDF("application/pdf", null),
    APPLICATION_X_WWW_FORM_URLENCODED("application/x-www-form-urlencoded", null),
    APPLICATION_XML("application/xml", Strings.UTF_8.name()),
    TEXT_HTML("text/html", Strings.UTF_8.name()),
    TEXT_PLAIN("text/plain", Strings.UTF_8.name());

    @NotNull
    public final String type;
    @Nullable
    public final String encoding;

    private MediaType(String type, String encoding) {
        if (type == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.type = type;
        this.encoding = encoding;
    }

    @NotNull
    public final String getContentTypeAndEncoding() {
        StringBuilder b = new StringBuilder(this.type);
        if (this.encoding != null) {
            b.append(";").append("charset=").append(this.encoding);
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }
}

