/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.Constants;
import com.yourkit.util.BoolRef;
import com.yourkit.util.FileUtil;
import com.yourkit.util.Strings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public final class IoUtil {
    public static void copy(@NotNull InputStream in, @NotNull OutputStream out) throws IOException {
        int length;
        if (in == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        byte[] buffer = new byte[4096];
        while ((length = in.read(buffer)) != -1) {
            out.write(buffer, 0, length);
        }
    }

    public static boolean equalPaths(@NotNull File file1, @NotNull File file2) {
        if (file1 == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (file2 == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (Constants.OS_WINDOWS) {
            return IoUtil.normalize(file1).equalsIgnoreCase(IoUtil.normalize(file2));
        }
        return IoUtil.normalize(file1).equals(IoUtil.normalize(file2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String normalize(@NotNull File file) {
        String string;
        String string2;
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException ignored) {
            String absolutePath = file.getAbsolutePath();
            string = Constants.OS_WINDOWS ? absolutePath.toLowerCase() : absolutePath;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = string2;
        if (string2 == null) throw new IllegalStateException("Method must not return null");
        return string;
    }

    public static boolean hasExtension(@NotNull File file, @NotNull String extension) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        return IoUtil.hasExtension(file.getName(), extension);
    }

    public static boolean hasExtension(@NotNull String fileName, @NotNull String extension) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (Constants.OS_WINDOWS) {
            return fileName.toLowerCase().endsWith(extension);
        }
        return fileName.endsWith(extension);
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int index = fileName.lastIndexOf(46);
        String string = index == -1 ? fileName : fileName.substring(0, index);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int index = fileName.lastIndexOf(46);
        String string = index == -1 ? "" : fileName.substring(index);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static void visitDirectoryInDepth(@NotNull File dir, @NotNull DirectoryVisitor visitor) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                visitor.visitDirectoryBeforeVisitingContent(file);
                IoUtil.visitDirectoryInDepth(file, visitor);
                visitor.visitDirectoryAfterVisitingContent(file);
                continue;
            }
            visitor.visitFile(file);
        }
    }

    public static void visitDirectoryPlain(@NotNull File dir, @NotNull DirectoryVisitor visitor) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            visitor.visitFile(file);
        }
    }

    public static void readContent(@NotNull Reader reader, @NotNull StringBuilder buffer) throws IOException {
        int readCharCount;
        if (reader == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        char[] buff = new char[4096];
        while ((readCharCount = reader.read(buff, 0, buff.length)) != -1) {
            buffer.append(buff, 0, readCharCount);
        }
    }

    @NotNull
    public static byte[] readFileContent(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        byte[] byArray = FileUtil.readFileContent(file);
        if (byArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return byArray;
    }

    @NotNull
    public static String readFileContentAsUtf8(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        byte[] bytes = IoUtil.readFileContent(file);
        String string = Strings.createUtf8String(bytes);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static void readByLine(@NotNull InputStream stream, @NotNull Charset charset, @NotNull LineIterator iterator) throws IOException {
        boolean ok;
        String line;
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (iterator == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
        int lineNumber = 1;
        while ((line = reader.readLine()) != null && (ok = iterator.readLine(line, lineNumber))) {
            ++lineNumber;
        }
    }

    public static void readByLine(@NotNull InputStream stream, @NotNull LineIterator iterator) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (iterator == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        IoUtil.readByLine(stream, Strings.UTF_8, iterator);
    }

    public static void readByLine(@NotNull File file, @NotNull LineIterator iterator) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (iterator == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
            IoUtil.readByLine(stream, iterator);
        }
    }

    private static void appendUtf8(@NotNull File file, @NotNull String str, boolean appendLn) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (str == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        IoUtil.ensureParentDirsExist(file);
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file, true)), Strings.UTF_8);){
            w.write(str);
            if (appendLn) {
                w.write("\n");
            }
        }
    }

    public static void appendUtf8(@NotNull File file, @NotNull String str) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (str == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        IoUtil.appendUtf8(file, str, false);
    }

    public static void appendlnUtf8(@NotNull File file, @NotNull String str) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (str == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        IoUtil.appendUtf8(file, str, true);
    }

    private static void ensureParentDirsExist(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    public static void writeUtf8(@NotNull File file, @NotNull String str) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (str == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        IoUtil.ensureParentDirsExist(file);
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), Strings.UTF_8);){
            w.write(str);
        }
    }

    public static void write(@NotNull File file, @NotNull byte[] content) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        IoUtil.ensureParentDirsExist(file);
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file, false));){
            stream.write(content);
        }
    }

    public static boolean delete(@NotNull File file) throws IOException {
        boolean ok;
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        final BoolRef error = new BoolRef();
        if (file.isDirectory()) {
            IoUtil.visitDirectoryInDepth(file, new DirectoryVisitorAdapter(){

                @Override
                public void visitFile(@NotNull File file) {
                    if (file == null) {
                        throw new IllegalArgumentException("Parameter 1 must not be null");
                    }
                    if (!file.delete()) {
                        error.set(true);
                    }
                }

                @Override
                public void visitDirectoryAfterVisitingContent(@NotNull File directory) {
                    if (directory == null) {
                        throw new IllegalArgumentException("Parameter 1 must not be null");
                    }
                    if (!directory.delete()) {
                        error.set(true);
                    }
                }
            });
        }
        return (ok = file.delete()) && !error.get();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String expand(@NotNull String path) {
        String string;
        if (path == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String _path = path.replace('\\', '/');
        if (_path.startsWith("~/")) {
            string = (Constants.OS_WINDOWS ? "C:/" : Constants.USER_HOME.getAbsolutePath() + '/') + _path.substring(2);
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = path;
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    @NotNull
    public static File expandAsFile(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return new File(IoUtil.expand(path));
    }

    public static abstract class AllLineIterator
    implements LineIterator {
        protected abstract void readLineImpl(@NotNull String var1, int var2);

        @Override
        public boolean readLine(@NotNull String line, int lineNumber) {
            if (line == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            this.readLineImpl(line, lineNumber);
            return true;
        }
    }

    public static interface LineIterator {
        public boolean readLine(@NotNull String var1, int var2);
    }

    public static class DirectoryVisitorAdapter
    implements DirectoryVisitor {
        @Override
        public void visitFile(@NotNull File file) throws IOException {
            if (file == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
        }

        @Override
        public void visitDirectoryBeforeVisitingContent(@NotNull File directory) throws IOException {
            if (directory == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
        }

        @Override
        public void visitDirectoryAfterVisitingContent(@NotNull File directory) throws IOException {
            if (directory == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
        }
    }

    public static interface DirectoryVisitor {
        public void visitFile(@NotNull File var1) throws IOException;

        public void visitDirectoryBeforeVisitingContent(@NotNull File var1) throws IOException;

        public void visitDirectoryAfterVisitingContent(@NotNull File var1) throws IOException;
    }
}

