/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.ui;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.AutodetectLinterPackage;
import com.intellij.lang.javascript.linter.tslint.TsLintBundle;
import com.intellij.lang.javascript.linter.tslint.TslintUtil;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileTexts;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileView;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class TslintPanel {
    private static final JSLinterConfigFileTexts CONFIG_TEXTS = TslintPanel.getConfigTexts();
    private final Project myProject;
    private final JSLinterConfigFileView myConfigFileView;
    private final boolean myFullModeDialog;
    private final boolean myAddLeftIndent;
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final NodePackageField myNodePackageField;
    private TextFieldWithBrowseButton myRules;
    private JBCheckBox myAllowJs;

    public TslintPanel(@NotNull Project project, boolean fullModeDialog, boolean addLeftIndent) {
        if (project == null) {
            TslintPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myConfigFileView = new JSLinterConfigFileView(project, CONFIG_TEXTS, null);
        this.myFullModeDialog = fullModeDialog;
        this.myAddLeftIndent = addLeftIndent;
        this.myConfigFileView.setAdditionalConfigFilesProducer(() -> TslintUtil.findAllConfigsInScope(project));
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myNodePackageField = AutodetectLinterPackage.createNodePackageField(Collections.singletonList("tslint"), (NodeJsInterpreterField)this.myNodeInterpreterField, (JSLinterConfigFileView)this.myConfigFileView);
    }

    @NotNull
    public JComponent createComponent() {
        this.myRules = new TextFieldWithBrowseButton();
        this.myAllowJs = new JBCheckBox();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)this.myProject, (TextFieldWithBrowseButton)this.myRules, (String)TsLintBundle.message("additional.rules.directory.title", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        FormBuilder nodeFieldsWrapperBuilder = FormBuilder.createFormBuilder().setHorizontalGap(10).setVerticalGap(4);
        if (this.myAddLeftIndent) {
            nodeFieldsWrapperBuilder.setFormLeftIndent(10);
        }
        nodeFieldsWrapperBuilder.addLabeledComponent(NodeJsInterpreterField.getLabelTextForComponent(), (JComponent)this.myNodeInterpreterField).addLabeledComponent(TsLintBundle.message("tslint.package.label", new Object[0]), (JComponent)this.myNodePackageField);
        FormBuilder builder = FormBuilder.createFormBuilder().setHorizontalGap(10).setVerticalGap(4);
        if (this.myAddLeftIndent) {
            builder.setFormLeftIndent(10);
        }
        JPanel panel = builder.addComponent((JComponent)nodeFieldsWrapperBuilder.getPanel()).addComponent((JComponent)this.myConfigFileView.getComponent()).addSeparator(4).addVerticalGap(4).addLabeledComponent(TsLintBundle.message("additional.rules.directory.label", new Object[0]), (JComponent)this.myRules).addLabeledComponent(TsLintBundle.message("lint.javascript.files.label", new Object[0]), (JComponent)this.myAllowJs).getPanel();
        JPanel centerPanel = SwingHelper.wrapWithHorizontalStretch((JComponent)panel);
        centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JPanel jPanel = centerPanel;
        if (jPanel == null) {
            TslintPanel.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    public void handleEnableStatusChanged(boolean enabled) {
        NodePackageRef selectedRef = this.myNodePackageField.getSelectedRef();
        if (selectedRef == AutodetectLinterPackage.INSTANCE) {
            this.myConfigFileView.setEnabled(false);
        }
        this.myConfigFileView.onEnabledStateChanged(enabled);
    }

    @NotNull
    public TsLintState getState() {
        TsLintState.Builder builder = new TsLintState.Builder().setNodePath(this.myNodeInterpreterField.getInterpreterRef()).setNodePackageRef(this.myNodePackageField.getSelectedRef()).setCustomConfigFileUsed(this.myConfigFileView.isCustomConfigFileUsed()).setCustomConfigFilePath(this.myConfigFileView.getCustomConfigFilePath()).setAllowJs(this.myAllowJs.isSelected());
        if (!StringUtil.isEmptyOrSpaces((String)this.myRules.getText())) {
            builder.setRulesDirectory(this.myRules.getText().trim());
        }
        TsLintState tsLintState = builder.build();
        if (tsLintState == null) {
            TslintPanel.$$$reportNull$$$0(2);
        }
        return tsLintState;
    }

    public void setState(@NotNull TsLintState state) {
        if (state == null) {
            TslintPanel.$$$reportNull$$$0(3);
        }
        this.myNodeInterpreterField.setInterpreterRef(state.getInterpreterRef());
        this.myNodePackageField.setSelectedRef(state.getNodePackageRef());
        this.myConfigFileView.setCustomConfigFileUsed(state.isCustomConfigFileUsed());
        this.myConfigFileView.setCustomConfigFilePath(StringUtil.notNullize((String)state.getCustomConfigFilePath()));
        if (!StringUtil.isEmptyOrSpaces((String)state.getRulesDirectory())) {
            this.myRules.setText(state.getRulesDirectory());
        }
        this.myAllowJs.setSelected(state.isAllowJs());
        this.resizeOnSeparateDialog();
    }

    private void resizeOnSeparateDialog() {
        if (this.myFullModeDialog) {
            this.myNodeInterpreterField.setPreferredWidthToFitText();
            this.myConfigFileView.setPreferredWidthToComponents();
        }
    }

    private static JSLinterConfigFileTexts getConfigTexts() {
        return new JSLinterConfigFileTexts(JavaScriptBundle.message((String)"javascript.linter.configurable.config.autoSearch.title", (Object[])new Object[0]), TsLintBundle.message("tslint.configurable.search.option.description", new Object[0]), TsLintBundle.message("tslint.configuration.file.title", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/ui/TslintPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/ui/TslintPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

