/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.config;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.linter.AutodetectLinterPackage;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.tslint.config.TsLintConfiguration;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class TslintOptionsUsageCollector
extends ProjectUsagesCollector {
    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        NodePackage constantPackage;
        NodePackageRef nodePackageRef;
        ExtendedLinterState extendedState;
        if (project == null) {
            TslintOptionsUsageCollector.$$$reportNull$$$0(0);
        }
        if (!(extendedState = TsLintConfiguration.getInstance(project).getExtendedState()).isEnabled()) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                TslintOptionsUsageCollector.$$$reportNull$$$0(1);
            }
            return set;
        }
        HashSet<MetricEvent> set = new HashSet<MetricEvent>();
        set.add(new MetricEvent("enabled"));
        TsLintState state = (TsLintState)extendedState.getState();
        if (!ObjectUtils.equals((Object)state.getInterpreterRef(), (Object)TsLintState.DEFAULT.getInterpreterRef())) {
            set.add(new MetricEvent("node.interpreter.custom"));
        }
        if ((nodePackageRef = state.getNodePackageRef()) == AutodetectLinterPackage.INSTANCE) {
            set.add(new MetricEvent("node.package.autodetect"));
        }
        if ((constantPackage = nodePackageRef.getConstantPackage()) != null && !constantPackage.isEmptyPath()) {
            set.add(new MetricEvent("node.package.custom.package"));
        }
        if (StringUtil.isNotEmpty((String)state.getRulesDirectory())) {
            set.add(new MetricEvent("additional.rules.specified"));
        }
        if (state.isCustomConfigFileUsed() && StringUtil.isNotEmpty((String)state.getCustomConfigFilePath())) {
            set.add(new MetricEvent("custom.config.specified"));
        }
        HashSet<MetricEvent> hashSet = set;
        if (hashSet == null) {
            TslintOptionsUsageCollector.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @NotNull
    public String getGroupId() {
        return "js.tslint.options";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/config/TslintOptionsUsageCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/config/TslintOptionsUsageCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

