/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.uml.utils.UmlJavaUtils;
import org.jetbrains.annotations.Nullable;

public class JavaUmlVfsResolver
implements DiagramVfsResolver<PsiElement> {
    public String getQualifiedName(PsiElement element) {
        return UmlJavaUtils.getFQN(element);
    }

    public PsiElement resolveElementByFQN(String fqn, Project project) {
        return (PsiElement)ReadAction.compute(() -> {
            JavaPsiFacade facadeEx = JavaPsiFacade.getInstance((Project)project);
            PsiClass psiClass = facadeEx.findClass(fqn, GlobalSearchScope.allScope((Project)project));
            return psiClass == null ? facadeEx.findPackage(fqn) : psiClass;
        });
    }

    @Nullable
    public PsiElement resolveInitElementByFQN(String fqn, Project project) {
        return StringUtil.isEmpty((String)fqn) ? null : this.resolveElementByFQN(fqn, project);
    }
}

