/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.dialogs.RelocateDialog;
import org.jetbrains.idea.svn.info.Info;

public class RelocateAction
extends BasicAction {
    private static final Logger LOG = Logger.getInstance(RelocateAction.class);

    @Override
    @NotNull
    protected String getActionName() {
        return "Relocate working copy to a different URL";
    }

    @Override
    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        if (vcs == null) {
            RelocateAction.$$$reportNull$$$0(0);
        }
        if (file == null) {
            RelocateAction.$$$reportNull$$$0(1);
        }
        return SvnStatusUtil.isUnderControl(vcs, file);
    }

    @Override
    protected void perform(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull DataContext context) {
        String afterURL;
        Info info2;
        if (vcs == null) {
            RelocateAction.$$$reportNull$$$0(2);
        }
        if (file == null) {
            RelocateAction.$$$reportNull$$$0(3);
        }
        if (context == null) {
            RelocateAction.$$$reportNull$$$0(4);
        }
        if ((info2 = vcs.getInfo(file)) == null) {
            LOG.info("Could not get info for " + file);
            return;
        }
        RelocateDialog dlg = new RelocateDialog(vcs.getProject(), info2.getUrl());
        if (!dlg.showAndGet()) {
            return;
        }
        String beforeURL = dlg.getBeforeURL();
        if (beforeURL.equals(afterURL = dlg.getAfterURL())) {
            return;
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setIndeterminate(true);
            }
            try {
                File path = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                vcs.getFactory(path).createRelocateClient().relocate(path, SvnUtil.createUrl(beforeURL, false), SvnUtil.createUrl(afterURL, false));
                VcsDirtyScopeManager.getInstance((Project)vcs.getProject()).markEverythingDirty();
            }
            catch (VcsException e) {
                WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)vcs.getProject(), (String)("Error relocating working copy: " + e.getMessage()), (String)"Relocate Working Copy"), null, (Project)vcs.getProject());
            }
        }, "Relocating Working Copy", false, vcs.getProject());
    }

    @Override
    protected void batchPerform(@NotNull SvnVcs vcs, VirtualFile @NotNull [] files, @NotNull DataContext context) {
        if (vcs == null) {
            RelocateAction.$$$reportNull$$$0(5);
        }
        if (context == null) {
            RelocateAction.$$$reportNull$$$0(6);
        }
        if (files == null) {
            RelocateAction.$$$reportNull$$$0(7);
        }
    }

    @Override
    protected boolean isBatchAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/actions/RelocateAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "batchPerform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

