/*
 * Decompiled with CFR 0.152.
 */
package ini4idea.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import ini4idea.lang.IniElementTypes;
import ini4idea.lang.psi.stubs.IniStubElementTypes;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class IniFoldingBuilder
implements FoldingBuilder,
DumbAware {
    private static final Logger LOG = Logger.getInstance(IniFoldingBuilder.class);
    private static final TokenSet SECTIONS_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{IniElementTypes.INI_SECTION});

    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            IniFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            IniFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (node.getElementType() == IniStubElementTypes.FILE) {
            ASTNode[] sections = node.getChildren(SECTIONS_TOKEN_SET);
            ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>(sections.length);
            for (ASTNode section : sections) {
                if (section.findChildByType(IniElementTypes.INI_SECTION_NAME) == null) continue;
                descriptors.add(new FoldingDescriptor(section, section.getTextRange()));
            }
            FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(FoldingDescriptor.EMPTY);
            if (foldingDescriptorArray == null) {
                IniFoldingBuilder.$$$reportNull$$$0(2);
            }
            return foldingDescriptorArray;
        }
        if (FoldingDescriptor.EMPTY == null) {
            IniFoldingBuilder.$$$reportNull$$$0(3);
        }
        return FoldingDescriptor.EMPTY;
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            IniFoldingBuilder.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(node.getElementType() == IniElementTypes.INI_SECTION, (Object)node.getElementType().toString());
        ASTNode sectionName = node.findChildByType(IniElementTypes.INI_SECTION_NAME);
        LOG.assertTrue(sectionName != null, (Object)("Empty section name in \n" + node.getText()));
        return sectionName.getText();
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            IniFoldingBuilder.$$$reportNull$$$0(5);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ini4idea/folding/IniFoldingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ini4idea/folding/IniFoldingBuilder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

