/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.execution.core;

import com.intellij.credentialStore.OneTimeString;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParameters;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterLoginKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterClient;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterClientImpl;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServer;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServerStatus;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.DefaultHttpSession;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.HttpSession;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpec;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001dH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterServerImpl;", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterServer;", "connectionParameters", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;", "latestStatus", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterServerStatus;", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterServerStatus;)V", "_client", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterClient;", "client", "getClient", "()Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterClient;", "getConnectionParameters", "()Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;", "httpSession", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;", "<set-?>", "", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;", "kernelSpecs", "getKernelSpecs", "()Ljava/util/List;", "getLatestStatus", "()Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterServerStatus;", "setLatestStatus", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterServerStatus;)V", "lock", "", "dispose", "", "logIn", "passwordOrToken", "Lcom/intellij/credentialStore/OneTimeString;", "updateKernelSpecs", "intellij.python.jupyter"})
public final class JupyterServerImpl
implements JupyterServer {
    private final Object lock;
    private final HttpSession httpSession;
    private JupyterClient _client;
    @Nullable
    private volatile List<? extends JupyterKernelSpec> kernelSpecs;
    @NotNull
    private final JupyterConnectionParameters connectionParameters;
    @Nullable
    private JupyterServerStatus latestStatus;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public JupyterClient getClient() {
        JupyterClient jupyterClient;
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            JupyterClient jupyterClient2 = this._client;
            if (jupyterClient2 == null) {
                JupyterClientImpl jupyterClientImpl = new JupyterClientImpl(this.getConnectionParameters(), this.httpSession);
                boolean bl4 = false;
                boolean bl5 = false;
                JupyterClientImpl it = jupyterClientImpl;
                boolean bl6 = false;
                this._client = it;
                jupyterClient2 = jupyterClientImpl;
            }
            jupyterClient = jupyterClient2;
        }
        return jupyterClient;
    }

    @Override
    @Nullable
    public List<JupyterKernelSpec> getKernelSpecs() {
        return this.kernelSpecs;
    }

    @Override
    public void updateKernelSpecs() {
        this.kernelSpecs = this.getClient().getKernelSpecs();
    }

    @Override
    public void logIn(@NotNull OneTimeString passwordOrToken) {
        Intrinsics.checkParameterIsNotNull((Object)passwordOrToken, (String)"passwordOrToken");
        JupyterLoginKt.logInToJupyterServer(this.httpSession, passwordOrToken);
    }

    @Override
    public void dispose() {
        this.latestStatus = null;
    }

    @Override
    @NotNull
    public JupyterConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }

    @Nullable
    public final JupyterServerStatus getLatestStatus() {
        return this.latestStatus;
    }

    public final void setLatestStatus(@Nullable JupyterServerStatus jupyterServerStatus) {
        this.latestStatus = jupyterServerStatus;
    }

    public JupyterServerImpl(@NotNull JupyterConnectionParameters connectionParameters, @Nullable JupyterServerStatus latestStatus) {
        Intrinsics.checkParameterIsNotNull((Object)connectionParameters, (String)"connectionParameters");
        this.connectionParameters = connectionParameters;
        this.latestStatus = latestStatus;
        this.lock = new Object();
        this.httpSession = new DefaultHttpSession(this.getConnectionParameters());
    }

    public /* synthetic */ JupyterServerImpl(JupyterConnectionParameters jupyterConnectionParameters, JupyterServerStatus jupyterServerStatus, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            jupyterServerStatus = null;
        }
        this(jupyterConnectionParameters, jupyterServerStatus);
    }
}

