/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.web2py.project;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.newProject.PyFrameworkProjectGenerator;
import com.jetbrains.python.newProject.PythonProjectGenerator;
import com.jetbrains.python.remote.PyProjectSynchronizer;
import com.jetbrains.python.run.PyRunConfigurationFactory;
import com.jetbrains.python.run.PythonRunConfigurationParams;
import com.jetbrains.python.templateLanguages.TemplatesService;
import com.jetbrains.web2py.project.Web2PyNewProjectSettings;
import com.jetbrains.web2py.project.Web2PyProjectCreatePanel;
import icons.PythonUltimateIcons;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Web2PyProjectGenerator
extends PythonProjectGenerator<Web2PyNewProjectSettings>
implements PyFrameworkProjectGenerator {
    private static final String ourLinkToDownload = "http://www.web2py.com/examples/static/web2py_src.zip";
    private Web2PyProjectCreatePanel myWeb2PyPanel;

    @Override
    @NotNull
    public String getFrameworkTitle() {
        return "Web2Py";
    }

    @Override
    public boolean isFrameworkInstalled(@NotNull Sdk sdk) {
        if (sdk == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Override
    public boolean supportsPython3() {
        return true;
    }

    public Icon getLogo() {
        return PythonUltimateIcons.Web2py.Web2py_logo;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = PythonProBundle.message("python.web2py.name");
        if (string == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public JComponent getSettingsPanel(File baseDir) throws ProcessCanceledException {
        this.myWeb2PyPanel = new Web2PyProjectCreatePanel();
        this.myWeb2PyPanel.registerValidators(() -> this.fireStateChanged());
        return this.myWeb2PyPanel;
    }

    @Override
    public Web2PyNewProjectSettings getProjectSettings() {
        Web2PyNewProjectSettings settings = new Web2PyNewProjectSettings();
        this.myWeb2PyPanel.saveSettings(settings);
        return settings;
    }

    @Override
    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Web2PyNewProjectSettings settings, @NotNull Module module, @Nullable PyProjectSynchronizer synchronizer) {
        if (project == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(2);
        }
        if (baseDir == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(4);
        }
        if (module == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(5);
        }
        assert (settings != null);
        String web2PyFolder = settings.getWeb2PyFolder();
        File web2pyDir = new File(baseDir.getPath() + "/web2py");
        boolean created = FileUtil.createDirectory((File)web2pyDir);
        if (!created) {
            SwingUtilities.invokeLater(() -> Messages.showErrorDialog((String)PythonProBundle.message("python.web2py.error.creating.project"), (String)PythonProBundle.message("python.web2py.project.creation.failed")));
            return;
        }
        if (!StringUtil.isEmptyOrSpaces((String)web2PyFolder)) {
            Web2PyProjectGenerator.copyExistingWeb2Py(web2pyDir, web2PyFolder);
        } else {
            Web2PyProjectGenerator.downloadWeb2Py(project, web2pyDir);
        }
        String applicationName = settings.getApplicationName();
        Web2PyProjectGenerator.createApplication(web2pyDir, applicationName);
        VirtualFile web2Py = LocalFileSystem.getInstance().refreshAndFindFileByPath(web2pyDir.getPath());
        Web2PyProjectGenerator.addWeb2PySourceRoots(project, baseDir, web2Py);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            TemplatesService service = TemplatesService.getInstance(module);
            service.setTemplateLanguage("Web2Py");
            PythonRunConfigurationParams configuration = PyRunConfigurationFactory.getInstance().createPythonScriptRunConfiguration(module, web2pyDir.getPath() + "/web2py.py");
            configuration.getBaseParams().setWorkingDirectory(web2pyDir.getPath());
            ApplicationManager.getApplication().invokeLater(() -> {
                PsiFile controllerPsiFile;
                VirtualFile controllerFile;
                PsiFile viewPsiFile;
                String appName = StringUtil.isEmptyOrSpaces((String)applicationName) ? "welcome" : applicationName;
                VirtualFile viewFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(web2pyDir.getPath() + "/applications/" + appName + "/views/default/index.html");
                if (viewFile != null && (viewPsiFile = PsiManager.getInstance((Project)project).findFile(viewFile)) != null) {
                    viewPsiFile.navigate(false);
                }
                if ((controllerFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(web2pyDir.getPath() + "/applications/" + appName + "/controllers/default.py")) != null && (controllerPsiFile = PsiManager.getInstance((Project)project).findFile(controllerFile)) != null) {
                    controllerPsiFile.navigate(true);
                }
            });
        });
    }

    public static void addWeb2PySourceRoots(@NotNull Project project, @NotNull VirtualFile baseDir, @Nullable VirtualFile web2Py) {
        VirtualFile sitePackages;
        if (project == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(6);
        }
        if (baseDir == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(7);
        }
        if (web2Py != null && (sitePackages = web2Py.findChild("site-packages")) != null) {
            Web2PyProjectGenerator.addSourceRoot(project, baseDir, sitePackages);
        }
        Web2PyProjectGenerator.addSourceRoot(project, baseDir, web2Py);
    }

    private static void createApplication(@NotNull File baseDir, @NotNull String applicationName) {
        if (baseDir == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(8);
        }
        if (applicationName == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(9);
        }
        if (!StringUtil.isEmptyOrSpaces((String)applicationName)) {
            File appDir = new File(baseDir.getPath() + "/applications/" + applicationName);
            boolean created = FileUtil.createDirectory((File)appDir);
            if (created) {
                try {
                    FileUtil.copyDirContent((File)new File(baseDir.getPath() + "/applications/welcome"), (File)appDir);
                }
                catch (IOException e) {
                    SwingUtilities.invokeLater(() -> Messages.showErrorDialog((String)PythonProBundle.message("python.web2py.failed.to.create.application", applicationName), (String)PythonProBundle.message("python.web2py.project.creation.failed")));
                }
            } else {
                SwingUtilities.invokeLater(() -> Messages.showErrorDialog((String)PythonProBundle.message("python.web2py.failed.to.create.application", applicationName), (String)PythonProBundle.message("python.web2py.project.creation.failed")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadWeb2Py(@NotNull Project project, @NotNull File baseDir) {
        File tempFile;
        if (project == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(10);
        }
        if (baseDir == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(11);
        }
        try {
            tempFile = FileUtil.createTempFile((String)"web2py-generator", null);
        }
        catch (IOException e) {
            SwingUtilities.invokeLater(() -> Messages.showErrorDialog((String)PythonProBundle.message("python.web2py.cant.download", ourLinkToDownload), (String)PythonProBundle.message("python.web2py.project.creation.failed")));
            return;
        }
        try {
            Web2PyProjectGenerator.downloadAndUnzip(project, ourLinkToDownload, tempFile, baseDir);
        }
        catch (GeneratorException e) {
            SwingUtilities.invokeLater(() -> Messages.showErrorDialog((String)PythonProBundle.message("python.web2py.cant.download", ourLinkToDownload), (String)PythonProBundle.message("python.web2py.project.creation.failed")));
        }
        finally {
            FileUtil.delete((File)tempFile);
        }
    }

    private static void copyExistingWeb2Py(@NotNull File baseDir, @NotNull String web2PyFolder) {
        if (baseDir == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(12);
        }
        if (web2PyFolder == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(13);
        }
        File file2 = new File(web2PyFolder);
        try {
            FileUtil.copyDirContent((File)file2, (File)baseDir);
        }
        catch (IOException e) {
            SwingUtilities.invokeLater(() -> Messages.showErrorDialog((String)e.getMessage(), (String)PythonProBundle.message("python.web2py.project.creation.failed")));
        }
    }

    private static void downloadAndUnzip(@Nullable Project project, @NotNull String url, @NotNull File tempFile, @NotNull File extractToDir) throws GeneratorException {
        if (url == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(14);
        }
        if (tempFile == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(15);
        }
        if (extractToDir == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(16);
        }
        GithubDownloadUtil.downloadContentToFileWithProgressSynchronously((Project)project, (String)url, (String)PythonProBundle.message("python.web2py.download.progress.title"), (File)tempFile, (String)"web2py", (String)"web2py", (boolean)false);
        ZipUtil.unzipWithProgressSynchronously((Project)project, (String)PythonProBundle.message("python.web2py.unzip.progress.title"), (File)tempFile, (File)extractToDir, (boolean)true);
    }

    @NotNull
    public ValidationResult validate(@NotNull String baseDirPath) {
        String projectName;
        if (baseDirPath == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(17);
        }
        if (!StringUtil.isJavaIdentifier((String)(projectName = PythonStringUtil.getLastSuffix(baseDirPath, String.valueOf(File.separatorChar))))) {
            return new ValidationResult(PythonProBundle.message("python.web2py.wrong.project.name.validation.error.message"));
        }
        ValidationResult validationResult = this.myWeb2PyPanel != null ? this.myWeb2PyPanel.getValidationResult(projectName) : ValidationResult.OK;
        if (validationResult == null) {
            Web2PyProjectGenerator.$$$reportNull$$$0(18);
        }
        return validationResult;
    }

    @Override
    @Nullable
    public ValidationResult warningValidation(@Nullable Sdk sdk) {
        if (this.myWeb2PyPanel == null) {
            return ValidationResult.OK;
        }
        return this.myWeb2PyPanel.getWarnings();
    }

    public static void addSourceRoot(Project project, VirtualFile baseDir, VirtualFile root) {
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (modules.length > 0 && root != null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                ContentEntry[] contentEntries;
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)modules[0]).getModifiableModel();
                for (ContentEntry contentEntry : contentEntries = model.getContentEntries()) {
                    if (!Comparing.equal((Object)contentEntry.getFile(), (Object)baseDir)) continue;
                    contentEntry.addSourceFolder(root, false);
                }
                model.commit();
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/web2py/project/Web2PyProjectGenerator";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "web2PyFolder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractToDir";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/web2py/project/Web2PyProjectGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFrameworkInstalled";
                break;
            }
            case 1: 
            case 18: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addWeb2PySourceRoots";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createApplication";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "downloadWeb2Py";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyExistingWeb2Py";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "downloadAndUnzip";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

