/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.templateLanguages;

import com.intellij.facet.impl.ui.FacetErrorPanel;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.actions.ContentEntryEditingAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.module.PyContentEntriesEditor;
import com.jetbrains.python.module.PyRootTypeProvider;
import com.jetbrains.python.templateLanguages.PyTemplatesBundle;
import com.jetbrains.python.templateLanguages.TemplatesService;
import icons.PythonIcons;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTemplateRootProvider
extends PyRootTypeProvider {
    private final MultiMap<ContentEntry, VirtualFilePointer> myTemplateRoots = new MultiMap();
    @Nullable
    private Runnable myListener;

    @Override
    public void reset(@NotNull Disposable disposable, PyContentEntriesEditor editor2, final @NotNull Module module) {
        if (disposable == null) {
            PyTemplateRootProvider.$$$reportNull$$$0(0);
        }
        if (module == null) {
            PyTemplateRootProvider.$$$reportNull$$$0(1);
        }
        this.myTemplateRoots.clear();
        TemplatesService instance = TemplatesService.getInstance(module);
        if (instance != null) {
            List<VirtualFile> folders = instance.getTemplateFolders();
            for (VirtualFile folder : folders) {
                ContentEntry contentEntry = PyTemplateRootProvider.findContentEntryForFile(folder, editor2);
                if (contentEntry == null) continue;
                this.myTemplateRoots.putValue((Object)contentEntry, (Object)VirtualFilePointerManager.getInstance().create(folder, disposable, this.DUMMY_LISTENER));
            }
        }
        FacetErrorPanel panel2 = editor2.getWarningPanel();
        panel2.getValidatorsManager().registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                boolean isTemplateLangConfigured = TemplatesService.getInstance(module).getTemplateLanguage() == "None" && !PyTemplateRootProvider.this.myTemplateRoots.isEmpty();
                ValidationResult validationResult = isTemplateLangConfigured ? new ValidationResult(PyTemplatesBundle.message("no_selected_template_language_settings", new Object[0])) : ValidationResult.OK;
                if (validationResult == null) {
                    1.$$$reportNull$$$0(0);
                }
                return validationResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/templateLanguages/PyTemplateRootProvider$1", "check"));
            }
        }, new JComponent[0]);
        this.myListener = () -> panel2.getValidatorsManager().validate();
        TemplatesService.getInstance(module).addLanguageSelectedListener(this.myListener);
        panel2.getValidatorsManager().validate();
    }

    @Override
    public void apply(Module module) {
        List<VirtualFile> templateRoots = this.getCurrentTemplateRoots();
        TemplatesService instance = TemplatesService.getInstance(module);
        if (instance != null) {
            instance.setTemplateFolders(templateRoots.toArray(VirtualFile.EMPTY_ARRAY));
        }
    }

    @Override
    public boolean isModified(Module module) {
        List<VirtualFile> current;
        List<VirtualFile> original;
        TemplatesService templatesService = TemplatesService.getInstance(module);
        return templatesService != null && !Comparing.haveEqualElements(original = templatesService.getTemplateFolders(), current = this.getCurrentTemplateRoots());
    }

    @Override
    public MultiMap<ContentEntry, VirtualFilePointer> getRoots() {
        return this.myTemplateRoots;
    }

    @Nullable
    private static ContentEntry findContentEntryForFile(VirtualFile virtualFile2, PyContentEntriesEditor editor2) {
        for (ContentEntry contentEntry : editor2.getContentEntries()) {
            VirtualFile file2 = contentEntry.getFile();
            if (file2 == null || !VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)virtualFile2, (boolean)false)) continue;
            return contentEntry;
        }
        return null;
    }

    private List<VirtualFile> getCurrentTemplateRoots() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (ContentEntry entry : this.myTemplateRoots.keySet()) {
            for (VirtualFilePointer filePointer : this.myTemplateRoots.get((Object)entry)) {
                result.add(filePointer.getFile());
            }
        }
        return result;
    }

    @Override
    public Icon getIcon() {
        return PythonIcons.Python.TemplateRoot;
    }

    @Override
    public String getName() {
        return "Template";
    }

    @Override
    public Color getColor() {
        return JBColor.MAGENTA;
    }

    @Override
    public ContentEntryEditingAction createRootEntryEditingAction(JTree tree, Disposable disposable, PyContentEntriesEditor editor2, ModifiableRootModel model) {
        return new PyRootTypeProvider.RootEntryEditingAction(tree, disposable, editor2, model);
    }

    @Override
    @Nullable
    public CustomShortcutSet getShortcut() {
        return new CustomShortcutSet(KeyStroke.getKeyStroke(84, 8));
    }

    @Override
    public void disposeUIResources(@NotNull Module module) {
        if (module == null) {
            PyTemplateRootProvider.$$$reportNull$$$0(2);
        }
        if (this.myListener != null) {
            TemplatesService.getInstance(module).removeLanguageSelectedListener(this.myListener);
            this.myListener = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/templateLanguages/PyTemplateRootProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "disposeUIResources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

