/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.SwingHelper;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.inspections.PyInterpreterInspection;
import com.jetbrains.python.sdk.PyRenderedSdkType;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkPopupFactory;
import com.jetbrains.python.sdk.PySdkRenderingKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.add.PyAddSdkDialog;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/sdk/PySdkPopupFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createPopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "switchToSdk", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "AddInterpreterAction", "Companion", "InterpreterSettingsAction", "SwitchToSdkAction", "intellij.python.community.impl"})
public final class PySdkPopupFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final Module module;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ListPopup createPopup(@NotNull DataContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        DefaultActionGroup group2 = new DefaultActionGroup();
        PyConfigurableInterpreterList interpreterList = PyConfigurableInterpreterList.getInstance(this.project);
        List<Sdk> list = interpreterList.getAllPythonSdks(this.project);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"interpreterList.getAllPythonSdks(project)");
        Map<PyRenderedSdkType, List<Sdk>> moduleSdksByTypes2 = PySdkRenderingKt.groupModuleSdksByTypes(list, this.module, (Function1<? super Sdk, Boolean>)((Function1)createPopup.moduleSdksByTypes.1.INSTANCE));
        PyConfigurableInterpreterList pyConfigurableInterpreterList = interpreterList;
        Intrinsics.checkExpressionValueIsNotNull((Object)pyConfigurableInterpreterList, (String)"interpreterList");
        ProjectSdksModel model = pyConfigurableInterpreterList.getModel();
        Object $this$forEachIndexed$iv = PyRenderedSdkType.values();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (PyRenderedSdkType item$iv : $this$forEachIndexed$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            void type;
            int n = index$iv++;
            PyRenderedSdkType pyRenderedSdkType = item$iv;
            int index = n;
            boolean bl = false;
            Object object = moduleSdksByTypes2;
            boolean bl2 = false;
            Map<PyRenderedSdkType, List<Sdk>> map2 = object;
            boolean bl3 = false;
            if (!map2.containsKey(type)) continue;
            if (index != 0) {
                group2.addSeparator();
            }
            object = (Iterable)MapsKt.getValue(moduleSdksByTypes2, (Object)type);
            DefaultActionGroup defaultActionGroup = group2;
            boolean $i$f$mapNotNull = false;
            map2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Sdk sdk = $this$forEach$iv$iv$iv.iterator();
            while (sdk.hasNext()) {
                Sdk sdk2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = sdk.next();
                boolean bl4 = false;
                Sdk it = (Sdk)element$iv$iv;
                boolean bl5 = false;
                if (model.findSdk(it) == null) continue;
                boolean bl6 = false;
                boolean bl7 = false;
                Sdk it$iv$iv = sdk2;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Collection<SwitchToSdkAction> collection = (List)destination$iv$iv;
            $this$mapNotNull$iv = collection;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                sdk = (Sdk)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl9 = false;
                void v3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                SwitchToSdkAction switchToSdkAction = new SwitchToSdkAction((Sdk)v3);
                collection.add(switchToSdkAction);
            }
            collection = (List)destination$iv$iv;
            defaultActionGroup.addAll((Collection)collection);
        }
        $this$forEachIndexed$iv = moduleSdksByTypes2;
        boolean bl = false;
        if (!$this$forEachIndexed$iv.isEmpty()) {
            group2.addSeparator();
        }
        group2.add((AnAction)new InterpreterSettingsAction());
        group2.add((AnAction)new AddInterpreterAction());
        Sdk currentSdk = PySdkExtKt.getPythonSdk(this.module);
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(PyBundle.message("python.sdk.popup.title", new Object[0]), (ActionGroup)group2, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, -1, (Condition)new Condition<AnAction>(currentSdk){
            final /* synthetic */ Sdk $currentSdk;

            public final boolean value(AnAction it) {
                return it instanceof SwitchToSdkAction && Intrinsics.areEqual((Object)((SwitchToSdkAction)it).getSdk(), (Object)this.$currentSdk);
            }
            {
                this.$currentSdk = sdk;
            }
        }, null);
        boolean bl10 = false;
        boolean bl11 = false;
        ListPopup $this$apply = listPopup;
        boolean bl12 = false;
        $this$apply.setHandleAutoSelectionBeforeShow(true);
        return listPopup;
    }

    private final void switchToSdk(Sdk sdk) {
        SdkTypeId sdkTypeId = sdk.getSdkType();
        if (sdkTypeId == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.python.sdk.PythonSdkType");
        }
        ((PythonSdkType)sdkTypeId).setupSdkPaths(sdk);
        PySdkExtKt.setPythonSdk(this.project, sdk);
        PySdkExtKt.setPythonSdk(this.module, sdk);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    public PySdkPopupFactory(@NotNull Project project, @NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        this.project = project;
        this.module = module;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/python/sdk/PySdkPopupFactory$SwitchToSdkAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/jetbrains/python/sdk/PySdkPopupFactory;Lcom/intellij/openapi/projectRoots/Sdk;)V", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.python.community.impl"})
    private final class SwitchToSdkAction
    extends DumbAwareAction {
        @NotNull
        private final Sdk sdk;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            PySdkPopupFactory.this.switchToSdk(this.sdk);
        }

        @NotNull
        public final Sdk getSdk() {
            return this.sdk;
        }

        public SwitchToSdkAction(Sdk sdk) {
            Intrinsics.checkParameterIsNotNull((Object)sdk, (String)"sdk");
            this.sdk = sdk;
            Presentation presentation = this.getTemplatePresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"templatePresentation");
            Presentation presentation2 = presentation;
            presentation2.setText(Companion.shortenNameInPopup(this.sdk, 100), false);
            presentation2.setDescription(PyBundle.message("python.sdk.switch.to", Companion.descriptionInPopup(this.sdk)));
            presentation2.setIcon(PySdkRenderingKt.icon(this.sdk));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/sdk/PySdkPopupFactory$InterpreterSettingsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/jetbrains/python/sdk/PySdkPopupFactory;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.python.community.impl"})
    private final class InterpreterSettingsAction
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            PyInterpreterInspection.InterpreterSettingsQuickFix.showPythonInterpreterSettings(PySdkPopupFactory.this.getProject(), PySdkPopupFactory.this.getModule());
        }

        public InterpreterSettingsAction() {
            super(PyBundle.message("python.sdk.popup.interpreter.settings", new Object[0]));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/sdk/PySdkPopupFactory$AddInterpreterAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/jetbrains/python/sdk/PySdkPopupFactory;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.python.community.impl"})
    private final class AddInterpreterAction
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            PyConfigurableInterpreterList pyConfigurableInterpreterList = PyConfigurableInterpreterList.getInstance(PySdkPopupFactory.this.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)pyConfigurableInterpreterList, (String)"PyConfigurableInterpreterList.getInstance(project)");
            ProjectSdksModel model = pyConfigurableInterpreterList.getModel();
            Project project = PySdkPopupFactory.this.getProject();
            Module module = PySdkPopupFactory.this.getModule();
            ProjectSdksModel projectSdksModel = model;
            Intrinsics.checkExpressionValueIsNotNull((Object)projectSdksModel, (String)"model");
            Object[] objectArray = projectSdksModel.getSdks();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"model.sdks");
            PyAddSdkDialog.Companion.show(project, module, ArraysKt.asList((Object[])objectArray), new Consumer<Sdk>(this, model){
                final /* synthetic */ AddInterpreterAction this$0;
                final /* synthetic */ ProjectSdksModel $model;

                public final void accept(@Nullable Sdk it) {
                    if (it != null && this.$model.findSdk(it.getName()) == null) {
                        this.$model.addSdk(it);
                        this.$model.apply();
                        PySdkPopupFactory.access$switchToSdk(this.this$0.PySdkPopupFactory.this, it);
                    }
                }
                {
                    this.this$0 = addInterpreterAction;
                    this.$model = projectSdksModel;
                }
            });
        }

        public AddInterpreterAction() {
            super(PyBundle.message("python.sdk.popup.add.interpreter", new Object[0]));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/sdk/PySdkPopupFactory$Companion;", "", "()V", "createAndShow", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "descriptionInPopup", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "nameInPopup", "shortenNameInPopup", "maxLength", "", "intellij.python.community.impl"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final String nameInPopup(Sdk sdk) {
            void primary;
            Triple triple = PySdkRenderingKt.name$default(sdk, null, 2, null);
            String string = (String)triple.component2();
            String secondary = (String)triple.component3();
            return secondary == null ? primary : (String)primary + " [" + secondary + ']';
        }

        @NotNull
        public final String shortenNameInPopup(@NotNull Sdk sdk, int maxLength) {
            Intrinsics.checkParameterIsNotNull((Object)sdk, (String)"sdk");
            return StringKt.trimMiddle$default((String)this.nameInPopup(sdk), (int)maxLength, (boolean)false, (int)2, null);
        }

        @NotNull
        public final String descriptionInPopup(@NotNull Sdk sdk) {
            Intrinsics.checkParameterIsNotNull((Object)sdk, (String)"sdk");
            return StringKt.trimMiddle$default((String)(this.nameInPopup(sdk) + " [" + PySdkRenderingKt.path$default(sdk, null, 2, null) + ']'), (int)150, (boolean)false, (int)2, null);
        }

        public final void createAndShow(@NotNull Project project, @NotNull Module module) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            DataManager dataManager = DataManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataManager, (String)"DataManager.getInstance()");
            dataManager.getDataContextFromFocusAsync().onSuccess((Consumer)new Consumer<DataContext>(project, module){
                final /* synthetic */ Project $project;
                final /* synthetic */ Module $module;

                public final void accept(DataContext it) {
                    PySdkPopupFactory pySdkPopupFactory = new PySdkPopupFactory(this.$project, this.$module);
                    DataContext dataContext = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"it");
                    ListPopup listPopup = pySdkPopupFactory.createPopup(dataContext);
                    if (listPopup == null) {
                        return;
                    }
                    ListPopup popup = listPopup;
                    Component component = SwingHelper.getComponentFromRecentMouseEvent();
                    if (component != null) {
                        popup.showUnderneathOf(component);
                    } else {
                        popup.showInBestPositionFor(it);
                    }
                }
                {
                    this.$project = project;
                    this.$module = module;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

