/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.scientific.figures.base;

import com.intellij.ui.scale.JBUIScale;
import com.jetbrains.python.scientific.figures.WithBinaryContent;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FigureUtil {
    @NotNull
    public static BufferedImage componentImage(@NotNull Component component) {
        if (component == null) {
            FigureUtil.$$$reportNull$$$0(0);
        }
        return FigureUtil.componentImage(component, component.getWidth(), component.getHeight());
    }

    @NotNull
    public static BufferedImage componentImage(@NotNull Component component, int width, int height) {
        if (component == null) {
            FigureUtil.$$$reportNull$$$0(1);
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = image.createGraphics();
        component.paintAll(graphics);
        graphics.dispose();
        BufferedImage bufferedImage = image;
        if (bufferedImage == null) {
            FigureUtil.$$$reportNull$$$0(2);
        }
        return bufferedImage;
    }

    @NotNull
    public static Image fit(@NotNull Image image, int width, int height) {
        if (image == null) {
            FigureUtil.$$$reportNull$$$0(3);
        }
        Image image2 = image.getScaledInstance(JBUIScale.scale((int)width), JBUIScale.scale((int)height), 4);
        if (image2 == null) {
            FigureUtil.$$$reportNull$$$0(4);
        }
        return image2;
    }

    public static byte[] componentToByteArray(@NotNull JComponent component) {
        if (component == null) {
            FigureUtil.$$$reportNull$$$0(5);
        }
        byte[] bytes = component instanceof WithBinaryContent ? ((WithBinaryContent)((Object)component)).getBytes() : FigureUtil.toByteArray(FigureUtil.componentImage(component));
        return bytes;
    }

    public static byte[] toByteArray(@NotNull RenderedImage image) {
        if (image == null) {
            FigureUtil.$$$reportNull$$$0(6);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ImageIO.write(image, "png", stream);
            stream.flush();
            byte[] imageInByte = stream.toByteArray();
            stream.close();
            return imageInByte;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to convert image to byte array", e);
        }
    }

    @NotNull
    public static BufferedImage fromRawBytes(int width, byte[] raw) {
        int height = raw.length / 3 / width;
        DataBufferByte buffer = new DataBufferByte(raw, raw.length);
        ComponentSampleModel sampleModel = new ComponentSampleModel(0, width, height, 3, width * 3, new int[]{0, 1, 2});
        Raster raster = Raster.createRaster(sampleModel, buffer, null);
        BufferedImage image = new BufferedImage(width, height, 1);
        image.setData(raster);
        BufferedImage bufferedImage = image;
        if (bufferedImage == null) {
            FigureUtil.$$$reportNull$$$0(7);
        }
        return bufferedImage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/scientific/figures/base/FigureUtil";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/scientific/figures/base/FigureUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "componentImage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fit";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fromRawBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "componentImage";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fit";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "componentToByteArray";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toByteArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

