/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote.console;

import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.intellij.execution.KillableProcess;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.Tunnelable;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.console.PyConsoleProcessHandler;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.remote.vfs.PyRemotePositionConverter;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.RemoteDebuggableProcessHandler;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteConsoleProcessHandler
extends PyConsoleProcessHandler
implements RemoteDebuggableProcessHandler,
KillableProcess {
    private static final Logger LOG = Logger.getInstance((String)PyRemoteConsoleProcessHandler.class.getName());
    @NotNull
    private final PydevConsoleCommunication myConsoleCommunication;
    @NotNull
    private final PyRemotePathMapper myPathMapper;
    private final List<PathMappingSettings.PathMapping> myFileMappings;
    @NotNull
    private final PyRemoteSocketToLocalHostProvider myRemoteSocketProvider;

    public PyRemoteConsoleProcessHandler(@NotNull Process process2, @NotNull PythonConsoleView consoleView, @NotNull PydevConsoleCommunication pydevConsoleCommunication, @NotNull String commandLine, @NotNull Charset charset, @Nullable PyRemotePathMapper pathMapper, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider) {
        if (process2 == null) {
            PyRemoteConsoleProcessHandler.$$$reportNull$$$0(0);
        }
        if (consoleView == null) {
            PyRemoteConsoleProcessHandler.$$$reportNull$$$0(1);
        }
        if (pydevConsoleCommunication == null) {
            PyRemoteConsoleProcessHandler.$$$reportNull$$$0(2);
        }
        if (commandLine == null) {
            PyRemoteConsoleProcessHandler.$$$reportNull$$$0(3);
        }
        if (charset == null) {
            PyRemoteConsoleProcessHandler.$$$reportNull$$$0(4);
        }
        if (remoteSocketProvider == null) {
            PyRemoteConsoleProcessHandler.$$$reportNull$$$0(5);
        }
        super(process2, consoleView, pydevConsoleCommunication, commandLine, charset);
        this.myFileMappings = Lists.newArrayList();
        this.myConsoleCommunication = pydevConsoleCommunication;
        this.myPathMapper = pathMapper != null ? pathMapper : new PyRemotePathMapper();
        this.myRemoteSocketProvider = remoteSocketProvider;
    }

    @NotNull
    public PathMapper getMappingSettings() {
        PyRemotePathMapper pyRemotePathMapper = this.myPathMapper;
        if (pyRemotePathMapper == null) {
            PyRemoteConsoleProcessHandler.$$$reportNull$$$0(6);
        }
        return pyRemotePathMapper;
    }

    @Deprecated
    public void addRemoteForwarding(int remotePort, int localPort) {
        try {
            Process process2 = this.getProcess();
            if (process2 instanceof Tunnelable) {
                ((Tunnelable)process2).addRemoteTunnel(remotePort, "localhost", localPort);
            }
        }
        catch (RemoteSdkException e) {
            throw new RuntimeException(e);
        }
    }

    public Pair<String, Integer> getRemoteSocket(int localPort) throws RemoteSdkException {
        return this.myRemoteSocketProvider.getRemoteSocket(localPort);
    }

    @Nullable
    public HostAndPort getLocalTunnel(int remotePort) {
        Process process2 = this.getProcess();
        if (process2 instanceof RemoteProcess) {
            return ((RemoteProcess)process2).getLocalTunnel(remotePort);
        }
        return null;
    }

    public boolean canKillProcess() {
        return true;
    }

    public void killProcess() {
        this.myConsoleCommunication.close();
    }

    public List<PathMappingSettings.PathMapping> getFileMappings() {
        return this.myFileMappings;
    }

    @Override
    public PyPositionConverter createPositionConverter(@NotNull PyDebugProcess debugProcess) {
        if (debugProcess == null) {
            PyRemoteConsoleProcessHandler.$$$reportNull$$$0(7);
        }
        return new PyRemotePositionConverter(debugProcess, this.myPathMapper);
    }

    @Override
    @NotNull
    public PyRemoteSocketToLocalHostProvider getRemoteSocketToLocalHostProvider() {
        PyRemoteSocketToLocalHostProvider pyRemoteSocketToLocalHostProvider = this.myRemoteSocketProvider;
        if (pyRemoteSocketToLocalHostProvider == null) {
            PyRemoteConsoleProcessHandler.$$$reportNull$$$0(8);
        }
        return pyRemoteSocketToLocalHostProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pydevConsoleCommunication";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSocketProvider";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/console/PyRemoteConsoleProcessHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/console/PyRemoteConsoleProcessHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSocketToLocalHostProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPositionConverter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

