/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.plugins.remotesdk.WebDeploymentCredentialsType;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.python.remote.PyDeploymentBasedProjectSynchronizer;
import com.jetbrains.python.remote.PyDeploymentUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PySshProjectSynchronizerHelpers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PyWebDeploymentProjectSynchronizer
extends PyDeploymentBasedProjectSynchronizer {
    PyWebDeploymentProjectSynchronizer(@NotNull Sdk sdk, @NotNull String serverId, @NotNull String serverName) {
        if (sdk == null) {
            PyWebDeploymentProjectSynchronizer.$$$reportNull$$$0(0);
        }
        if (serverId == null) {
            PyWebDeploymentProjectSynchronizer.$$$reportNull$$$0(1);
        }
        if (serverName == null) {
            PyWebDeploymentProjectSynchronizer.$$$reportNull$$$0(2);
        }
        super(sdk, serverId, serverName);
    }

    @Nullable
    private static WebDeploymentCredentialsHolder getCredentials(@NotNull PyRemoteSdkAdditionalData data) {
        if (data == null) {
            PyWebDeploymentProjectSynchronizer.$$$reportNull$$$0(3);
        }
        Ref credentialsRef = Ref.create();
        data.switchOnConnectionType(CredentialsCase.create((CredentialsType)WebDeploymentCredentialsType.getInstance(), credentials -> credentialsRef.set(credentials)));
        return (WebDeploymentCredentialsHolder)credentialsRef.get();
    }

    @Override
    @Nullable
    protected String configureDeployment(@NotNull Module module, @NotNull PySshProjectSynchronizerHelpers.MyServerRootAndFolder rootAndFolder, @NotNull PathMappingSettings.PathMapping pathMappingForDeployment) {
        Project project;
        WebServerConfig serverConfig;
        if (module == null) {
            PyWebDeploymentProjectSynchronizer.$$$reportNull$$$0(4);
        }
        if (rootAndFolder == null) {
            PyWebDeploymentProjectSynchronizer.$$$reportNull$$$0(5);
        }
        if (pathMappingForDeployment == null) {
            PyWebDeploymentProjectSynchronizer.$$$reportNull$$$0(6);
        }
        if ((serverConfig = GroupedServersConfigManager.getInstance((Project)(project = module.getProject())).findServer(this.myServerId)) == null) {
            return "Server configuration " + this.myServerName + " could not be found.";
        }
        PyDeploymentUtil.configureDeploymentForProject(project, serverConfig, pathMappingForDeployment, rootAndFolder.myServerProjectFolder);
        return null;
    }

    @NotNull
    static PyWebDeploymentProjectSynchronizer newInstance(@NotNull Sdk sdk) {
        WebDeploymentCredentialsHolder credentials;
        if (sdk == null) {
            PyWebDeploymentProjectSynchronizer.$$$reportNull$$$0(7);
        }
        if ((credentials = PyWebDeploymentProjectSynchronizer.getCredentials(PyWebDeploymentProjectSynchronizer.getAdditionalData(sdk))) == null) {
            throw new IllegalArgumentException("Web deployment credentials must not be empty for SDK " + sdk.getName());
        }
        String serverId = credentials.getWebServerConfigId();
        String serverName = credentials.getWebServerConfigName();
        if (StringUtil.isEmpty((String)serverId)) {
            throw new IllegalStateException("Server id must be present for deployment configuration " + credentials.getCredentialsId());
        }
        if (serverName == null) {
            throw new IllegalStateException("Server name must be present for deployment configuration " + credentials.getCredentialsId());
        }
        return new PyWebDeploymentProjectSynchronizer(sdk, serverId, serverName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootAndFolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappingForDeployment";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/remote/PyWebDeploymentProjectSynchronizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCredentials";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "configureDeployment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "newInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

