/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.convertModulePackage;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.refactoring.convertModulePackage.PyBaseConvertModulePackageAction;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyConvertModuleToPackageAction
extends PyBaseConvertModulePackageAction {
    public static final String ID = "py.refactoring.convert.module.to.package";
    private static final Logger LOG = Logger.getInstance(PyConvertModuleToPackageAction.class);

    @Override
    protected boolean isEnabledOnElementsOutsideEditor(PsiElement @NotNull [] elements) {
        if (elements == null) {
            PyConvertModuleToPackageAction.$$$reportNull$$$0(0);
        }
        if (elements.length == 1) {
            return elements[0] instanceof PyFile && !PyUtil.isPackage((PyFile)elements[0]);
        }
        return false;
    }

    @Nullable
    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PyConvertModuleToPackageAction.$$$reportNull$$$0(1);
        }
        return new RefactoringActionHandler(){

            public void invoke(@NotNull Project project, Editor editor2, PsiFile file2, DataContext dataContext) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                PyConvertModuleToPackageAction.this.createPackageFromModule((PyFile)file2);
            }

            public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (elements == null) {
                    1.$$$reportNull$$$0(2);
                }
                PyConvertModuleToPackageAction.this.createPackageFromModule((PyFile)elements[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "elements";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/refactoring/convertModulePackage/PyConvertModuleToPackageAction$1";
                objectArray[2] = "invoke";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @VisibleForTesting
    public void createPackageFromModule(@NotNull PyFile file2) {
        String newPackageName;
        VirtualFile vFile;
        VirtualFile parentDir;
        VirtualFile existing;
        if (file2 == null) {
            PyConvertModuleToPackageAction.$$$reportNull$$$0(2);
        }
        if ((existing = (parentDir = (vFile = file2.getVirtualFile()).getParent()).findChild(newPackageName = vFile.getNameWithoutExtension())) != null) {
            this.showFileExistsErrorMessage(existing, ID, file2.getProject());
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)file2.getProject(), () -> {
            try {
                VirtualFile packageDir = parentDir.createChildDirectory((Object)this, newPackageName);
                vFile.move((Object)this, packageDir);
                vFile.rename((Object)this, "__init__.py");
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/convertModulePackage/PyConvertModuleToPackageAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledOnElementsOutsideEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createPackageFromModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

