/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyBaseDocstringInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.quickfix.DocstringQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import org.jetbrains.annotations.NotNull;

public class PyMissingOrEmptyDocstringInspection
extends PyBaseDocstringInspection {
    @Override
    @NotNull
    public PyBaseDocstringInspection.Visitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyMissingOrEmptyDocstringInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyMissingOrEmptyDocstringInspection.$$$reportNull$$$0(1);
        }
        return new PyBaseDocstringInspection.Visitor(holder, session){

            @Override
            protected void checkDocString(@NotNull PyDocStringOwner node) {
                PyStringLiteralExpression docStringExpression;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((docStringExpression = node.getDocStringExpression()) == null) {
                    ASTNode n;
                    for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
                        if (!extension.ignoreMissingDocstring(node)) continue;
                        return;
                    }
                    Object marker = null;
                    if (node instanceof PyClass) {
                        n = ((PyClass)node).getNameNode();
                        if (n != null) {
                            marker = n.getPsi();
                        }
                    } else if (node instanceof PyFunction) {
                        n = ((PyFunction)node).getNameNode();
                        if (n != null) {
                            marker = n.getPsi();
                        }
                    } else if (node instanceof PyFile) {
                        TextRange tr = new TextRange(0, 0);
                        ProblemsHolder holder = this.getHolder();
                        if (holder != null) {
                            holder.registerProblem((PsiElement)node, tr, PyBundle.message("INSP.no.docstring", new Object[0]), new LocalQuickFix[0]);
                        }
                        return;
                    }
                    if (marker == null) {
                        marker = node;
                    }
                    if (node instanceof PyFunction || node instanceof PyClass && ((PyClass)node).findInitOrNew(false, null) != null) {
                        this.registerProblem((PsiElement)marker, PyBundle.message("INSP.no.docstring", new Object[0]), new LocalQuickFix[]{new DocstringQuickFix(null, null)});
                    } else {
                        this.registerProblem((PsiElement)marker, PyBundle.message("INSP.no.docstring", new Object[0]));
                    }
                } else if (StringUtil.isEmptyOrSpaces((String)docStringExpression.getStringValue())) {
                    this.registerProblem(docStringExpression, PyBundle.message("INSP.empty.docstring", new Object[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/PyMissingOrEmptyDocstringInspection$1", "checkDocString"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyMissingOrEmptyDocstringInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

