/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonIdeLanguageCustomization;
import com.jetbrains.python.configuration.PyActiveSdkModuleConfigurable;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkPopupFactory;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.CondaEnvSdkFlavor;
import com.jetbrains.python.sdk.pipenv.PipenvKt;
import com.jetbrains.python.sdk.pipenv.UsePipEnvQuickFix;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyInterpreterInspection
extends PyInspection {
    @NotNull
    private static final Pattern NAME = Pattern.compile("Python (?<version>\\d\\.\\d+)\\s*(\\((?<name>.+?)\\))?");

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyInterpreterInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyInterpreterInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    @Nullable
    private static Module guessModule(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            PyInterpreterInspection.$$$reportNull$$$0(2);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            Module[] modules = ModuleManager.getInstance((Project)element.getProject()).getModules();
            if (modules.length != 1) {
                return null;
            }
            module = modules[0];
        }
        return module;
    }

    private static boolean isFileIgnored(@NotNull PyFile pyFile) {
        if (pyFile == null) {
            PyInterpreterInspection.$$$reportNull$$$0(3);
        }
        return PyInspectionExtension.EP_NAME.getExtensionList().stream().anyMatch(ep -> ep.ignoreInterpreterWarnings(pyFile));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "guessModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileIgnored";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class UseDetectedInterpreterFix
    extends UseInterpreterFix<PyDetectedSdk> {
        @NotNull
        private final List<Sdk> myExistingSdks;
        private final boolean myAssociate;
        @NotNull
        private final Module myModule;

        private UseDetectedInterpreterFix(@NotNull PyDetectedSdk detectedSdk, @NotNull List<Sdk> existingSdks, boolean associate, @NotNull Module module) {
            if (detectedSdk == null) {
                UseDetectedInterpreterFix.$$$reportNull$$$0(0);
            }
            if (existingSdks == null) {
                UseDetectedInterpreterFix.$$$reportNull$$$0(1);
            }
            if (module == null) {
                UseDetectedInterpreterFix.$$$reportNull$$$0(2);
            }
            super(detectedSdk);
            this.myExistingSdks = existingSdks;
            this.myAssociate = associate;
            this.myModule = module;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Sdk newSdk;
            if (project == null) {
                UseDetectedInterpreterFix.$$$reportNull$$$0(3);
            }
            if (descriptor2 == null) {
                UseDetectedInterpreterFix.$$$reportNull$$$0(4);
            }
            Sdk sdk = newSdk = this.myAssociate ? PySdkExtKt.setupAssociated((PyDetectedSdk)this.mySdk, this.myExistingSdks, BasePySdkExtKt.getBasePath(this.myModule)) : PySdkExtKt.setup((PyDetectedSdk)this.mySdk, this.myExistingSdks);
            if (newSdk == null) {
                return;
            }
            SdkConfigurationUtil.addSdk((Sdk)newSdk);
            if (this.myAssociate) {
                PySdkExtKt.associateWithModule(newSdk, this.myModule, null);
            }
            SdkConfigurationUtil.setDirectoryProjectSdk((Project)project, (Sdk)newSdk);
            if (this.myAssociate) {
                PySdkExtKt.excludeInnerVirtualEnv(this.myModule, newSdk);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "detectedSdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingSdks";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$UseDetectedInterpreterFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class UseExistingInterpreterFix
    extends UseInterpreterFix<Sdk> {
        @NotNull
        private final Module myModule;

        private UseExistingInterpreterFix(@NotNull Sdk existingSdk, @NotNull Module module) {
            if (existingSdk == null) {
                UseExistingInterpreterFix.$$$reportNull$$$0(0);
            }
            if (module == null) {
                UseExistingInterpreterFix.$$$reportNull$$$0(1);
            }
            super(existingSdk);
            this.myModule = module;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                UseExistingInterpreterFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                UseExistingInterpreterFix.$$$reportNull$$$0(3);
            }
            SdkConfigurationUtil.setDirectoryProjectSdk((Project)project, (Sdk)this.mySdk);
            PySdkExtKt.excludeInnerVirtualEnv(this.myModule, this.mySdk);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingSdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$UseExistingInterpreterFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class UseInterpreterFix<T extends Sdk>
    implements LocalQuickFix {
        @NotNull
        protected final T mySdk;

        protected UseInterpreterFix(@NotNull T sdk) {
            if (sdk == null) {
                UseInterpreterFix.$$$reportNull$$$0(0);
            }
            this.mySdk = sdk;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PyBundle.message("INSP.interpreter.use.suggested.interpreter", new Object[0]);
            if (string == null) {
                UseInterpreterFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = PyBundle.message("INSP.interpreter.use.interpreter", PySdkPopupFactory.Companion.shortenNameInPopup((Sdk)this.mySdk, 75));
            if (string == null) {
                UseInterpreterFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyInterpreterInspection$UseInterpreterFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$UseInterpreterFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class ConfigureInterpreterFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = PyBundle.message("INSP.interpreter.configure.python.interpreter", new Object[0]);
            if (string == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor2.getPsiElement()) == null) {
                return;
            }
            Module module = PyInterpreterInspection.guessModule(element);
            if (module == null) {
                return;
            }
            PySdkPopupFactory.Companion.createAndShow(project, module);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyInterpreterInspection$ConfigureInterpreterFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$ConfigureInterpreterFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class InterpreterSettingsQuickFix
    implements LocalQuickFix {
        @NotNull
        private final Module myModule;

        public InterpreterSettingsQuickFix(@NotNull Module module) {
            if (module == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(0);
            }
            this.myModule = module;
        }

        @NotNull
        public String getFamilyName() {
            String string = PlatformUtils.isPyCharm() ? PyBundle.message("INSP.interpreter.interpreter.settings", new Object[0]) : PyBundle.message("INSP.interpreter.configure.python.interpreter", new Object[0]);
            if (string == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(3);
            }
            InterpreterSettingsQuickFix.showPythonInterpreterSettings(project, this.myModule);
        }

        public static void showPythonInterpreterSettings(@NotNull Project project, @NotNull Module module) {
            if (project == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(4);
            }
            if (module == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(5);
            }
            if (InterpreterSettingsQuickFix.hasPythonSdkConfigurable(project)) {
                ShowSettingsUtil.getInstance().showSettingsDialog(project, PyActiveSdkModuleConfigurable.class);
                return;
            }
            ProjectSettingsService settingsService = ProjectSettingsService.getInstance((Project)project);
            if (InterpreterSettingsQuickFix.justOneModuleInheritingSdk(project, module)) {
                settingsService.openProjectSettings();
            } else {
                settingsService.openModuleSettings(module);
            }
        }

        private static boolean hasPythonSdkConfigurable(@NotNull Project project) {
            if (project == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(6);
            }
            if (PlatformUtils.isPyCharm()) {
                return true;
            }
            List<ConfigurableGroup> groups = Collections.singletonList(ConfigurableExtensionPointUtil.getConfigurableGroup((Project)project, (boolean)true));
            return ConfigurableVisitor.findByType(PyActiveSdkModuleConfigurable.class, groups) != null;
        }

        private static boolean justOneModuleInheritingSdk(@NotNull Project project, @NotNull Module module) {
            if (project == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(7);
            }
            if (module == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(8);
            }
            return ProjectRootManager.getInstance((Project)project).getProjectSdk() == null && ModuleRootManager.getInstance((Module)module).isSdkInherited() && ModuleManager.getInstance((Project)project).getModules().length < 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyInterpreterInspection$InterpreterSettingsQuickFix";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$InterpreterSettingsQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "showPythonInterpreterSettings";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "hasPythonSdkConfigurable";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "justOneModuleInheritingSdk";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyFile(PyFile node) {
            String product;
            String sdkName;
            Module module = PyInterpreterInspection.guessModule((PsiElement)node);
            if (module == null || PyInterpreterInspection.isFileIgnored(node)) {
                return;
            }
            Sdk sdk = PythonSdkUtil.findPythonSdk(module);
            boolean pyCharm = PythonIdeLanguageCustomization.isMainlyPythonIde();
            String interpreterOwner = pyCharm ? "project" : "module";
            ArrayList<Object> fixes = new ArrayList<Object>();
            if (UsePipEnvQuickFix.Companion.isApplicable(module)) {
                fixes.add(new UsePipEnvQuickFix(sdk, module));
            }
            if (pyCharm && sdk == null && (sdkName = ProjectRootManager.getInstance((Project)node.getProject()).getProjectSdkName()) != null) {
                ContainerUtil.addIfNotNull(fixes, (Object)Visitor.getSuitableSdkFix(sdkName, module));
            }
            if (pyCharm) {
                fixes.add(new ConfigureInterpreterFix());
            } else {
                fixes.add(new InterpreterSettingsQuickFix(module));
            }
            String string = product = pyCharm ? "PyCharm" : "Python plugin";
            if (sdk == null) {
                this.registerProblem((PsiElement)node, PyBundle.message("python.sdk.no.interpreter.configured.owner", interpreterOwner), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            } else {
                String associatedName;
                Module associatedModule2 = PySdkExtKt.getAssociatedModule(sdk);
                String string2 = associatedName = associatedModule2 != null ? associatedModule2.getName() : PySdkExtKt.getAssociatedModulePath(sdk);
                if (PipenvKt.isPipEnv(sdk) && associatedModule2 != module) {
                    String message = associatedName != null ? "Pipenv interpreter is associated with another " + interpreterOwner + ": '" + associatedName + "'" : "Pipenv interpreter is not associated with any " + interpreterOwner;
                    this.registerProblem((PsiElement)node, message, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                } else if (PythonSdkUtil.isInvalid(sdk)) {
                    this.registerProblem((PsiElement)node, "Invalid Python interpreter selected for the " + interpreterOwner, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                } else {
                    LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk);
                    if (!LanguageLevel.SUPPORTED_LEVELS.contains((Object)languageLevel)) {
                        this.registerProblem((PsiElement)node, "Python " + (Object)((Object)languageLevel) + " has reached its end-of-life date and it is no longer supported in " + product + ".", fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                    }
                }
            }
        }

        @Nullable
        private static LocalQuickFix getSuitableSdkFix(@NotNull String name, @NotNull Module module) {
            List<Sdk> existingSdks;
            Sdk associatedSdk;
            if (name == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (module == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((associatedSdk = PySdkExtKt.findExistingAssociatedSdk(module, existingSdks = Visitor.getExistingSdks())) != null) {
                return new UseExistingInterpreterFix(associatedSdk, module);
            }
            UserDataHolderBase context = new UserDataHolderBase();
            PyDetectedSdk detectedAssociatedSdk = PySdkExtKt.findDetectedAssociatedEnvironment(module, existingSdks, (UserDataHolder)context);
            if (detectedAssociatedSdk != null) {
                return new UseDetectedInterpreterFix(detectedAssociatedSdk, existingSdks, true, module);
            }
            Matcher matcher = NAME.matcher(name);
            if (!matcher.matches()) {
                return null;
            }
            String venvName = matcher.group("name");
            if (venvName != null) {
                PyDetectedSdk detectedAssociatedViaRootNameEnv = Visitor.detectAssociatedViaRootNameEnv(venvName, module, existingSdks, context);
                if (detectedAssociatedViaRootNameEnv != null) {
                    return new UseDetectedInterpreterFix(detectedAssociatedViaRootNameEnv, existingSdks, true, module);
                }
            } else {
                PyDetectedSdk detectedSystemWideSdk = Visitor.detectSystemWideSdk(matcher.group("version"), module, existingSdks, context);
                if (detectedSystemWideSdk != null) {
                    return new UseDetectedInterpreterFix(detectedSystemWideSdk, existingSdks, false, module);
                }
            }
            return null;
        }

        @NotNull
        private static List<Sdk> getExistingSdks() {
            ProjectSdksModel model = new ProjectSdksModel();
            model.reset(null);
            List list = ContainerUtil.filter((Object[])model.getSdks(), it -> it.getSdkType() instanceof PythonSdkType);
            if (list == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Nullable
        private static PyDetectedSdk detectAssociatedViaRootNameEnv(@NotNull String associatedName, @NotNull Module module, @NotNull List<Sdk> existingSdks, @NotNull UserDataHolderBase context) {
            PyDetectedSdk associatedViaRootNameVirtualEnv;
            if (associatedName == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (module == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (existingSdks == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if (context == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            if ((associatedViaRootNameVirtualEnv = Visitor.findAssociatedViaRootNameEnv(associatedName, PySdkExtKt.detectVirtualEnvs(module, existingSdks, (UserDataHolder)context), Visitor::getVirtualEnvRootName)) != null) {
                return associatedViaRootNameVirtualEnv;
            }
            PyDetectedSdk associatedViaRootNameCondaEnv = Visitor.findAssociatedViaRootNameEnv(associatedName, PySdkExtKt.detectCondaEnvs(module, existingSdks, (UserDataHolder)context), Visitor::getCondaEnvRootName);
            if (associatedViaRootNameCondaEnv != null) {
                return associatedViaRootNameCondaEnv;
            }
            return null;
        }

        @Nullable
        private static PyDetectedSdk detectSystemWideSdk(@NotNull String version, @NotNull Module module, @NotNull List<Sdk> existingSdks, @NotNull UserDataHolderBase context) {
            LanguageLevel parsedVersion;
            if (version == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            if (module == null) {
                Visitor.$$$reportNull$$$0(9);
            }
            if (existingSdks == null) {
                Visitor.$$$reportNull$$$0(10);
            }
            if (context == null) {
                Visitor.$$$reportNull$$$0(11);
            }
            if ((parsedVersion = LanguageLevel.fromPythonVersion(version)).toString().equals(version)) {
                return (PyDetectedSdk)((Object)ContainerUtil.find(PySdkExtKt.detectSystemWideSdks(module, existingSdks, (UserDataHolder)context), sdk -> PySdkExtKt.getGuessedLanguageLevel(sdk) == parsedVersion));
            }
            return null;
        }

        @Nullable
        private static PyDetectedSdk findAssociatedViaRootNameEnv(@NotNull String associatedName, @NotNull List<PyDetectedSdk> envs, @NotNull Function<PyDetectedSdk, String> envRootName) {
            if (associatedName == null) {
                Visitor.$$$reportNull$$$0(12);
            }
            if (envs == null) {
                Visitor.$$$reportNull$$$0(13);
            }
            if (envRootName == null) {
                Visitor.$$$reportNull$$$0(14);
            }
            return ((StreamEx)StreamEx.of(envs).filter(sdk -> associatedName.equals(envRootName.apply((PyDetectedSdk)((Object)sdk))))).max(Comparator.comparing(PySdkExtKt::getGuessedLanguageLevel).thenComparing(ProjectJdkImpl::getHomePath)).orElse(null);
        }

        @Nullable
        private static String getVirtualEnvRootName(@NotNull PyDetectedSdk sdk) {
            String path;
            if (sdk == null) {
                Visitor.$$$reportNull$$$0(15);
            }
            return (path = sdk.getHomePath()) == null ? null : Visitor.getEnvRootName(PythonSdkUtil.getVirtualEnvRoot(path));
        }

        @Nullable
        private static String getCondaEnvRootName(@NotNull PyDetectedSdk sdk) {
            String path;
            if (sdk == null) {
                Visitor.$$$reportNull$$$0(16);
            }
            return (path = sdk.getHomePath()) == null ? null : Visitor.getEnvRootName(CondaEnvSdkFlavor.getCondaEnvRoot(path));
        }

        @Nullable
        private static String getEnvRootName(@Nullable File envRoot) {
            return envRoot == null ? null : PathUtil.getFileName((String)envRoot.getPath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyInterpreterInspection$Visitor";
                    break;
                }
                case 4: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "associatedName";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingSdks";
                    break;
                }
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envs";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envRootName";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$Visitor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExistingSdks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuitableSdkFix";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "detectAssociatedViaRootNameEnv";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "detectSystemWideSdk";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "findAssociatedViaRootNameEnv";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getVirtualEnvRootName";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getCondaEnvRootName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

