/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.emacs.EmacsProcessingHandler;
import com.intellij.formatting.IndentInfo;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PySequenceExpression;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyEmacsHandler
implements EmacsProcessingHandler {
    private static final TokenSet COMPOUND_STATEMENT_TYPES = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.IF_STATEMENT, PyTokenTypes.IF_KEYWORD, PyTokenTypes.ELIF_KEYWORD, PyTokenTypes.ELSE_KEYWORD, PyElementTypes.WHILE_STATEMENT, PyTokenTypes.WHILE_KEYWORD, PyElementTypes.FOR_STATEMENT, PyTokenTypes.FOR_KEYWORD, PyElementTypes.WITH_STATEMENT, PyTokenTypes.WITH_KEYWORD, PyElementTypes.TRY_EXCEPT_STATEMENT, PyTokenTypes.TRY_KEYWORD, PyTokenTypes.EXCEPT_KEYWORD, PyTokenTypes.FINALLY_KEYWORD, PyElementTypes.FUNCTION_DECLARATION, PyTokenTypes.DEF_KEYWORD, PyElementTypes.CLASS_DECLARATION, PyTokenTypes.CLASS_KEYWORD});

    @NotNull
    public EmacsProcessingHandler.Result changeIndent(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2) {
        int caretOffset;
        int caretLine;
        SelectionModel selectionModel;
        if (project == null) {
            PyEmacsHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            PyEmacsHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            PyEmacsHandler.$$$reportNull$$$0(2);
        }
        if ((selectionModel = editor2.getSelectionModel()).hasSelection()) {
            EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.CONTINUE;
            if (result == null) {
                PyEmacsHandler.$$$reportNull$$$0(3);
            }
            return result;
        }
        Document document = editor2.getDocument();
        if (DocumentUtil.isLineEmpty((Document)document, (int)(caretLine = document.getLineNumber(caretOffset = editor2.getCaretModel().getOffset())))) {
            EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.CONTINUE;
            if (result == null) {
                PyEmacsHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        ChangeIndentContext context = new ChangeIndentContext(project, file2, editor2, document, caretLine);
        int targetLineIndent = PyEmacsHandler.getLineIndent(context, context.targetLine);
        int soleLineIndent = PyEmacsHandler.getSoleIndent(context);
        int lineStart = context.document.getLineStartOffset(context.targetLine);
        if (caretOffset - lineStart < targetLineIndent) {
            PyEmacsHandler.changeIndent(context, soleLineIndent);
            EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.STOP;
            if (result == null) {
                PyEmacsHandler.$$$reportNull$$$0(5);
            }
            return result;
        }
        switch (PyEmacsHandler.tryToIndentToRight(context)) {
            case STOP_SUCCESSFUL: {
                EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.STOP;
                if (result == null) {
                    PyEmacsHandler.$$$reportNull$$$0(6);
                }
                return result;
            }
            case STOP_UNSUCCESSFUL: {
                EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.CONTINUE;
                if (result == null) {
                    PyEmacsHandler.$$$reportNull$$$0(7);
                }
                return result;
            }
        }
        if (PyEmacsHandler.tryToIndentToLeft(context)) {
            EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.STOP;
            if (result == null) {
                PyEmacsHandler.$$$reportNull$$$0(8);
            }
            return result;
        }
        EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.CONTINUE;
        if (result == null) {
            PyEmacsHandler.$$$reportNull$$$0(9);
        }
        return result;
    }

    private static int getSoleIndent(@NotNull ChangeIndentContext context) {
        int prevLine;
        if (context == null) {
            PyEmacsHandler.$$$reportNull$$$0(10);
        }
        PsiElement element = context.file.findElementAt(context.editor.getCaretModel().getOffset());
        for (prevLine = context.targetLine - 1; prevLine >= 0 && DocumentUtil.isLineEmpty((Document)context.document, (int)prevLine); --prevLine) {
        }
        if (prevLine < 0) {
            return -1;
        }
        int indent = PyEmacsHandler.getLineIndent(context, prevLine);
        int newIndent = -1;
        if (PyEmacsHandler.isLineStartsWithCompoundStatement(context, prevLine)) {
            newIndent = indent + context.getIndentOptions().INDENT_SIZE;
        } else if (PsiTreeUtil.getParentOfType((PsiElement)element, PySequenceExpression.class) != null && indent == 0) {
            newIndent = context.getIndentOptions().INDENT_SIZE;
        } else if (indent < PyEmacsHandler.getLineIndent(context, context.targetLine)) {
            newIndent = indent;
        }
        return newIndent;
    }

    private static ProcessingResult tryToIndentToRight(@NotNull ChangeIndentContext context) {
        if (context == null) {
            PyEmacsHandler.$$$reportNull$$$0(11);
        }
        int targetLineIndent = PyEmacsHandler.getLineIndent(context, context.targetLine);
        List<LineInfo> lineInfos = PyEmacsHandler.collectIndentsGreaterOrEqualToCurrent(context, context.targetLine);
        int newIndent = -1;
        for (int i = lineInfos.size() - 1; i >= 0; --i) {
            LineInfo lineInfo = lineInfos.get(i);
            if (lineInfo.indent == targetLineIndent && !lineInfo.startsWithCompoundStatement) continue;
            newIndent = lineInfo.indent;
            if (!lineInfo.startsWithCompoundStatement) break;
            newIndent += context.getIndentOptions().INDENT_SIZE;
            break;
        }
        if (newIndent == targetLineIndent || newIndent < 0) {
            return ProcessingResult.CONTINUE;
        }
        PyEmacsHandler.changeIndent(context, newIndent);
        return ProcessingResult.STOP_SUCCESSFUL;
    }

    private static boolean tryToIndentToLeft(@NotNull ChangeIndentContext context) {
        if (context == null) {
            PyEmacsHandler.$$$reportNull$$$0(12);
        }
        if (context.targetLine == 0 || !PyEmacsHandler.containsNonWhiteSpaceData(context.document, 0, context.targetLine)) {
            PyEmacsHandler.changeIndent(context, 0);
            return false;
        }
        int newIndent = -1;
        for (int line2 = 0; line2 < context.targetLine; ++line2) {
            if (DocumentUtil.isLineEmpty((Document)context.document, (int)line2)) continue;
            int indent = PyEmacsHandler.getLineIndent(context, line2);
            if (PyEmacsHandler.isLineStartsWithCompoundStatement(context, line2)) {
                newIndent = indent;
                break;
            }
            if (newIndent >= 0) continue;
            newIndent = indent;
        }
        if (newIndent < 0) {
            return false;
        }
        PyEmacsHandler.changeIndent(context, newIndent);
        return true;
    }

    private static void changeIndent(@NotNull ChangeIndentContext context, int newIndent) {
        if (context == null) {
            PyEmacsHandler.$$$reportNull$$$0(13);
        }
        int caretOffset = context.editor.getCaretModel().getOffset();
        String newIndentString = new IndentInfo(0, newIndent, 0).generateNewWhiteSpace(context.getIndentOptions());
        int start = context.document.getLineStartOffset(context.targetLine);
        int end = DocumentUtil.getFirstNonSpaceCharOffset((Document)context.document, (int)context.targetLine);
        context.editor.getDocument().replaceString(start, end, (CharSequence)newIndentString);
        if (caretOffset >= start && caretOffset < end) {
            context.editor.getCaretModel().moveToOffset(start + newIndentString.length());
        }
    }

    private static boolean containsNonWhiteSpaceData(@NotNull Document document, int startLine, int endLine) {
        if (document == null) {
            PyEmacsHandler.$$$reportNull$$$0(14);
        }
        int start = document.getLineStartOffset(startLine);
        int end = document.getLineStartOffset(endLine);
        for (int i = start; i < end; ++i) {
            if (DocumentUtil.isLineEmpty((Document)document, (int)i)) continue;
            return true;
        }
        return false;
    }

    private static List<LineInfo> collectIndentsGreaterOrEqualToCurrent(@NotNull ChangeIndentContext context, int targetLine) {
        if (context == null) {
            PyEmacsHandler.$$$reportNull$$$0(15);
        }
        ArrayList<LineInfo> result = new ArrayList<LineInfo>();
        int targetLineIndent = PyEmacsHandler.getLineIndent(context, targetLine);
        int soleIndent = PyEmacsHandler.getSoleIndent(context);
        if (soleIndent > 0) {
            result.add(new LineInfo(targetLine, soleIndent, false));
        } else {
            result.add(new LineInfo(targetLine, targetLineIndent, false));
        }
        int indentUsedLastTime = Integer.MAX_VALUE;
        for (int i = targetLine - 1; i >= 0 && indentUsedLastTime > targetLineIndent; --i) {
            PsiElement element;
            if (DocumentUtil.isLineEmpty((Document)context.document, (int)i)) continue;
            int indent = PyEmacsHandler.getLineIndent(context, i);
            if (indent < targetLineIndent) break;
            if (indent >= indentUsedLastTime || (element = context.file.findElementAt(context.document.getLineStartOffset(i) + indent)) == null) continue;
            ASTNode node = element.getNode();
            result.add(new LineInfo(i, indent, COMPOUND_STATEMENT_TYPES.contains(node.getElementType())));
            indentUsedLastTime = indent;
        }
        return result;
    }

    private static boolean isLineStartsWithCompoundStatement(@NotNull ChangeIndentContext context, int line2) {
        PsiElement element;
        if (context == null) {
            PyEmacsHandler.$$$reportNull$$$0(16);
        }
        if ((element = context.file.findElementAt(context.document.getLineStartOffset(line2) + PyEmacsHandler.getLineIndent(context, line2))) == null) {
            return false;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        return COMPOUND_STATEMENT_TYPES.contains(node.getElementType());
    }

    private static int getLineIndent(@NotNull ChangeIndentContext context, int line2) {
        if (context == null) {
            PyEmacsHandler.$$$reportNull$$$0(17);
        }
        int start = context.document.getLineStartOffset(line2);
        int end = context.document.getLineEndOffset(line2);
        int result = 0;
        CharSequence text2 = context.document.getCharsSequence();
        block4: for (int i = start; i < end; ++i) {
            char c = text2.charAt(i);
            switch (c) {
                case ' ': {
                    ++result;
                    continue block4;
                }
                case '\t': {
                    result += context.getIndentOptions().TAB_SIZE;
                    continue block4;
                }
                default: {
                    return result;
                }
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/editor/PyEmacsHandler";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/editor/PyEmacsHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "changeIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "changeIndent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSoleIndent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryToIndentToRight";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryToIndentToLeft";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "containsNonWhiteSpaceData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectIndentsGreaterOrEqualToCurrent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isLineStartsWithCompoundStatement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChangeIndentContext {
        @NotNull
        public final Project project;
        @NotNull
        public final PsiFile file;
        @NotNull
        public final Editor editor;
        @NotNull
        public final Document document;
        public final int targetLine;
        private CommonCodeStyleSettings.IndentOptions myIndentOptions;

        private ChangeIndentContext(@NotNull Project project, @NotNull PsiFile file2, @NotNull Editor editor2, @NotNull Document document, int targetLine) {
            if (project == null) {
                ChangeIndentContext.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                ChangeIndentContext.$$$reportNull$$$0(1);
            }
            if (editor2 == null) {
                ChangeIndentContext.$$$reportNull$$$0(2);
            }
            if (document == null) {
                ChangeIndentContext.$$$reportNull$$$0(3);
            }
            this.project = project;
            this.file = file2;
            this.editor = editor2;
            this.document = document;
            this.targetLine = targetLine;
        }

        public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
            if (this.myIndentOptions == null) {
                this.myIndentOptions = CodeStyle.getIndentOptions((PsiFile)this.file);
            }
            return this.myIndentOptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/editor/PyEmacsHandler$ChangeIndentContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LineInfo {
        public final int line;
        public final int indent;
        public final boolean startsWithCompoundStatement;

        LineInfo(int line2, int indent, boolean startsWithCompoundStatement) {
            this.line = line2;
            this.indent = indent;
            this.startsWithCompoundStatement = startsWithCompoundStatement;
        }

        public String toString() {
            return "line=" + this.line + ", indent=" + this.indent + ", compound=" + this.startsWithCompoundStatement;
        }
    }

    private static enum ProcessingResult {
        STOP_SUCCESSFUL,
        STOP_UNSUCCESSFUL,
        CONTINUE;

    }
}

