/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.remote.vfs;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.remote.vfs.MyEditorState;
import com.jetbrains.python.debugger.remote.vfs.PyRemoteDebugVirtualFile;
import com.jetbrains.python.debugger.remote.vfs.PyRemoteFileEditorPanel;
import com.jetbrains.python.debugger.remote.vfs.PyStubVirtualFile;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteFileStubEditor
extends UserDataHolderBase
implements FileEditor,
TextEditor {
    private final Project myProject;
    private final PyRemoteFileEditorPanel myEditorPanel;
    private final PyRemoteDebugVirtualFile myFile;
    private TextEditor myEditor;
    private final PyDebugProcess myRemoteDebugProcess;

    public PyRemoteFileStubEditor(Project project, PyRemoteDebugVirtualFile vFile) {
        this.myProject = project;
        this.myRemoteDebugProcess = vFile.getFileSystem().getDebugProcess();
        this.myEditorPanel = new PyRemoteFileEditorPanel(project, vFile.getPathMapper(), vFile.getRemotePath(), this);
        if (this.myRemoteDebugProcess.isDownloadSources()) {
            this.myEditorPanel.downloadContent();
        }
        this.myEditor = PyRemoteFileStubEditor.createEditor(this.myProject, "");
        this.myFile = vFile;
        this.addProcessListener(this.myRemoteDebugProcess);
    }

    public PyRemoteDebugVirtualFile getFile() {
        return this.myFile;
    }

    private void addProcessListener(PyDebugProcess remoteDebugProcess) {
        remoteDebugProcess.addProcessListener(new ProcessListener(){

            public void startNotified(@NotNull ProcessEvent event2) {
                if (event2 == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            public void processTerminated(@NotNull ProcessEvent event2) {
                if (event2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                ApplicationManager.getApplication().invokeLater(() -> PyRemoteFileStubEditor.this.close());
            }

            public void processWillTerminate(@NotNull ProcessEvent event2, boolean willBeDestroyed) {
                if (event2 == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            public void onTextAvailable(@NotNull ProcessEvent event2, @NotNull Key outputType) {
                if (event2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(4);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/debugger/remote/vfs/PyRemoteFileStubEditor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void close() {
        FileEditorManager.getInstance((Project)this.myProject).closeFile((VirtualFile)this.myFile);
    }

    public void showExecutionPoint() {
        this.myRemoteDebugProcess.getSession().showExecutionPoint();
    }

    public void setSource(String source2) {
        this.myEditor = PyRemoteFileStubEditor.createEditor(this.myProject, source2);
    }

    @Nullable
    private static TextEditor createEditor(@NotNull Project project, @NotNull String source2) {
        if (project == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(0);
        }
        if (source2 == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(1);
        }
        PyStubVirtualFile file2 = new PyStubVirtualFile(source2);
        FileEditorProvider[] providers = FileEditorProviderManager.getInstance().getProviders(project, (VirtualFile)file2);
        FileEditorProvider prov = providers[0];
        FileEditor editor2 = prov.createEditor(project, (VirtualFile)file2);
        if (editor2 instanceof TextEditor) {
            return (TextEditor)editor2;
        }
        return null;
    }

    public PyDebugProcess getRemoteDebugProcess() {
        return this.myRemoteDebugProcess;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myEditorPanel.getPanel();
        if (jPanel == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditorPanel.getPanel();
    }

    @NotNull
    public String getName() {
        return "";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(3);
        }
        return new MyEditorState(-1L, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public void setState(@NotNull FileEditorState state2) {
        if (state2 == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(4);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(5);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(6);
        }
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myEditor);
    }

    @NotNull
    public Editor getEditor() {
        Editor editor2 = this.myEditor.getEditor();
        if (editor2 == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(7);
        }
        return editor2;
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(8);
        }
        return true;
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(9);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/remote/vfs/PyRemoteFileStubEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/remote/vfs/PyRemoteFileStubEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canNavigateTo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

