/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.coverage;

import com.google.common.collect.Lists;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.SimpleCoverageAnnotator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.PathMapper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.coverage.PyCoverageEngine;
import com.jetbrains.python.coverage.PyCoverageUtil;
import com.jetbrains.python.psi.resolve.RootVisitor;
import com.jetbrains.python.psi.resolve.RootVisitorHost;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class PyCoverageRunner
extends CoverageRunner {
    private static final Logger LOG = Logger.getInstance(PyCoverageRunner.class);
    private PathMapper myPathMapper = null;

    public void setPathMapper(PathMapper pathMapper) {
        this.myPathMapper = pathMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        if (sessionDataFile == null) {
            PyCoverageRunner.$$$reportNull$$$0(0);
        }
        List<Object> sysPath = Lists.newArrayList();
        String fileName = sessionDataFile.getAbsolutePath();
        if (sessionDataFile.getAbsolutePath().endsWith(".coverage")) {
            fileName = PyCoverageRunner.getBaseFileName(sessionDataFile.getAbsolutePath());
            try {
                sysPath = PyCoverageRunner.loadSysPath(fileName);
            }
            catch (Exception e) {
                LOG.warn("Error reading syspath", (Throwable)e);
            }
            if (baseCoverageSuite != null && baseCoverageSuite.getProject() != null) {
                sysPath.addAll(PyCoverageRunner.projectPaths(baseCoverageSuite.getProject()));
            }
            if (!new File(fileName + ".xml").exists()) {
                this.generateCoverageXml(sessionDataFile);
            }
        }
        PyCoverageXmlOutputParser xmlOutputParser = new PyCoverageXmlOutputParser((List<String>)sysPath, this.myPathMapper);
        if (!fileName.endsWith(".xml")) {
            fileName = fileName + ".xml";
        }
        LOG.info("Loading coverage data from " + fileName);
        try (FileReader reader = new FileReader(fileName);){
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            xmlReader.setContentHandler(xmlOutputParser);
            xmlReader.parse(new InputSource(reader));
            ProjectData projectData = xmlOutputParser.getProjectInfo();
            return projectData;
        }
        catch (FileNotFoundException e) {
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((String)PythonProBundle.message("python.coverage.results.not.found"), (String)PythonProBundle.message("python.coverage.error")));
            return new ProjectData();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return new ProjectData();
    }

    private void generateCoverageXml(@NotNull File sessionDataFile) {
        Sdk sdk;
        if (sessionDataFile == null) {
            PyCoverageRunner.$$$reportNull$$$0(1);
        }
        if ((sdk = PythonSdkType.findLocalCPython(null)) != null) {
            GeneralCommandLine cmdLine = new GeneralCommandLine(new String[]{sdk.getHomePath()});
            ParamsGroup group2 = cmdLine.getParametersList().addParamsGroup("Coverage");
            PyCoverageUtil.addCoverageFileEnv(cmdLine, sessionDataFile.getAbsolutePath());
            PythonHelper.COVERAGEPY.addToPythonPath(cmdLine.getEnvironment());
            PythonHelper.COVERAGE.addToGroup(group2, cmdLine);
            cmdLine.getEnvironment().put("PYCHARM_RUN_COVERAGE_XML", "1");
            cmdLine.setWorkDirectory(sessionDataFile.getParent());
            try {
                CapturingProcessHandler h = new CapturingProcessHandler(cmdLine);
                ProcessOutput p = h.runProcess();
                p.checkSuccess(LOG);
            }
            catch (ExecutionException e) {
                LOG.error("Can't generate coverage xml", (Throwable)e);
            }
        }
    }

    private static String getBaseFileName(String path) {
        LOG.assertTrue(path.endsWith(".coverage"));
        return path.substring(0, path.length() - ".coverage".length());
    }

    private static List<String> projectPaths(@NotNull Project project) {
        if (project == null) {
            PyCoverageRunner.$$$reportNull$$$0(2);
        }
        final ArrayList result = Lists.newArrayList();
        for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
            RootVisitorHost.visitRoots(m, true, new RootVisitor(){

                @Override
                public boolean visitRoot(VirtualFile root, @Nullable Module module, @Nullable Sdk sdk, boolean isModuleSource) {
                    result.add(root.getPath());
                    return true;
                }
            });
        }
        return result;
    }

    private static List<String> loadSysPath(@NotNull String baseFileName) throws IOException {
        if (baseFileName == null) {
            PyCoverageRunner.$$$reportNull$$$0(3);
        }
        try {
            return FileUtil.loadLines((File)new File(baseFileName + ".syspath.txt"));
        }
        catch (Exception e) {
            LOG.warn("Can't load syspath file", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    @NotNull
    public String getPresentableName() {
        return "Python";
    }

    @NotNull
    public String getId() {
        return "coverage.py";
    }

    @NotNull
    public String getDataFileExtension() {
        return "coverage";
    }

    public String @NotNull [] getDataFileExtensions() {
        String[] stringArray = new String[]{"xml", "coverage"};
        if (stringArray == null) {
            PyCoverageRunner.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine2) {
        if (engine2 == null) {
            PyCoverageRunner.$$$reportNull$$$0(5);
        }
        return engine2 instanceof PyCoverageEngine;
    }

    private static /* synthetic */ void lambda$loadCoverageData$0() {
        Messages.showErrorDialog((String)PythonProBundle.message("python.coverage.cant.read.data"), (String)PythonProBundle.message("python.coverage.error"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFileName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/coverage/PyCoverageRunner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/coverage/PyCoverageRunner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFileExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadCoverageData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generateCoverageXml";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "projectPaths";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadSysPath";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acceptsCoverageEngine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PyCoverageXmlOutputParser
    extends DefaultHandler {
        final ProjectData myProjectInfo = new ProjectData();
        private String myCurrentClassFileName;
        private List<LineData> myLines;
        private final List<String> mySysPath;
        private final PathMapper myPathMapper;
        boolean myIsSource = false;

        PyCoverageXmlOutputParser(List<String> sysPath, PathMapper pathMapper) {
            this.mySysPath = sysPath;
            this.myPathMapper = pathMapper;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("source".equals(localName)) {
                this.myIsSource = true;
            } else if ("class".equals(localName)) {
                this.myCurrentClassFileName = attributes.getValue("filename");
                this.myLines = Lists.newArrayList();
            } else if ("line".equals(localName)) {
                LineData data = new LineData(Integer.parseInt(attributes.getValue("number")), "");
                int hits = Integer.parseInt(attributes.getValue("hits"));
                data.setHits(hits);
                if (attributes.getValue("missing-branches") != null) {
                    String[] lines;
                    for (String line2 : lines = attributes.getValue("missing-branches").split(",")) {
                        JumpData jd;
                        try {
                            jd = data.addJump(Integer.parseInt(line2));
                        }
                        catch (NumberFormatException e) {
                            jd = data.addJump(0);
                        }
                        jd.setFalseHits(hits);
                    }
                    data.fillArrays();
                }
                this.myLines.add(data);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.myIsSource) {
                this.mySysPath.add(new String(ch, start, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("source".equals(localName)) {
                this.myIsSource = false;
            }
            if ("class".equals(localName)) {
                File classFile = new File(this.myCurrentClassFileName);
                if (this.myPathMapper != null) {
                    classFile = new File(this.myPathMapper.convertToLocal(this.myCurrentClassFileName));
                }
                if (!classFile.exists()) {
                    for (String path : this.mySysPath) {
                        classFile = new File(path, this.myCurrentClassFileName);
                        if (this.myPathMapper != null) {
                            classFile = new File(this.myPathMapper.convertToLocal(classFile.getPath()));
                        }
                        if (!classFile.exists()) continue;
                        break;
                    }
                }
                ClassData data = this.myProjectInfo.getOrCreateClassData(SimpleCoverageAnnotator.getFilePath((String)classFile.getAbsolutePath()));
                int max = 0;
                for (LineData d : this.myLines) {
                    if (d.getLineNumber() <= max) continue;
                    max = d.getLineNumber();
                }
                LineData[] lines = new LineData[max + 1];
                Iterator<LineData> iterator = this.myLines.iterator();
                while (iterator.hasNext()) {
                    LineData d;
                    lines[d.getLineNumber()] = d = iterator.next();
                }
                data.setLines(lines);
            }
        }

        public ProjectData getProjectInfo() {
            return this.myProjectInfo;
        }
    }
}

