/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.coverage;

import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageLineMarkerRenderer;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.SimpleCoverageAnnotator;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.DirectoryCoverageViewExtension;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.util.Function;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.coverage.PyCoverageAnnotator;
import com.jetbrains.python.coverage.PyCoverageEnabledConfiguration;
import com.jetbrains.python.coverage.PyCoverageLineMarkerRenderer;
import com.jetbrains.python.coverage.PyCoverageSuite;
import com.jetbrains.python.coverage.PyCoverageUtil;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.resolve.RootVisitor;
import com.jetbrains.python.psi.resolve.RootVisitorHost;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCoverageEngine
extends CoverageEngine {
    private static final Logger LOG = Logger.getInstance(PyCoverageEngine.class);
    private boolean myLineHighlightingEnabled = true;

    public boolean isApplicableTo(@Nullable RunConfigurationBase conf) {
        return conf instanceof AbstractPythonRunConfiguration;
    }

    public boolean canHavePerTestCoverage(@Nullable RunConfigurationBase conf) {
        return false;
    }

    public String generateBriefReport(@NotNull Editor editor2, @NotNull PsiFile psiFile, int lineNumber, int startOffset, int endOffset, @Nullable LineData lineData) {
        if (editor2 == null) {
            PyCoverageEngine.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            PyCoverageEngine.$$$reportNull$$$0(1);
        }
        StringBuilder report = new StringBuilder();
        if (lineData == null || lineData.getHits() == 0) {
            report.append("Line was missed");
        } else {
            report.append("Line was hit");
        }
        if (lineData != null && lineData.getStatus() == 1) {
            String linesStr = PyCoverageEngine.getMissingBranches(lineData).map(x -> (Integer)x.first == 0 ? "exit" : ((Integer)x.first).toString()).collect(Collectors.joining(","));
            report.append("\n").append("Line ").append(lineNumber).append(" didn't jump to ").append("exit".equals(linesStr) ? linesStr : "line " + linesStr);
        }
        return report.toString();
    }

    public static Stream<Pair<Integer, JumpData>> getMissingBranches(@NotNull LineData lineData) {
        if (lineData == null) {
            PyCoverageEngine.$$$reportNull$$$0(2);
        }
        return IntStream.range(0, lineData.getJumps().length).mapToObj(idx -> Pair.create((Object)idx, (Object)lineData.getJumps()[idx])).filter(x -> x != null && ((JumpData)x.second).getFalseHits() > 0);
    }

    @NotNull
    public CoverageEnabledConfiguration createCoverageEnabledConfiguration(@Nullable RunConfigurationBase conf) {
        return new PyCoverageEnabledConfiguration((AbstractPythonRunConfiguration)conf);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, String[] filters, long lastCoverageTimeStamp, String suiteToMerge, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, Project project) {
        void project2;
        if (covRunner == null) {
            PyCoverageEngine.$$$reportNull$$$0(3);
        }
        if (name == null) {
            PyCoverageEngine.$$$reportNull$$$0(4);
        }
        if (coverageDataFileProvider == null) {
            PyCoverageEngine.$$$reportNull$$$0(5);
        }
        return this.createSuite(covRunner, name, coverageDataFileProvider, lastCoverageTimeStamp, trackTestFolders, coverageByTestEnabled, null, (Project)project2);
    }

    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, @NotNull CoverageEnabledConfiguration config) {
        if (covRunner == null) {
            PyCoverageEngine.$$$reportNull$$$0(6);
        }
        if (name == null) {
            PyCoverageEngine.$$$reportNull$$$0(7);
        }
        if (coverageDataFileProvider == null) {
            PyCoverageEngine.$$$reportNull$$$0(8);
        }
        if (config == null) {
            PyCoverageEngine.$$$reportNull$$$0(9);
        }
        if (config instanceof PyCoverageEnabledConfiguration) {
            PyCoverageEnabledConfiguration rConfig = (PyCoverageEnabledConfiguration)config;
            return this.createSuite(covRunner, name, coverageDataFileProvider, new Date().getTime(), config.isTrackTestFolders(), config.isTrackPerTestCoverage(), rConfig.getConfiguration().getWorkingDirectory(), config.getConfiguration().getProject());
        }
        return null;
    }

    @Nullable
    public CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner covRunner) {
        if (covRunner == null) {
            PyCoverageEngine.$$$reportNull$$$0(10);
        }
        return new PyCoverageSuite(this);
    }

    @NotNull
    public CoverageAnnotator getCoverageAnnotator(@NotNull Project project) {
        if (project == null) {
            PyCoverageEngine.$$$reportNull$$$0(11);
        }
        PyCoverageAnnotator pyCoverageAnnotator = PyCoverageAnnotator.getInstance(project);
        if (pyCoverageAnnotator == null) {
            PyCoverageEngine.$$$reportNull$$$0(12);
        }
        return pyCoverageAnnotator;
    }

    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            PyCoverageEngine.$$$reportNull$$$0(13);
        }
        return psiFile instanceof PyFile;
    }

    public boolean coverageProjectViewStatisticsApplicableTo(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            PyCoverageEngine.$$$reportNull$$$0(14);
        }
        return !fileOrDir.isDirectory() && fileOrDir.getFileType() instanceof PythonFileType;
    }

    public Object @NotNull [] postProcessExecutableLines(Object @NotNull [] executableLines, Editor editor2) {
        if (executableLines == null) {
            PyCoverageEngine.$$$reportNull$$$0(15);
        }
        Document doc = editor2.getDocument();
        Object[] objectArray = (Object[])ReadAction.compute(() -> {
            try {
                int i;
                if (editor2.getProject() == null) {
                    return executableLines;
                }
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)editor2.getProject()).getPsiFile(doc);
                if (!(psiFile instanceof PyFile)) {
                    return super.postProcessExecutableLines(executableLines, editor2);
                }
                PyStatement[] lineStatements = new PyStatement[doc.getLineCount()];
                Object[] lines = new Object[Math.max(executableLines.length, lineStatements.length + 1)];
                boolean[] isWhiteSpace = new boolean[lines.length];
                boolean[] isElse = new boolean[lines.length];
                Arrays.fill(isWhiteSpace, false);
                Arrays.fill(isElse, false);
                for (int curLine = 0; curLine < doc.getLineCount(); ++curLine) {
                    int begin = doc.getLineStartOffset(curLine);
                    int end = doc.getLineEndOffset(curLine);
                    int offset = begin;
                    boolean whiteSpaceOnly = true;
                    boolean isElseLine = false;
                    while (offset < end) {
                        PsiElement el = psiFile.findElementAt(offset);
                        if (el == null) {
                            ++offset;
                            continue;
                        }
                        if (!(el instanceof PsiWhiteSpace) && !(el instanceof PsiComment) && el.getNode().getElementType() != PyTokenTypes.DOCSTRING) {
                            PyStatement stmt;
                            if (isElseLine && el.getNode().getElementType() != PyTokenTypes.COLON) {
                                isElseLine = false;
                            }
                            whiteSpaceOnly = false;
                            if (el.getNode().getElementType() == PyTokenTypes.ELSE_KEYWORD) {
                                isElseLine = true;
                            }
                            if (!isElseLine && (stmt = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)el, PyStatement.class)) != null) {
                                lineStatements[curLine] = stmt;
                                break;
                            }
                        }
                        offset = el.getTextOffset() + el.getTextLength();
                    }
                    if (whiteSpaceOnly) {
                        isWhiteSpace[curLine] = true;
                    }
                    if (!isElseLine) continue;
                    isElse[curLine] = true;
                }
                if (executableLines.length > 1) {
                    lines[1] = executableLines[1];
                }
                for (i = 2; i < Math.min(lines.length, lineStatements.length); ++i) {
                    if (i < executableLines.length) {
                        lines[i] = executableLines[i];
                    }
                    if (lines[i] != null) continue;
                    if (lineStatements[i - 1] != null && lineStatements[i - 2] == lineStatements[i - 1]) {
                        PyCoverageEngine.fillFrom(lines, i, i - 1);
                        continue;
                    }
                    if (!isWhiteSpace[i - 1] || lines[i - 1] == null) continue;
                    PyCoverageEngine.fillFrom(lines, i, i - 1);
                    lineStatements[i - 1] = lineStatements[i - 2];
                }
                for (i = 2; i < lines.length; ++i) {
                    if (!isWhiteSpace[i - 1] || lines[i - 1] == null) continue;
                    PyCoverageEngine.fillFrom(lines, i, i - 1);
                }
                for (i = lines.length - 3; i >= 0; --i) {
                    if (!isElse[i] || lines[i + 2] == null) continue;
                    PyCoverageEngine.fillFrom(lines, i + 1, i + 2);
                }
                return lines;
            }
            catch (Exception e) {
                LOG.error("Error while post-processing coverage data");
                return executableLines;
            }
        });
        if (objectArray == null) {
            PyCoverageEngine.$$$reportNull$$$0(16);
        }
        return objectArray;
    }

    private static void fillFrom(Object[] lines, int to, int from) {
        if (lines[from] instanceof LineData) {
            LineData prevLine = (LineData)lines[from];
            LineData newLine = PyCoverageEngine.createNewLine(to, prevLine);
            lines[to] = newLine;
        }
    }

    private static LineData createNewLine(int i, LineData prevLine) {
        LineData newLine = new LineData(i, "");
        newLine.setHits(prevLine.getHits());
        newLine.setStatus((byte)prevLine.getStatus());
        return newLine;
    }

    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        if (psiFile == null) {
            PyCoverageEngine.$$$reportNull$$$0(17);
        }
        if (suite == null) {
            PyCoverageEngine.$$$reportNull$$$0(18);
        }
        return true;
    }

    @Nullable
    public String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        if (outputFile == null) {
            PyCoverageEngine.$$$reportNull$$$0(19);
        }
        if (sourceFile == null) {
            PyCoverageEngine.$$$reportNull$$$0(20);
        }
        return PyCoverageEngine.getQName(sourceFile);
    }

    @Nullable
    private static String getQName(PsiFile sourceFile) {
        VirtualFile file2 = sourceFile.getVirtualFile().getCanonicalFile();
        if (file2 == null) {
            return null;
        }
        String filePath = file2.getPath();
        if (filePath == null) {
            return null;
        }
        return SimpleCoverageAnnotator.getFilePath((String)filePath);
    }

    @NotNull
    public Set<String> getQualifiedNames(@NotNull PsiFile sourceFile) {
        String qName;
        if (sourceFile == null) {
            PyCoverageEngine.$$$reportNull$$$0(21);
        }
        Set<String> set = (qName = PyCoverageEngine.getQName(sourceFile)) != null ? Collections.singleton(qName) : Collections.emptySet();
        if (set == null) {
            PyCoverageEngine.$$$reportNull$$$0(22);
        }
        return set;
    }

    public boolean recompileProjectAndRerunAction(@NotNull Module module, @NotNull CoverageSuitesBundle suite, @NotNull Runnable chooseSuiteAction) {
        if (module == null) {
            PyCoverageEngine.$$$reportNull$$$0(23);
        }
        if (suite == null) {
            PyCoverageEngine.$$$reportNull$$$0(24);
        }
        if (chooseSuiteAction == null) {
            PyCoverageEngine.$$$reportNull$$$0(25);
        }
        return false;
    }

    public boolean includeUntouchedFileInCoverage(@NotNull String qualifiedName, @NotNull File outputFile, @NotNull PsiFile sourceFile, @NotNull CoverageSuitesBundle suite) {
        if (qualifiedName == null) {
            PyCoverageEngine.$$$reportNull$$$0(26);
        }
        if (outputFile == null) {
            PyCoverageEngine.$$$reportNull$$$0(27);
        }
        if (sourceFile == null) {
            PyCoverageEngine.$$$reportNull$$$0(28);
        }
        if (suite == null) {
            PyCoverageEngine.$$$reportNull$$$0(29);
        }
        return true;
    }

    @Nullable
    public List<Integer> collectSrcLinesForUntouchedFile(@NotNull File virtualFile2, @NotNull CoverageSuitesBundle suite) {
        if (virtualFile2 == null) {
            PyCoverageEngine.$$$reportNull$$$0(30);
        }
        if (suite == null) {
            PyCoverageEngine.$$$reportNull$$$0(31);
        }
        return null;
    }

    @NotNull
    public List<PsiElement> findTestsByNames(String @NotNull [] testNames, @NotNull Project project) {
        if (project == null) {
            PyCoverageEngine.$$$reportNull$$$0(32);
        }
        if (testNames == null) {
            PyCoverageEngine.$$$reportNull$$$0(33);
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            PyCoverageEngine.$$$reportNull$$$0(34);
        }
        return list;
    }

    @Nullable
    public String getTestMethodName(@NotNull PsiElement element, @NotNull AbstractTestProxy testProxy) {
        if (element == null) {
            PyCoverageEngine.$$$reportNull$$$0(35);
        }
        if (testProxy == null) {
            PyCoverageEngine.$$$reportNull$$$0(36);
        }
        return null;
    }

    private CoverageSuite createSuite(CoverageRunner covRunner, String name, CoverageFileProvider fileProvider, long timeStamp, boolean trackTestFolders, boolean trackPerTestCoverage, @Nullable String workingDirectory, Project project) {
        return new PyCoverageSuite(name, fileProvider, timeStamp, trackPerTestCoverage, false, trackTestFolders, covRunner, workingDirectory, this, project);
    }

    public boolean isReportGenerationAvailable(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        Sdk projectSdk;
        if (project == null) {
            PyCoverageEngine.$$$reportNull$$$0(37);
        }
        if (dataContext == null) {
            PyCoverageEngine.$$$reportNull$$$0(38);
        }
        if (currentSuite == null) {
            PyCoverageEngine.$$$reportNull$$$0(39);
        }
        return (projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk()) != null;
    }

    public void generateReport(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        if (project == null) {
            PyCoverageEngine.$$$reportNull$$$0(40);
        }
        if (dataContext == null) {
            PyCoverageEngine.$$$reportNull$$$0(41);
        }
        if (currentSuite == null) {
            PyCoverageEngine.$$$reportNull$$$0(42);
        }
        PyCoverageUtil.generateReport(project, dataContext, currentSuite);
    }

    @NotNull
    public ExportToHTMLDialog createGenerateReportDialog(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        if (project == null) {
            PyCoverageEngine.$$$reportNull$$$0(43);
        }
        if (dataContext == null) {
            PyCoverageEngine.$$$reportNull$$$0(44);
        }
        if (currentSuite == null) {
            PyCoverageEngine.$$$reportNull$$$0(45);
        }
        ExportToHTMLDialog exportToHTMLDialog = super.createGenerateReportDialog(project, dataContext, currentSuite);
        if (exportToHTMLDialog == null) {
            PyCoverageEngine.$$$reportNull$$$0(46);
        }
        return exportToHTMLDialog;
    }

    public String getPresentableText() {
        return "CoveragePy";
    }

    public CoverageLineMarkerRenderer getLineMarkerRenderer(int lineNumber, String className, TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, @NotNull CoverageSuitesBundle coverageSuite, Function<Integer, Integer> newToOldConverter, Function<Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
        if (coverageSuite == null) {
            PyCoverageEngine.$$$reportNull$$$0(47);
        }
        return PyCoverageLineMarkerRenderer.getPyRenderer(lineNumber, className, lines, coverageByTestApplicable, coverageSuite, newToOldConverter, oldToNewConverter, subCoverageActive);
    }

    public boolean shouldHighlightFullLines() {
        return this.myLineHighlightingEnabled;
    }

    public void setLineHighlightingEnabled(boolean lineHighlightingEnabled) {
        this.myLineHighlightingEnabled = lineHighlightingEnabled;
    }

    public CoverageViewExtension createCoverageViewExtension(Project project, CoverageSuitesBundle suiteBundle, CoverageViewManager.StateBean stateBean) {
        return new DirectoryCoverageViewExtension(project, this.getCoverageAnnotator(project), suiteBundle, stateBean);
    }

    public boolean isInLibraryClasses(@NotNull Project project, final @NotNull VirtualFile file2) {
        if (project == null) {
            PyCoverageEngine.$$$reportNull$$$0(48);
        }
        if (file2 == null) {
            PyCoverageEngine.$$$reportNull$$$0(49);
        }
        final Ref result = Ref.create((Object)super.isInLibraryClasses(project, file2));
        for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
            RootVisitorHost.visitRoots(m, true, new RootVisitor(){

                @Override
                public boolean visitRoot(VirtualFile root, @Nullable Module module, @Nullable Sdk sdk, boolean isModuleSource) {
                    if (isModuleSource && VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file2, (boolean)false)) {
                        result.set((Object)false);
                        return false;
                    }
                    return true;
                }
            });
        }
        return (Boolean)result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 16: 
            case 22: 
            case 34: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 16: 
            case 22: 
            case 34: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineData";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "covRunner";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageDataFileProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 11: 
            case 32: 
            case 37: 
            case 40: 
            case 43: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 16: 
            case 22: 
            case 34: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/coverage/PyCoverageEngine";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableLines";
                break;
            }
            case 18: 
            case 24: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 20: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooseSuiteAction";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNames";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProxy";
                break;
            }
            case 38: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 39: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSuite";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSuite";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/coverage/PyCoverageEngine";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageAnnotator";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "postProcessExecutableLines";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNames";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestsByNames";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenerateReportDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateBriefReport";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMissingBranches";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageSuite";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyCoverageSuite";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCoverageAnnotator";
                break;
            }
            case 12: 
            case 16: 
            case 22: 
            case 34: 
            case 46: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "coverageEditorHighlightingApplicableTo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "coverageProjectViewStatisticsApplicableTo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "postProcessExecutableLines";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "acceptedByFilters";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNames";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "recompileProjectAndRerunAction";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "includeUntouchedFileInCoverage";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "collectSrcLinesForUntouchedFile";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findTestsByNames";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTestMethodName";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isReportGenerationAvailable";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "generateReport";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createGenerateReportDialog";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerRenderer";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isInLibraryClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 16: 
            case 22: 
            case 34: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

