/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.NullableConsumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.EditSdkDialog;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.configuration.PythonPathDialog;
import com.jetbrains.python.configuration.PythonPathEditor;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSourceItem;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.add.PyAddSdkDialog;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonSdkDetailsDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(PythonSdkDetailsDialog.class);
    @NotNull
    private final Map<Sdk, SdkModificator> myModificators;
    private final Set<SdkModificator> myModifiedModificators;
    @NotNull
    private final Project myProject;
    @Nullable
    private final Module myModule;
    @NotNull
    private final NullableConsumer<? super Sdk> mySelectedSdkCallback;
    @NotNull
    private final Consumer<Boolean> myCancelCallback;
    @NotNull
    private final SdkModel.Listener mySdkModelListener;
    @NotNull
    private final PyConfigurableInterpreterList myInterpreterList;
    @NotNull
    private final ProjectSdksModel myProjectSdksModel;
    @NotNull
    private final JBList<Sdk> mySdkList;
    @NotNull
    private final JPanel myMainPanel;
    private boolean myHideOtherProjectVirtualenvs;

    public PythonSdkDetailsDialog(@NotNull Project project, @Nullable Module module, @NotNull NullableConsumer<? super Sdk> selectedSdkCallback, @NotNull Consumer<Boolean> cancelCallback) {
        if (project == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(0);
        }
        if (selectedSdkCallback == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(1);
        }
        if (cancelCallback == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myModificators = FactoryMap.create(sdk -> sdk.getSdkModificator());
        this.myModifiedModificators = new HashSet<SdkModificator>();
        this.myHideOtherProjectVirtualenvs = false;
        this.setTitle(PyBundle.message("sdk.details.dialog.title", new Object[0]));
        this.myProject = project;
        this.myModule = module;
        this.mySelectedSdkCallback = selectedSdkCallback;
        this.myCancelCallback = cancelCallback;
        this.mySdkModelListener = new MySdkModelListener();
        this.myInterpreterList = PyConfigurableInterpreterList.getInstance(this.myProject);
        this.myProjectSdksModel = this.myInterpreterList.getModel();
        this.myProjectSdksModel.addListener(this.mySdkModelListener);
        this.mySdkList = PythonSdkDetailsDialog.buildSdkList(this.myModificators, e -> this.updateOkButton());
        this.myMainPanel = PythonSdkDetailsDialog.buildPanel(this.mySdkList, new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                PythonSdkDetailsDialog.this.addSdk();
                PythonSdkDetailsDialog.this.updateOkButton();
            }
        }, new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                PythonSdkDetailsDialog.this.editSdk();
                PythonSdkDetailsDialog.this.updateOkButton();
            }
        }, new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                PythonSdkDetailsDialog.this.removeSdk();
                PythonSdkDetailsDialog.this.updateOkButton();
            }
        }, new AnActionButton[]{new ToggleVirtualEnvFilterButton(), new ShowPathButton()});
        this.init();
        this.refreshSdkList();
        this.updateOkButton();
    }

    protected void dispose() {
        this.myProjectSdksModel.removeListener(this.mySdkModelListener);
        super.dispose();
    }

    @NotNull
    private static JBList<Sdk> buildSdkList(@NotNull Map<Sdk, SdkModificator> modificators, @NotNull ListSelectionListener selectionListener) {
        if (modificators == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(3);
        }
        if (selectionListener == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(4);
        }
        JBList result = new JBList();
        result.setCellRenderer((ListCellRenderer)((Object)new PySdkListCellRenderer(modificators)));
        result.setSelectionMode(0);
        result.addListSelectionListener(selectionListener);
        new ListSpeedSearch((JList)result);
        JBList jBList = result;
        if (jBList == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(5);
        }
        return jBList;
    }

    @NotNull
    private static JPanel buildPanel(@NotNull JBList<Sdk> sdkList, @NotNull AnActionButtonRunnable addAction, @NotNull AnActionButtonRunnable editAction, @NotNull AnActionButtonRunnable removeAction, AnActionButton ... extraActions) {
        if (sdkList == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(6);
        }
        if (addAction == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(7);
        }
        if (editAction == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(8);
        }
        if (removeAction == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(9);
        }
        if (extraActions == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(10);
        }
        JPanel jPanel = ToolbarDecorator.createDecorator(sdkList).disableUpDownActions().setAddAction(addAction).setEditAction(editAction).setRemoveAction(removeAction).addExtraActions(extraActions).setPreferredSize(new Dimension(600, 500)).createPanel();
        if (jPanel == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(11);
        }
        return jPanel;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySdkList;
    }

    private void updateOkButton() {
        super.setOKActionEnabled(this.myProjectSdksModel.isModified() || !this.myModifiedModificators.isEmpty() || this.getOriginalSelectedSdk() != this.getSdk());
    }

    protected void doOKAction() {
        this.apply();
        super.doOKAction();
    }

    public void doCancelAction() {
        this.myModificators.clear();
        this.myModifiedModificators.clear();
        boolean modified = this.myProjectSdksModel.isModified();
        if (modified) {
            this.myProjectSdksModel.reset(this.myProject);
        }
        this.myCancelCallback.accept(modified);
        super.doCancelAction();
    }

    private void apply() {
        for (SdkModificator modificator : this.myModifiedModificators) {
            if (!modificator.isWritable()) continue;
            modificator.commitChanges();
        }
        this.myModificators.clear();
        this.myModifiedModificators.clear();
        try {
            this.myProjectSdksModel.apply();
        }
        catch (ConfigurationException e) {
            LOG.error((Throwable)e);
        }
        Sdk sdk = this.getOriginalSelectedSdk();
        this.mySelectedSdkCallback.consume((Object)sdk);
        if (sdk != null) {
            PyPackageManagers.getInstance().clearCache(sdk);
        }
        Disposer.dispose((Disposable)this.getDisposable());
    }

    @Nullable
    private Sdk getOriginalSelectedSdk() {
        Sdk editableSdk = this.getEditableSelectedSdk();
        return editableSdk == null ? null : this.myProjectSdksModel.findSdk(editableSdk);
    }

    @Nullable
    private Sdk getEditableSelectedSdk() {
        return (Sdk)this.mySdkList.getSelectedValue();
    }

    private void refreshSdkList() {
        List<Sdk> allPythonSdks = this.myInterpreterList.getAllPythonSdks(this.myProject);
        Sdk projectSdk = this.getSdk();
        List<Sdk> notAssociatedWithOtherProjects = ((StreamEx)StreamEx.of(allPythonSdks).filter(sdk -> !PySdkExtKt.isAssociatedWithAnotherModule(sdk, this.myModule))).toList();
        List<Sdk> pythonSdks = this.myHideOtherProjectVirtualenvs ? notAssociatedWithOtherProjects : allPythonSdks;
        this.mySdkList.setModel((ListModel)new CollectionListModel(pythonSdks));
        if (projectSdk != null) {
            projectSdk = this.myProjectSdksModel.findSdk(projectSdk.getName());
            this.mySdkList.clearSelection();
            this.mySdkList.setSelectedValue((Object)projectSdk, true);
            this.mySdkList.updateUI();
        }
    }

    @Nullable
    private Sdk getSdk() {
        if (this.myModule == null) {
            return ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.myModule);
        return rootManager.getSdk();
    }

    private void addSdk() {
        PyAddSdkDialog.show(this.myProject, this.myModule, Arrays.asList(this.myProjectSdksModel.getSdks()), new SdkAddedCallback());
    }

    private void setSelectedSdk(@Nullable Sdk selectedSdk) {
        this.mySdkList.setSelectedValue(selectedSdk == null ? null : this.myProjectSdksModel.findSdk(selectedSdk.getName()), true);
    }

    private void editSdk() {
        Sdk currentSdk = this.getEditableSelectedSdk();
        if (currentSdk != null) {
            if (currentSdk.getSdkAdditionalData() instanceof RemoteSdkAdditionalData) {
                this.editRemoteSdk(currentSdk);
            } else {
                this.editSdk(currentSdk);
            }
        }
    }

    private void editRemoteSdk(Sdk currentSdk) {
        PythonRemoteInterpreterManager remoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
        if (remoteInterpreterManager != null) {
            SdkModificator modificator = this.myModificators.get(currentSdk);
            HashSet existingSdks = Sets.newHashSet((Object[])this.myProjectSdksModel.getSdks());
            existingSdks.remove(currentSdk);
            if (remoteInterpreterManager.editSdk(this.myProject, modificator, existingSdks)) {
                this.myModifiedModificators.add(modificator);
            }
        }
    }

    private void editSdk(Sdk currentSdk) {
        SdkModificator modificator = this.myModificators.get(currentSdk);
        EditSdkDialog dialog = new EditSdkDialog(this.myProject, modificator, (NullableFunction<String, String>)((NullableFunction)s -> {
            if (this.isDuplicateSdkName((String)s, currentSdk)) {
                return PyBundle.message("sdk.details.dialog.error.duplicate.name", new Object[0]);
            }
            return null;
        }));
        if (dialog.showAndGet()) {
            boolean pathChanged;
            this.mySdkList.repaint();
            boolean bl = pathChanged = !Comparing.equal((String)currentSdk.getHomePath(), (String)dialog.getHomePath());
            if (!modificator.getName().equals(dialog.getName()) || pathChanged || dialog.isAssociateChanged()) {
                this.myModifiedModificators.add(modificator);
                modificator.setName(dialog.getName());
                modificator.setHomePath(dialog.getHomePath());
                if (dialog.isAssociateChanged()) {
                    this.setSdkAssociated(modificator, dialog.associateWithProject());
                }
                if (pathChanged) {
                    this.reloadSdk(currentSdk);
                }
            }
        }
    }

    private void setSdkAssociated(SdkModificator modificator, boolean isAssociated) {
        PythonSdkAdditionalData additionalData = (PythonSdkAdditionalData)modificator.getSdkAdditionalData();
        if (additionalData == null) {
            additionalData = new PythonSdkAdditionalData(PythonSdkFlavor.getFlavor(modificator.getHomePath()));
            modificator.setSdkAdditionalData((SdkAdditionalData)additionalData);
        }
        if (isAssociated && this.myModule != null) {
            additionalData.associateWithModule(this.myModule);
        } else if (isAssociated) {
            additionalData.setAssociatedModulePath(this.myProject.getBasePath());
        } else {
            additionalData.resetAssociatedModulePath();
        }
    }

    private boolean isDuplicateSdkName(String s, Sdk sdk) {
        for (Sdk existingSdk : this.myProjectSdksModel.getSdks()) {
            String existingName;
            if (existingSdk == sdk || !(existingName = this.myModificators.containsKey(existingSdk) ? this.myModificators.get(existingSdk).getName() : existingSdk.getName()).equals(s)) continue;
            return true;
        }
        return false;
    }

    private void removeSdk() {
        Sdk selectedSdk = this.getEditableSelectedSdk();
        if (selectedSdk != null) {
            this.myProjectSdksModel.removeSdk(selectedSdk);
            if (this.myModificators.containsKey(selectedSdk)) {
                SdkModificator modificator = this.myModificators.get(selectedSdk);
                this.myModifiedModificators.remove(modificator);
                this.myModificators.remove(selectedSdk);
            }
            this.refreshSdkList();
            Sdk currentSdk = this.getSdk();
            if (currentSdk != null) {
                this.mySdkList.setSelectedValue((Object)currentSdk, true);
            }
        }
    }

    private void reloadSdk() {
        Sdk currentSdk = this.getEditableSelectedSdk();
        if (currentSdk != null) {
            this.myModifiedModificators.add(this.myModificators.get(currentSdk));
            this.reloadSdk(currentSdk);
        }
    }

    private void reloadSdk(@NotNull Sdk currentSdk) {
        if (currentSdk == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(12);
        }
        if (PythonSdkUpdater.update(currentSdk, this.myModificators.get(currentSdk), this.myProject, null)) {
            this.myModifiedModificators.remove(this.myModificators.get(currentSdk));
            this.myModificators.put(currentSdk, currentSdk.getSdkModificator());
        }
    }

    private PythonPathEditor createPathEditor(Sdk sdk) {
        if (PythonSdkUtil.isRemote(sdk)) {
            return new PyRemotePathEditor(sdk);
        }
        return new PythonPathEditor("Classes", OrderRootType.CLASSES, FileChooserDescriptorFactory.createAllButJarContentsDescriptor()){

            @Override
            protected void onReloadButtonClicked() {
                PythonSdkDetailsDialog.this.reloadSdk();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedSdkCallback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelCallback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modificators";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionListener";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/configuration/PythonSdkDetailsDialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkList";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addAction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editAction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeAction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraActions";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/configuration/PythonSdkDetailsDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSdkList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildSdkList";
                break;
            }
            case 5: 
            case 11: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildPanel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reloadSdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SdkAddedCallback
    implements Consumer<Sdk> {
        private SdkAddedCallback() {
        }

        @Override
        public void accept(@Nullable Sdk sdk) {
            if (sdk != null && PythonSdkDetailsDialog.this.myProjectSdksModel.findSdk(sdk.getName()) == null) {
                PythonSdkDetailsDialog.this.myProjectSdksModel.addSdk(sdk);
                PythonSdkDetailsDialog.this.setSelectedSdk(sdk);
            }
        }
    }

    private class MySdkModelListener
    implements SdkModel.Listener {
        private MySdkModelListener() {
        }

        public void sdkAdded(@NotNull Sdk sdk) {
            if (sdk == null) {
                MySdkModelListener.$$$reportNull$$$0(0);
            }
            PythonSdkDetailsDialog.this.refreshSdkList();
        }

        public void sdkChanged(@NotNull Sdk sdk, String previousName) {
            if (sdk == null) {
                MySdkModelListener.$$$reportNull$$$0(1);
            }
            PythonSdkDetailsDialog.this.refreshSdkList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "sdk";
            objectArray2[1] = "com/jetbrains/python/configuration/PythonSdkDetailsDialog$MySdkModelListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sdkAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sdkChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class PyRemotePathEditor
    extends PythonPathEditor {
        private final PyRemoteSdkAdditionalDataBase myRemoteSdkData;
        private final Sdk mySdk;
        private final List<PathMappingSettings.PathMapping> myNewMappings;

        PyRemotePathEditor(Sdk sdk) {
            super("Classes", OrderRootType.CLASSES, FileChooserDescriptorFactory.createAllButJarContentsDescriptor());
            this.myNewMappings = Lists.newArrayList();
            this.mySdk = sdk;
            this.myRemoteSdkData = (PyRemoteSdkAdditionalDataBase)this.mySdk.getSdkAdditionalData();
        }

        @Override
        protected void onReloadButtonClicked() {
            PythonSdkDetailsDialog.this.reloadSdk();
        }

        @Override
        protected String getPresentablePath(VirtualFile value2) {
            String path = value2.getPath();
            return this.myRemoteSdkData.getPathMappings().convertToRemote(path);
        }

        @Override
        protected void addToolbarButtons(ToolbarDecorator toolbarDecorator) {
            toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button2) {
                    VirtualFile[] added = PyRemotePathEditor.this.doAddItems();
                    if (added.length > 0) {
                        PyRemotePathEditor.this.setModified(true);
                    }
                    PyRemotePathEditor.this.requestDefaultFocus();
                    PyRemotePathEditor.this.setSelectedRoots(added);
                }
            });
            super.addToolbarButtons(toolbarDecorator);
        }

        protected VirtualFile[] doAddItems() {
            Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myPanel));
            try {
                String[] files = PythonRemoteInterpreterManager.getInstance().chooseRemoteFiles(project, (PyRemoteSdkAdditionalDataBase)this.mySdk.getSdkAdditionalData(), false);
                String sourcesLocalPath = PythonSdkUtil.getRemoteSourcesLocalPath(this.mySdk.getHomePath());
                VirtualFile[] vFiles = new VirtualFile[files.length];
                int i = 0;
                for (String file2 : files) {
                    String localRoot = PyRemoteSourceItem.localPathForRemoteRoot(sourcesLocalPath, file2);
                    this.myNewMappings.add(new PathMappingSettings.PathMapping(localRoot, file2));
                    this.myRemoteSdkData.getPathMappings().addMappingCheckUnique(localRoot, file2);
                    if (!new File(localRoot).exists()) {
                        new File(localRoot).mkdirs();
                    }
                    vFiles[i++] = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(localRoot));
                }
                vFiles = this.adjustAddedFileSet(this.myPanel, vFiles);
                ArrayList<VirtualFile> added = new ArrayList<VirtualFile>(vFiles.length);
                for (VirtualFile vFile : vFiles) {
                    if (!this.addElement(vFile)) continue;
                    added.add(vFile);
                }
                return VfsUtilCore.toVirtualFileArray(added);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return VirtualFile.EMPTY_ARRAY;
            }
        }

        @Override
        public void apply(SdkModificator sdkModificator) {
            if (sdkModificator.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataBase) {
                for (PathMappingSettings.PathMapping mapping : this.myNewMappings) {
                    ((PyRemoteSdkAdditionalDataBase)sdkModificator.getSdkAdditionalData()).getPathMappings().addMappingCheckUnique(mapping.getLocalRoot(), mapping.getRemoteRoot());
                }
            }
            super.apply(sdkModificator);
        }
    }

    private class ShowPathButton
    extends AnActionButton
    implements DumbAware {
        ShowPathButton() {
            super(PyBundle.messagePointer("sdk.details.dialog.show.interpreter.paths", new Object[0]), AllIcons.Actions.ShowAsTree);
        }

        public boolean isEnabled() {
            return PythonSdkDetailsDialog.this.getEditableSelectedSdk() != null;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowPathButton.$$$reportNull$$$0(0);
            }
            Sdk sdk = PythonSdkDetailsDialog.this.getEditableSelectedSdk();
            PythonPathEditor pathEditor = PythonSdkDetailsDialog.this.createPathEditor(sdk);
            SdkModificator sdkModificator = (SdkModificator)PythonSdkDetailsDialog.this.myModificators.get(sdk);
            PythonPathDialog dialog = new PythonPathDialog(PythonSdkDetailsDialog.this.myProject, pathEditor);
            pathEditor.reset((SdkModificator)(sdk != null ? sdkModificator : null));
            if (dialog.showAndGet() && pathEditor.isModified()) {
                pathEditor.apply(sdkModificator);
                PythonSdkDetailsDialog.this.myModifiedModificators.add(sdkModificator);
            }
            PythonSdkDetailsDialog.this.updateOkButton();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/configuration/PythonSdkDetailsDialog$ShowPathButton", "actionPerformed"));
        }
    }

    private class ToggleVirtualEnvFilterButton
    extends ToggleActionButton
    implements DumbAware {
        ToggleVirtualEnvFilterButton() {
            super(PyBundle.messagePointer("sdk.details.dialog.hide.all.virtual.envs", new Object[0]), AllIcons.General.Filter);
        }

        public boolean isSelected(AnActionEvent e) {
            return PythonSdkDetailsDialog.this.myHideOtherProjectVirtualenvs;
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            PythonSdkDetailsDialog.this.myHideOtherProjectVirtualenvs = state2;
            PythonSdkDetailsDialog.this.refreshSdkList();
            PythonSdkDetailsDialog.this.updateOkButton();
        }
    }
}

