/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.imports.ImportCandidateHolder;
import com.jetbrains.python.codeInsight.imports.ImportChooser;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ImportFromExistingAction
implements QuestionAction {
    PsiElement myTarget;
    List<? extends ImportCandidateHolder> mySources;
    String myName;
    boolean myUseQualifiedImport;
    private Runnable myOnDoneCallback;
    private final boolean myImportLocally;

    public ImportFromExistingAction(@NotNull PsiElement target, @NotNull List<? extends ImportCandidateHolder> sources, @NotNull String name, boolean useQualified, boolean importLocally) {
        if (target == null) {
            ImportFromExistingAction.$$$reportNull$$$0(0);
        }
        if (sources == null) {
            ImportFromExistingAction.$$$reportNull$$$0(1);
        }
        if (name == null) {
            ImportFromExistingAction.$$$reportNull$$$0(2);
        }
        this.myTarget = target;
        this.mySources = sources;
        this.myName = name;
        this.myUseQualifiedImport = useQualified;
        this.myImportLocally = importLocally;
    }

    public void onDone(Runnable callback2) {
        assert (this.myOnDoneCallback == null);
        this.myOnDoneCallback = callback2;
    }

    public boolean execute() {
        PsiDocumentManager.getInstance((Project)this.myTarget.getProject()).commitAllDocuments();
        PyPsiUtils.assertValid(this.myTarget);
        if (this.myTarget instanceof PyQualifiedExpression && ((PyQualifiedExpression)this.myTarget).isQualified()) {
            return false;
        }
        for (ImportCandidateHolder importCandidateHolder : this.mySources) {
            PyPsiUtils.assertValid(importCandidateHolder.getImportable());
            PyPsiUtils.assertValid((PsiElement)importCandidateHolder.getFile());
            PyImportElement element = importCandidateHolder.getImportElement();
            if (element == null) continue;
            PyPsiUtils.assertValid((PsiElement)element);
        }
        if (this.mySources.isEmpty()) {
            return false;
        }
        if (this.mySources.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            this.doWriteAction(this.mySources.get(0));
        } else {
            this.selectSourceAndDo();
        }
        return true;
    }

    private void selectSourceAndDo() {
        ImportChooser.getInstance().selectImport(this.mySources, this.myName, this.myUseQualifiedImport, this.myTarget).onSuccess(candidate -> {
            PsiDocumentManager.getInstance((Project)this.myTarget.getProject()).commitAllDocuments();
            this.doWriteAction((ImportCandidateHolder)candidate);
        });
    }

    private void doIt(ImportCandidateHolder item) {
        PyImportElement src = item.getImportElement();
        if (src != null) {
            this.addToExistingImport(src);
        } else {
            this.addImportStatement(item);
        }
    }

    private void addImportStatement(ImportCandidateHolder item) {
        Project project = this.myTarget.getProject();
        PyElementGenerator gen = PyElementGenerator.getInstance(project);
        PsiFileSystemItem filesystemAnchor = (PsiFileSystemItem)ObjectUtils.chooseNotNull((Object)PyUtil.as(item.getImportable(), PsiFileSystemItem.class), (Object)item.getFile());
        if (filesystemAnchor == null) {
            return;
        }
        AddImportHelper.ImportPriority priority = AddImportHelper.getImportPriority(this.myTarget, filesystemAnchor);
        PsiFile file2 = this.myTarget.getContainingFile();
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)project);
        if (manager.isInjectedFragment(file2)) {
            file2 = manager.getTopLevelFile(this.myTarget);
        }
        if (PyUtil.isRoot(item.getFile())) {
            if (this.myImportLocally) {
                AddImportHelper.addLocalImportStatement(this.myTarget, this.myName);
            } else {
                AddImportHelper.addImportStatement(file2, this.myName, item.getAsName(), priority, null);
            }
        } else {
            String qualifiedName;
            QualifiedName path = item.getPath();
            String string = qualifiedName = path != null ? path.toString() : "";
            if (this.myUseQualifiedImport) {
                String nameToImport = qualifiedName;
                if (item.getImportable() instanceof PsiFileSystemItem) {
                    nameToImport = nameToImport + "." + this.myName;
                }
                if (this.myImportLocally) {
                    AddImportHelper.addLocalImportStatement(this.myTarget, nameToImport);
                } else {
                    AddImportHelper.addImportStatement(file2, nameToImport, item.getAsName(), priority, null);
                }
                this.myTarget.replace((PsiElement)gen.createExpressionFromText(LanguageLevel.forElement(this.myTarget), qualifiedName + "." + this.myName));
            } else if (this.myImportLocally) {
                AddImportHelper.addLocalFromImportStatement(this.myTarget, qualifiedName, this.myName);
            } else {
                AddImportHelper.addOrUpdateFromImportStatement(file2, qualifiedName, this.myName, item.getAsName(), priority, null);
            }
        }
    }

    private void addToExistingImport(PyImportElement src) {
        PyElementGenerator gen = PyElementGenerator.getInstance(this.myTarget.getProject());
        PsiElement parent = src.getParent();
        if (parent instanceof PyFromImportStatement) {
            AddImportHelper.addNameToFromImportStatement((PyFromImportStatement)parent, this.myName, null);
        } else {
            this.myTarget.replace((PsiElement)gen.createExpressionFromText(LanguageLevel.forElement(this.myTarget), src.getVisibleName() + "." + this.myName));
        }
    }

    private void doWriteAction(ImportCandidateHolder item) {
        PsiElement src = item.getImportable();
        if (src == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)src.getProject(), (PsiFile[])new PsiFile[]{this.myTarget.getContainingFile()}).withName(PyPsiBundle.message("ACT.CMD.use.import", new Object[0])).run(() -> this.doIt(item));
        if (this.myOnDoneCallback != null) {
            this.myOnDoneCallback.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sources";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/codeInsight/imports/ImportFromExistingAction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

