/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.actions;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Consumer;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PyCodeExecutor;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import com.jetbrains.python.console.PythonConsoleToolWindow;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.run.PythonRunConfiguration;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExecuteSelectionAction
extends DumbAwareAction {
    public PyExecuteSelectionAction() {
        super(PyBundle.messagePointer("python.execute.selection.action.execute.selection.in.console", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor2;
        if (e == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(0);
        }
        if ((editor2 = (Editor)e.getData(CommonDataKeys.EDITOR)) != null) {
            String selectionText = PyExecuteSelectionAction.getSelectionText(editor2);
            if (selectionText != null) {
                PyExecuteSelectionAction.showConsoleAndExecuteCode(e, selectionText);
            } else {
                String line2 = PyExecuteSelectionAction.getLineUnderCaret(editor2);
                if (line2 != null) {
                    PyExecuteSelectionAction.showConsoleAndExecuteCode(e, line2.trim());
                    PyExecuteSelectionAction.moveCaretDown(editor2);
                }
            }
        }
    }

    private static void moveCaretDown(Editor editor2) {
        VisualPosition pos = editor2.getCaretModel().getVisualPosition();
        Pair lines = EditorUtil.calcSurroundingRange((Editor)editor2, (VisualPosition)pos, (VisualPosition)pos);
        int offset = editor2.getCaretModel().getOffset();
        LogicalPosition lineStart = (LogicalPosition)lines.first;
        LogicalPosition nextLineStart = (LogicalPosition)lines.second;
        int start = editor2.logicalPositionToOffset(lineStart);
        int end = editor2.logicalPositionToOffset(nextLineStart);
        Document document = editor2.getDocument();
        if (nextLineStart.line < document.getLineCount()) {
            int newOffset = end + offset - start;
            int nextLineEndOffset = document.getLineEndOffset(nextLineStart.line);
            if (newOffset >= nextLineEndOffset) {
                newOffset = nextLineEndOffset;
            }
            editor2.getCaretModel().moveToOffset(newOffset);
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    public static void showConsoleAndExecuteCode(@NotNull AnActionEvent e, @Nullable String selectionText) {
        if (e == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(1);
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        Project project = e.getProject();
        boolean requestFocusToConsole = selectionText == null;
        PyExecuteSelectionAction.findCodeExecutor(e.getDataContext(), (Consumer<PyCodeExecutor>)((Consumer)codeExecutor -> PyExecuteSelectionAction.executeInConsole(codeExecutor, selectionText, editor2)), editor2, project, requestFocusToConsole);
    }

    public static void selectConsoleAndExecuteCode(@NotNull Project project, @Nullable String selectionText) {
        if (project == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(2);
        }
        DataContext dataContext = DataManager.getInstance().getDataContext();
        PyExecuteSelectionAction.selectConsole(dataContext, project, (Consumer<PyCodeExecutor>)((Consumer)codeExecutor -> PyExecuteSelectionAction.executeInConsole(codeExecutor, selectionText, null)), null, true);
    }

    private static String getLineUnderCaret(Editor editor2) {
        VisualPosition caretPos = editor2.getCaretModel().getVisualPosition();
        Pair lines = EditorUtil.calcSurroundingRange((Editor)editor2, (VisualPosition)caretPos, (VisualPosition)caretPos);
        LogicalPosition lineStart = (LogicalPosition)lines.first;
        LogicalPosition nextLineStart = (LogicalPosition)lines.second;
        int start = editor2.logicalPositionToOffset(lineStart);
        int end = editor2.logicalPositionToOffset(nextLineStart);
        if (end <= start) {
            return null;
        }
        return editor2.getDocument().getCharsSequence().subSequence(start, end).toString();
    }

    @Nullable
    private static String getSelectionText(@NotNull Editor editor2) {
        if (editor2 == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(3);
        }
        if (editor2.getSelectionModel().hasSelection()) {
            SelectionModel model = editor2.getSelectionModel();
            return model.getSelectedText();
        }
        return null;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(4);
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        Presentation presentation = e.getPresentation();
        boolean enabled = false;
        if (PyExecuteSelectionAction.isPython(editor2)) {
            String text2 = PyExecuteSelectionAction.getSelectionText(editor2);
            if (text2 != null) {
                presentation.setText(PyBundle.message("python.execute.selection.action.execute.selection.in.console", new Object[0]));
            } else {
                text2 = PyExecuteSelectionAction.getLineUnderCaret(editor2);
                if (text2 != null) {
                    presentation.setText(PyBundle.message("python.execute.selection.action.execute.line.in.console", new Object[0]));
                }
            }
            enabled = !StringUtil.isEmpty((String)text2);
        }
        presentation.setEnabledAndVisible(enabled);
    }

    public static boolean isPython(Editor editor2) {
        if (editor2 == null) {
            return false;
        }
        Project project = editor2.getProject();
        if (project == null) {
            return false;
        }
        PsiFile psi = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
        return psi instanceof PyFile;
    }

    private static void selectConsole(@NotNull DataContext dataContext, @NotNull Project project, @NotNull Consumer<PyCodeExecutor> consumer, @Nullable Editor editor2, boolean requestFocusToConsole) {
        if (dataContext == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(5);
        }
        if (project == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(7);
        }
        Collection<RunContentDescriptor> consoles = PyExecuteSelectionAction.getConsoles(project);
        ExecutionHelper.selectContentDescriptor((DataContext)dataContext, (Project)project, consoles, (String)"Select console to execute in", descriptor2 -> {
            if (descriptor2 != null && descriptor2.getExecutionConsole() instanceof PyCodeExecutor) {
                ExecutionConsole console = descriptor2.getExecutionConsole();
                consumer.consume((Object)((PyCodeExecutor)console));
                if (console instanceof PythonDebugLanguageConsoleView) {
                    XDebugSession currentSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
                    if (currentSession != null) {
                        ContentManager contentManager = currentSession.getUI().getContentManager();
                        Content content2 = contentManager.findContent("Console");
                        contentManager.setSelectedContent(content2);
                        if (requestFocusToConsole) {
                            ((PythonDebugLanguageConsoleView)console).getPydevConsoleView().requestFocus();
                        } else if (editor2 != null) {
                            IdeFocusManager.findInstance().requestFocus((Component)editor2.getContentComponent(), true);
                        }
                    }
                } else {
                    ToolWindow toolWindow;
                    PythonConsoleToolWindow consoleToolWindow = PythonConsoleToolWindow.getInstance(project);
                    ToolWindow toolWindow2 = toolWindow = consoleToolWindow != null ? consoleToolWindow.getToolWindow() : null;
                    if (toolWindow != null && !toolWindow.isVisible()) {
                        toolWindow.show(null);
                        ContentManager contentManager = toolWindow.getContentManager();
                        Content content3 = contentManager.findContent(descriptor2.getDisplayName());
                        if (content3 != null) {
                            contentManager.setSelectedContent(content3);
                        }
                    }
                }
            }
        });
    }

    public static Collection<RunContentDescriptor> getConsoles(Project project) {
        PythonConsoleToolWindow toolWindow = PythonConsoleToolWindow.getInstance(project);
        if (toolWindow != null && toolWindow.getToolWindow().isVisible()) {
            RunContentDescriptor selectedContentDescriptor = toolWindow.getSelectedContentDescriptor();
            return selectedContentDescriptor != null ? Lists.newArrayList((Object[])new RunContentDescriptor[]{selectedContentDescriptor}) : Lists.newArrayList();
        }
        Collection descriptors = ExecutionHelper.findRunningConsole((Project)project, dom -> dom.getExecutionConsole() instanceof PyCodeExecutor && PyExecuteSelectionAction.isAlive(dom));
        if (descriptors.isEmpty() && toolWindow != null && toolWindow.isInitialized()) {
            return toolWindow.getConsoleContentDescriptors();
        }
        return descriptors;
    }

    private static boolean isAlive(RunContentDescriptor dom) {
        ProcessHandler processHandler2 = dom.getProcessHandler();
        return processHandler2 != null && !processHandler2.isProcessTerminated();
    }

    public static void findCodeExecutor(@NotNull DataContext dataContext, @NotNull Consumer<PyCodeExecutor> consumer, @Nullable Editor editor2, @Nullable Project project, boolean requestFocusToConsole) {
        if (dataContext == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(9);
        }
        if (project != null) {
            if (PyExecuteSelectionAction.canFindConsole(project, null)) {
                PyExecuteSelectionAction.selectConsole(dataContext, project, consumer, editor2, requestFocusToConsole);
            } else {
                PyExecuteSelectionAction.showConsole(project, consumer);
            }
        }
    }

    private static void showConsole(Project project, Consumer<PyCodeExecutor> consumer) {
        PythonConsoleToolWindow toolWindow = PythonConsoleToolWindow.getInstance(project);
        if (toolWindow != null && toolWindow.getConsoleContentDescriptors().size() > 0) {
            toolWindow.activate(() -> {
                List<RunContentDescriptor> descs = toolWindow.getConsoleContentDescriptors();
                RunContentDescriptor descriptor2 = descs.get(0);
                if (descriptor2 != null && descriptor2.getExecutionConsole() instanceof PyCodeExecutor) {
                    consumer.consume((Object)((PyCodeExecutor)descriptor2.getExecutionConsole()));
                }
            });
        } else {
            PyExecuteSelectionAction.startNewConsoleInstance(project, consumer, null, null);
        }
    }

    public static void startNewConsoleInstance(@NotNull Project project, final @NotNull Consumer<? super PyCodeExecutor> consumer, @Nullable String runFileText, @Nullable PythonRunConfiguration config) {
        if (project == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(11);
        }
        PythonConsoleRunnerFactory consoleRunnerFactory = PythonConsoleRunnerFactory.getInstance();
        PydevConsoleRunner runner = runFileText == null || config == null ? consoleRunnerFactory.createConsoleRunner(project, null) : consoleRunnerFactory.createConsoleRunnerWithFile(project, null, runFileText, config);
        final PythonConsoleToolWindow toolWindow = PythonConsoleToolWindow.getInstance(project);
        runner.addConsoleListener(new PydevConsoleRunner.ConsoleListener(){

            @Override
            public void handleConsoleInitialized(@NotNull LanguageConsoleView consoleView) {
                if (consoleView == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (consoleView instanceof PyCodeExecutor) {
                    consumer.consume((Object)((PyCodeExecutor)consoleView));
                    if (toolWindow != null) {
                        toolWindow.getToolWindow().show(null);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/jetbrains/python/actions/PyExecuteSelectionAction$1", "handleConsoleInitialized"));
            }
        });
        runner.run(false);
    }

    public static boolean canFindConsole(@Nullable Project project, @Nullable String sdkHomePath) {
        if (project != null) {
            Collection<RunContentDescriptor> descriptors = PyExecuteSelectionAction.getConsoles(project);
            if (sdkHomePath == null) {
                return descriptors.size() > 0;
            }
            for (RunContentDescriptor descriptor2 : descriptors) {
                PythonConsoleView pythonConsole;
                ExecutionConsole console = descriptor2.getExecutionConsole();
                if (!(console instanceof PythonConsoleView) || !sdkHomePath.equals((pythonConsole = (PythonConsoleView)console).getSdkHomePath())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static void executeInConsole(@NotNull PyCodeExecutor codeExecutor, @Nullable String text2, @Nullable Editor editor2) {
        if (codeExecutor == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(12);
        }
        codeExecutor.executeCode(text2, editor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeExecutor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/actions/PyExecuteSelectionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showConsoleAndExecuteCode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "selectConsoleAndExecuteCode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectionText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "selectConsole";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findCodeExecutor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "startNewConsoleInstance";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "executeInConsole";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

