/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pyramid.templates.highlighting;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.pyramid.templates.lexer.ChameleonFlexLexer;
import com.jetbrains.pyramid.templates.lexer.ChameleonTokenTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.highlighting.PyHighlighter;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ChameleonSyntaxHighlighter
extends SyntaxHighlighterBase
implements ChameleonTokenTypes {
    private final Map<IElementType, TextAttributesKey> myAttributes = new HashMap<IElementType, TextAttributesKey>();

    public ChameleonSyntaxHighlighter() {
        this.myAttributes.put(TAL_STATEMENT, XmlHighlighterColors.XML_TAG);
        this.myAttributes.put(METAL_STATEMENT, XmlHighlighterColors.XML_TAG);
        this.myAttributes.put(I18N_STATEMENT, XmlHighlighterColors.XML_TAG);
        this.myAttributes.put(TAL_STATEMENT_NAME, XmlHighlighterColors.XML_TAG);
        this.myAttributes.put(EQ, XmlHighlighterColors.XML_TAG);
        this.myAttributes.put(PyTokenTypes.SINGLE_QUOTED_STRING, PyHighlighter.PY_BYTE_STRING);
        this.myAttributes.put(PyTokenTypes.INTEGER_LITERAL, PyHighlighter.PY_NUMBER);
        this.myAttributes.put(PyTokenTypes.FLOAT_LITERAL, PyHighlighter.PY_NUMBER);
        this.myAttributes.put(PyTokenTypes.IMAGINARY_LITERAL, PyHighlighter.PY_NUMBER);
        this.myAttributes.put(ATTR_END_DELIM, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
        this.myAttributes.put(ATTR_START_DELIM, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
        ChameleonSyntaxHighlighter.fillMap(this.myAttributes, (TokenSet)PythonDialectsTokenSetProvider.INSTANCE.getKeywordTokens(), (TextAttributesKey)PyHighlighter.PY_KEYWORD);
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack((TextAttributesKey)this.myAttributes.get(tokenType));
        if (textAttributesKeyArray == null) {
            ChameleonSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new ChameleonFlexLexer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/pyramid/templates/highlighting/ChameleonSyntaxHighlighter", "getTokenHighlights"));
    }
}

