/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.editor;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.mako.MakoElementTypes;
import com.jetbrains.mako.MakoTokenTypes;
import com.jetbrains.mako.psi.MakoTagBlock;
import com.jetbrains.mako.psi.impl.MakoCall;
import com.jetbrains.mako.psi.impl.MakoFunction;
import com.jetbrains.mako.psi.impl.MakoNamespace;
import com.jetbrains.mako.psi.impl.MakoTag;
import com.jetbrains.mako.psi.impl.MakoTagAttribute;
import com.jetbrains.mako.ref.MakoCallReference;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MakoTagAttributesContributor
extends CompletionContributor {
    public static final ElementPattern<PsiElement> TAG_ATTRIBUTE_PATTERN = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().withElementType((IElementType)MakoTokenTypes.ATTR_NAME), ((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement().withElementType(TokenSet.create((IElementType[])new IElementType[]{MakoElementTypes.OPEN_TAG, MakoElementTypes.TAG_BLOCK})))).andNot((ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement().withElementType((IElementType)MakoElementTypes.TAG_ATTRIBUTE)))});
    public static final Map<String, String[]> TAG_TO_ATTRIBUTES = Maps.newHashMap();

    public MakoTagAttributesContributor() {
        this.extend(CompletionType.BASIC, TAG_ATTRIBUTE_PATTERN, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                MakoTag tag;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                PsiElement original = parameters.getPosition();
                NavigatablePsiElement tagBlock = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)original, (Class[])new Class[]{MakoTag.class, MakoTagBlock.class});
                String tagName = "";
                HashSet usedAttrs = Sets.newHashSet();
                if (tagBlock == null) {
                    tagBlock = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)original, MakoFunction.class);
                    if (tagBlock != null) {
                        tagName = "def";
                    }
                } else {
                    tagName = tagBlock.getName();
                    if (tagBlock instanceof MakoNamespace) {
                        tagName = "namespace";
                    }
                }
                List children2 = (tag = (MakoTag)PsiTreeUtil.getChildOfType((PsiElement)tagBlock, MakoTag.class)) != null ? PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)tag, MakoTagAttribute.class) : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)tagBlock, MakoTagAttribute.class);
                for (String[] attr : children2) {
                    usedAttrs.add(attr.getName());
                }
                String[] attributes = TAG_TO_ATTRIBUTES.get(tagName);
                if (attributes != null) {
                    for (String attr : attributes) {
                        if (usedAttrs.contains(attr)) continue;
                        result.addElement((LookupElement)LookupElementBuilder.create((String)attr).withInsertHandler((InsertHandler)new AttributeInsertHandler()));
                    }
                } else {
                    ResolveResult[] resolveResults;
                    MakoCall call = (MakoCall)PsiTreeUtil.getParentOfType((PsiElement)original, MakoCall.class);
                    if (call == null) {
                        return;
                    }
                    MakoCallReference ref = call.getReference();
                    for (ResolveResult resolved : resolveResults = ref.multiResolve(true)) {
                        PsiElement resolvedElement = resolved.getElement();
                        if (!(resolvedElement instanceof PyFunction)) continue;
                        for (PyParameter param : ((PyFunction)resolvedElement).getParameterList().getParameters()) {
                            if (param.getName() == null || usedAttrs.contains(param.getName())) continue;
                            result.addElement((LookupElement)LookupElementBuilder.create((String)param.getName()).withInsertHandler((InsertHandler)new AttributeInsertHandler()));
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/mako/editor/MakoTagAttributesContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    static {
        TAG_TO_ATTRIBUTES.put("page", new String[]{"args", "cached", "cache_type", "cache_key", "cache_timeout", "cache_url", "cache_dir"});
        TAG_TO_ATTRIBUTES.put("include", new String[]{"file", "args"});
        TAG_TO_ATTRIBUTES.put("def", new String[]{"name", "filter", "cached", "cache_type", "cache_key", "cache_timeout", "cache_url", "cache_dir"});
        TAG_TO_ATTRIBUTES.put("block", new String[]{"name", "args", "filter", "cached", "cache_type", "cache_key", "cache_timeout", "cache_url", "cache_dir"});
        TAG_TO_ATTRIBUTES.put("namespace", new String[]{"import", "file", "name", "inheritable", "module"});
        TAG_TO_ATTRIBUTES.put("inherit", new String[]{"file"});
        TAG_TO_ATTRIBUTES.put("call", new String[]{"expr"});
        TAG_TO_ATTRIBUTES.put("doc", new String[0]);
        TAG_TO_ATTRIBUTES.put("text", new String[]{"filter"});
    }

    private static class AttributeInsertHandler
    implements InsertHandler {
        private AttributeInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                AttributeInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                AttributeInsertHandler.$$$reportNull$$$0(1);
            }
            Editor editor2 = context.getEditor();
            Document document = editor2.getDocument();
            int caretOffset = editor2.getCaretModel().getOffset();
            CharSequence chars = document.getCharsSequence();
            if (!CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"=\"") && !CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"='")) {
                String toInsert = "=\"\"";
                if (caretOffset >= document.getTextLength() || "/> \n\t\r".indexOf(document.getCharsSequence().charAt(caretOffset)) < 0) {
                    document.insertString(caretOffset, (CharSequence)(toInsert + " "));
                } else {
                    document.insertString(caretOffset, (CharSequence)toInsert);
                }
            }
            editor2.getCaretModel().moveToOffset(caretOffset + 2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/mako/editor/MakoTagAttributesContributor$AttributeInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

