/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jinja2.tags;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.jetbrains.django.lang.template.parsing.DjangoTemplateTokenTypes;
import com.jetbrains.django.lang.template.psi.VariableDeclarationProcessor;
import com.jetbrains.django.lang.template.psi.VariableDeclaringTag;
import com.jetbrains.django.lang.template.psi.impl.DjangoNamedExpressionImpl;
import com.jetbrains.django.lang.template.psi.impl.DjangoStringLiteralImpl;
import com.jetbrains.django.lang.template.ref.DjangoTemplateFileReferenceSet;
import com.jetbrains.django.ref.VariableReference;
import com.jetbrains.jinja2.parsing.Jinja2ElementTypes;
import com.jetbrains.jinja2.tags.Jinja2ImportTagBase;
import com.jetbrains.python.psi.types.PyType;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class Jinja2FromTag
extends Jinja2ImportTagBase
implements VariableDeclaringTag {
    public Jinja2FromTag(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public PsiReference[] getNamedExpressionReferences(DjangoNamedExpressionImpl djangoNamedExpression) {
        PsiReference[] psiReferenceArray;
        PsiReference reference = this.getNamedExpressionReference(djangoNamedExpression);
        if (reference != null) {
            PsiReference[] psiReferenceArray2 = new PsiReference[1];
            psiReferenceArray = psiReferenceArray2;
            psiReferenceArray2[0] = reference;
        } else {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
        }
        return psiReferenceArray;
    }

    @Nullable
    private PsiReference getNamedExpressionReference(DjangoNamedExpressionImpl djangoNamedExpression) {
        DjangoStringLiteralImpl fileLiteral;
        if (this.getImportedReferences().values().contains((Object)djangoNamedExpression) && (fileLiteral = this.getFileReferenceLiteral()) != null) {
            FileReference lastReference = DjangoTemplateFileReferenceSet.fromQuotedStringLiteral(fileLiteral).getLastReference();
            return new VariableReference((PsiElement)djangoNamedExpression, (PsiReference)lastReference);
        }
        return null;
    }

    public Map<String, DjangoNamedExpressionImpl> getImportedReferences() {
        LinkedHashMap<String, DjangoNamedExpressionImpl> result = new LinkedHashMap<String, DjangoNamedExpressionImpl>();
        boolean afterAs = false;
        String lastName = null;
        DjangoNamedExpressionImpl lastExpression = null;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getPsi() instanceof DjangoNamedExpressionImpl) {
                DjangoNamedExpressionImpl namedExpression = (DjangoNamedExpressionImpl)child.getPsi();
                if (!afterAs) {
                    result.put(namedExpression.getName(), namedExpression);
                    lastExpression = namedExpression;
                    lastName = namedExpression.getName();
                    continue;
                }
                result.remove(lastName);
                result.put(namedExpression.getName(), lastExpression);
                continue;
            }
            if (child.getElementType() == Jinja2ElementTypes.SOFT_KEYWORD && child.getText().equals("as")) {
                afterAs = true;
                continue;
            }
            if (child.getElementType() != DjangoTemplateTokenTypes.COMMA) continue;
            afterAs = false;
        }
        return result;
    }

    @Override
    public String toString() {
        return "Jinja2FromTag";
    }

    @Override
    public boolean processVariableDeclarations(VariableDeclarationProcessor processor2, boolean insideTag) {
        Map<String, DjangoNamedExpressionImpl> importedReferences = this.getImportedReferences();
        String name = processor2.getTargetName();
        if (name != null) {
            DjangoNamedExpressionImpl expression = importedReferences.get(name);
            if (expression != null) {
                PsiElement target;
                PsiReference reference = this.getNamedExpressionReference(expression);
                PsiElement psiElement = target = reference != null ? reference.resolve() : null;
                if (target != null && !processor2.processVariableDeclaration(name, target, this)) {
                    return false;
                }
            }
        } else {
            for (Map.Entry<String, DjangoNamedExpressionImpl> entry : importedReferences.entrySet()) {
                PsiElement target = this.getNamedExpressionReference(entry.getValue()).resolve();
                if (target == null || processor2.processVariableDeclaration(entry.getKey(), target, this)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public PyType computeVariableType() {
        return null;
    }
}

