/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.testRunner;

import com.google.common.collect.Lists;
import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.testRunner.DjangoTestUtil;
import com.jetbrains.django.testRunner.DjangoTestsConfigurationType;
import com.jetbrains.django.testRunner.DjangoTestsRunConfiguration;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.buildout.config.psi.BuildoutPsiUtil;
import com.jetbrains.python.buildout.config.psi.impl.BuildoutCfgFile;
import com.jetbrains.python.buildout.config.psi.impl.BuildoutCfgSection;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class DjangoTestsConfigurationProducer
extends LazyRunConfigurationProducer<DjangoTestsRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = (ConfigurationFactory)ConfigurationTypeUtil.findConfigurationType(DjangoTestsConfigurationType.class);
        if (configurationFactory == null) {
            DjangoTestsConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull DjangoTestsRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PyClass aClass;
        PyClass pyClass;
        PsiElement file2;
        PsiElement element;
        if (configuration == null) {
            DjangoTestsConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            DjangoTestsConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            DjangoTestsConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (!((element = (PsiElement)sourceElement.get()).getContainingFile() instanceof PyFile) && !(element instanceof PsiDirectory)) {
            return false;
        }
        if (DjangoTestsConfigurationProducer.doNotUseTestRunner(element)) {
            return false;
        }
        Object object = file2 = element instanceof PsiFileSystemItem ? element : element.getContainingFile();
        if (file2 instanceof PyFile) {
            ArrayList result = Lists.newArrayList();
            for (PyClass cls : ((PyFile)file2).getTopLevelClasses()) {
                if (!DjangoTestUtil.isDjangoTestCaseClass(cls)) continue;
                result.add(cls);
            }
            if (result.isEmpty()) {
                return false;
            }
        }
        if ((pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false)) != null && !DjangoTestUtil.isDjangoTestCaseClass(pyClass)) {
            return false;
        }
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false);
        if (pyFunction != null && (aClass = pyFunction.getContainingClass()) != null && !DjangoTestUtil.isDjangoTestCaseClass(aClass)) {
            return false;
        }
        String appName = DjangoTestUtil.getAppNameForLocation(context.getModule(), element);
        if (appName != null) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module == null) {
                return false;
            }
            String target = DjangoTestUtil.buildTargetFromLocation(module, appName, element);
            DjangoTestsConfigurationProducer.setupConfiguration(configuration, appName, module, target);
            return true;
        }
        if (DjangoFacet.isPresent(context.getModule()) && element instanceof PsiDirectory) {
            VirtualFile virtualFile2 = ((PsiDirectory)element).getVirtualFile();
            DjangoFacet djangoFacet = DjangoFacet.getInstance(context.getModule());
            assert (djangoFacet != null);
            if (element.getProject().getBaseDir().equals(virtualFile2) || virtualFile2.equals(((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getProjectRootFolderFile())) {
                configuration.setName("Test: " + ((PsiDirectory)element).getName());
                configuration.setUseModuleSdk(true);
                configuration.setModule(context.getModule());
                return true;
            }
        }
        return false;
    }

    private static void setupConfiguration(DjangoTestsRunConfiguration configuration, String appName, Module module, String target) {
        configuration.setName("Test: " + target);
        configuration.setUseModuleSdk(true);
        configuration.setModule(module);
        configuration.setTarget(target);
        DjangoTestsConfigurationProducer.setDefaultSettingsFile(configuration, appName);
    }

    private static void setDefaultSettingsFile(DjangoTestsRunConfiguration configuration, String appName) {
        BuildoutCfgSection section;
        BuildoutCfgFile configFile;
        BuildoutFacet buildoutFacet = BuildoutFacet.getInstance(configuration.getModule());
        if (buildoutFacet != null && (configFile = buildoutFacet.getConfigPsiFile()) != null && (section = BuildoutPsiUtil.getDjangoSection(configFile)) != null && appName.equals(section.getOptionValue("test"))) {
            VirtualFile settingsFile;
            String projectName = section.getOptionValue("project");
            String settingsFileName = section.getOptionValue("settings");
            if (projectName != null && settingsFileName != null && (settingsFile = PyUtil.findInRoots(configuration.getModule(), projectName + "/" + settingsFileName + ".py")) != null) {
                configuration.setSettingsFile(settingsFile.getPath());
            }
        }
    }

    public boolean isConfigurationFromContext(@NotNull DjangoTestsRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Location location;
        if (configuration == null) {
            DjangoTestsConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            DjangoTestsConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((location = context.getLocation()) == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        String appName = DjangoTestUtil.getAppNameForLocation(context.getModule(), element);
        if (appName != null) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module == null) {
                return false;
            }
            String target = DjangoTestUtil.buildTargetFromLocation(module, appName, element);
            return configuration.getTarget().equals(target);
        }
        return false;
    }

    public static RunnerAndConfigurationSettings createConfiguration(Module module, String appName, @NotNull Project project) {
        if (project == null) {
            DjangoTestsConfigurationProducer.$$$reportNull$$$0(6);
        }
        RunnerAndConfigurationSettings result = RunManager.getInstance((Project)project).createConfiguration("", DjangoTestsConfigurationType.class);
        String target = DjangoTestUtil.buildTargetFromLocation(module, appName, null);
        DjangoTestsRunConfiguration configuration = (DjangoTestsRunConfiguration)result.getConfiguration();
        DjangoTestsConfigurationProducer.setupConfiguration(configuration, appName, module, target);
        return result;
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return !DjangoTestsConfigurationProducer.doNotUseTestRunner(self.getSourceElement());
    }

    private static boolean doNotUseTestRunner(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            DjangoTestsConfigurationProducer.$$$reportNull$$$0(7);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            return false;
        }
        DjangoFacet facet = DjangoFacet.getInstance(module);
        if (facet == null) {
            return false;
        }
        return ((DjangoFacetConfiguration)facet.getConfiguration()).doNotUseTestRunner();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/testRunner/DjangoTestsConfigurationProducer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/testRunner/DjangoTestsConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doNotUseTestRunner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

