/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.ref;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.django.DjangoNames;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.applications.DjangoAppConfigClassUtil;
import com.jetbrains.django.ref.DjangoDirectoryReferenceSet;
import com.jetbrains.django.ref.DjangoItemReferenceSet;
import com.jetbrains.django.templateFSLoader.PyDjangoTemplateFSLoader;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.PsiQuery;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralFileReferenceSet;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.WeakFileReference;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyPathEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoSettingsPyReferenceProvider
extends PsiReferenceProvider {
    private static final PsiElementPattern.Capture<PsiElement> LOG_CLASS_PATTERN = DjangoPsiUtil.valueInsideDictPattern("class", "LOGGING");

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(1);
        }
        if (!DjangoFacet.isPresent(element)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        assert (element instanceof PyStringLiteralExpression);
        PyStringLiteralExpression stringLiteral = (PyStringLiteralExpression)element;
        PsiReference[] references2 = DjangoSettingsPyReferenceProvider.findInOsPathJoin(stringLiteral);
        if (references2 != null) {
            if (references2 == null) {
                DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(3);
            }
            return references2;
        }
        if (DjangoPsiUtil.isSettingsPy(element)) {
            if (DjangoSettingsPyReferenceProvider.isShouldBeAFilePath(element)) {
                PsiReference[] psiReferenceArray = this.getFileReferencesForStringLiteral(element, stringLiteral);
                if (psiReferenceArray == null) {
                    DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(4);
                }
                return psiReferenceArray;
            }
            if (DjangoSettingsPyReferenceProvider.inTemplateLoadersList(element) || DjangoSettingsPyReferenceProvider.inStaticFilesFindersList(element)) {
                PsiReference[] psiReferenceArray = DjangoItemReferenceSet.createClassesAndFunctionsReferenceSet(element).getAllReferences();
                if (psiReferenceArray == null) {
                    DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(5);
                }
                return psiReferenceArray;
            }
            if (DjangoSettingsPyReferenceProvider.inMiddlewareClassesList(element) || DjangoSettingsPyReferenceProvider.inFileUploadHandlersList(element) || DjangoSettingsPyReferenceProvider.inLogClasses(element) || DjangoSettingsPyReferenceProvider.inTestRunner(element) || DjangoPsiUtil.isElementOfListAssignedTo(element, "AUTHENTICATION_BACKENDS")) {
                PsiReference[] psiReferenceArray = DjangoItemReferenceSet.createClassesReferenceSet(element).getAllReferences();
                if (psiReferenceArray == null) {
                    DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(6);
                }
                return psiReferenceArray;
            }
            if (DjangoSettingsPyReferenceProvider.inInstalledAppsList(element)) {
                PsiReference[] psiReferenceArray = DjangoAppConfigClassUtil.getAppReferences(element);
                if (psiReferenceArray == null) {
                    DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(7);
                }
                return psiReferenceArray;
            }
            if (DjangoSettingsPyReferenceProvider.inTemplateContextProcessorsList(element)) {
                PsiReference[] psiReferenceArray = DjangoItemReferenceSet.createFunctionsReferenceSet(element).getAllReferences();
                if (psiReferenceArray == null) {
                    DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(8);
                }
                return psiReferenceArray;
            }
            if (DjangoPsiUtil.isAssignedTo(element.getNode(), "ROOT_URLCONF")) {
                PsiReference[] psiReferenceArray = DjangoItemReferenceSet.createFilesReferenceSet(element).getAllReferences();
                if (psiReferenceArray == null) {
                    DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(9);
                }
                return psiReferenceArray;
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(10);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(11);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static PsiReference @Nullable [] findInOsPathJoin(PyStringLiteralExpression stringLiteral) {
        PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)stringLiteral, PyCallExpression.class);
        if (call != null && call.getCallee() instanceof PyQualifiedExpression) {
            VirtualFile rootPath;
            int literalIndex;
            PyQualifiedExpression qualExpr = (PyQualifiedExpression)call.getCallee();
            if (qualExpr == null) {
                return null;
            }
            PyExpression qualifier = qualExpr.getQualifier();
            if (call.isCalleeText("join") && qualifier != null && "path".equals(qualifier.getName()) && (literalIndex = PyPsiUtils.findArgumentIndex(call, stringLiteral)) >= 0 && ((rootPath = DjangoSettingsPyReferenceProvider.evaluateRootPath(call, literalIndex)) != null || literalIndex == 0)) {
                return new PyStringLiteralFileReferenceSet(stringLiteral){

                    public FileReference createFileReference(TextRange range, int index, String text2) {
                        return new WeakFileReference(this, range, index, text2){

                            @Override
                            @Nullable
                            public HighlightSeverity getUnresolvedHighlightSeverity(TypeEvalContext context) {
                                if (literalIndex == 0) {
                                    return null;
                                }
                                return HighlightSeverity.WEAK_WARNING;
                            }
                        };
                    }

                    @Override
                    @NotNull
                    public Collection<PsiFileSystemItem> computeDefaultContexts() {
                        PsiDirectory dir;
                        if (literalIndex == 0) {
                            Collection<PsiFileSystemItem> collection = super.computeDefaultContexts();
                            if (collection == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return collection;
                        }
                        PsiFile containingFile = this.getContainingFile();
                        if (containingFile != null && (dir = containingFile.getManager().findDirectory(rootPath)) != null) {
                            ArrayList arrayList = Lists.newArrayList((Object[])new PsiFileSystemItem[]{dir});
                            if (arrayList == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return arrayList;
                        }
                        List<PsiFileSystemItem> list = Collections.emptyList();
                        if (list == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return list;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/django/ref/DjangoSettingsPyReferenceProvider$1", "computeDefaultContexts"));
                    }
                }.getAllReferences();
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile evaluateRootPath(PyCallExpression call, int literalIndex) {
        String pathBefore;
        VirtualFile file2;
        PsiFile containingFile = call.getContainingFile();
        if (containingFile != null && (file2 = containingFile.getOriginalFile().getVirtualFile()) != null && !StringUtil.isEmpty((String)(pathBefore = new PyPathEvaluator(file2.getPath()).evaluatePathInJoin(call.getArguments(), literalIndex)))) {
            VirtualFile evaluatedPath = VirtualFileUtil.findFile(pathBefore);
            if (evaluatedPath == null && file2.getFileSystem() instanceof TempFileSystem) {
                evaluatedPath = file2.getFileSystem().findFileByPath(pathBefore.replace("\\", "/"));
            }
            if (evaluatedPath == null && ApplicationManager.getApplication().isUnitTestMode()) {
                evaluatedPath = TempFileSystem.getInstance().findFileByPath(pathBefore);
            }
            return evaluatedPath;
        }
        return null;
    }

    private static boolean isShouldBeAFilePath(PsiElement element) {
        return DjangoSettingsPyReferenceProvider.inTemplatesDirsList(element) || DjangoSettingsPyReferenceProvider.inMediaRoot(element) || DjangoSettingsPyReferenceProvider.inStaticRoot(element) || DjangoSettingsPyReferenceProvider.inStaticDirsList(element) || DjangoSettingsPyReferenceProvider.inSqliteDatabaseNameValue(element);
    }

    private PsiReference[] getFileReferencesForStringLiteral(PsiElement element, PyStringLiteralExpression stringLiteral) {
        PsiFile file2 = DjangoPsiUtil.getFile(element);
        if (file2 == null || file2.getParent() == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        List<TextRange> textRanges = stringLiteral.getStringValueTextRanges();
        if (textRanges.size() > 0) {
            if (DjangoSettingsPyReferenceProvider.inSqliteDatabaseNameValue(element)) {
                return new SqlitePathFileReferenceSet(stringLiteral).getAllReferences();
            }
            return new DjangoDirectoryReferenceSet(PyStringLiteralUtil.stripQuotesAroundValue(stringLiteral.getStringValue()), stringLiteral, textRanges.get(0).getStartOffset(), null, SystemInfo.isFileSystemCaseSensitive).getAllReferences();
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean inSqliteDatabaseNameValue(PsiElement element) {
        PyAssignmentStatement parent;
        ASTNode node = element.getNode().getTreeParent();
        return "NAME".equals(PyStringLiteralUtil.getStringValue(node.getFirstChildNode().getText())) && node.getFirstChildNode().getPsi() != element && DjangoSettingsPyReferenceProvider.isSqliteEngine(node) && (parent = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAssignmentStatement.class)) != null && parent.isAssignmentTo("DATABASES");
    }

    private static boolean isSqliteEngine(ASTNode node) {
        ASTNode parentNode = node.getTreeParent();
        if (parentNode.getElementType() == PyElementTypes.DICT_LITERAL_EXPRESSION) {
            for (ASTNode child = parentNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (child.getElementType() != PyElementTypes.KEY_VALUE_EXPRESSION || !"ENGINE".equals(PyStringLiteralUtil.getStringValue(child.getFirstChildNode().getText()))) continue;
                return PyStringLiteralUtil.getStringValue(child.getLastChildNode().getText()).endsWith("sqlite3");
            }
        }
        return false;
    }

    private static boolean inInstalledAppsList(PsiElement element) {
        return DjangoPsiUtil.isElementOfListAssignedTo(element, ".+_APPS") || DjangoPsiUtil.isElementOfListArgumentToCall(element, "INSTALLED_APPS", "extends");
    }

    private static boolean inTemplatesDirsList(PsiElement element) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return false;
        }
        PyFile settingsFile = DjangoSettingsPy.getSettingsFile(module);
        if (settingsFile == null) {
            return false;
        }
        PyDjangoTemplateFSLoader loader = PyDjangoTemplateFSLoader.getForSettings(settingsFile);
        return loader.isInTemplatesDirsList(element);
    }

    private static boolean inStaticDirsList(PsiElement element) {
        List<PyExpression> ex;
        if (DjangoPsiUtil.isElementOfListAssignedTo(element, "STATICFILES_DIRS")) {
            return true;
        }
        PyParenthesizedExpression par = (PyParenthesizedExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyParenthesizedExpression.class);
        return par != null && DjangoPsiUtil.isElementOfListAssignedTo((PsiElement)par, "STATICFILES_DIRS") && (ex = PyUtil.flattenedParensAndTuples(par)).size() == 2 && element == ex.get(1);
    }

    private static boolean inTemplateLoadersList(PsiElement element) {
        return new PsiQuery<PsiElement>(element).ancestors(PySequenceExpression.class).ancestors(PyKeyValueExpression.class).filter(o -> "loaders".equals(PyEvaluator.evaluate(o.getKey(), String.class))).ancestors(PyKeyValueExpression.class).filter(o -> "OPTIONS".equals(PyEvaluator.evaluate(o.getKey(), String.class))).ancestors(PyAssignmentStatement.class).map(o -> o.getLeftHandSideExpression()).filter(new PsiQuery.PsiNameFilter<PyTargetExpression>(PyTargetExpression.class, "TEMPLATES")).exists() || DjangoPsiUtil.isElementOfListAssignedTo(element, "TEMPLATE_LOADERS");
    }

    private static boolean inStaticFilesFindersList(PsiElement element) {
        return DjangoPsiUtil.isElementOfListAssignedTo(element, "STATICFILES_FINDERS");
    }

    private static boolean inMiddlewareClassesList(PsiElement element) {
        return DjangoPsiUtil.isElementOfListAssignedTo(element, DjangoNames.MIDDLEWARE_SETTING);
    }

    private static boolean inMediaRoot(PsiElement element) {
        return DjangoPsiUtil.isAssignedTo(element.getNode(), "MEDIA_ROOT");
    }

    private static boolean inTestRunner(PsiElement element) {
        return DjangoPsiUtil.isAssignedTo(element.getNode(), "TEST_RUNNER");
    }

    private static boolean inStaticRoot(PsiElement element) {
        return DjangoPsiUtil.isAssignedTo(element.getNode(), "STATIC_ROOT");
    }

    private static boolean inFileUploadHandlersList(PsiElement element) {
        return DjangoPsiUtil.isElementOfListAssignedTo(element, "FILE_UPLOAD_HANDLERS");
    }

    private static boolean inTemplateContextProcessorsList(PsiElement element) {
        return DjangoPsiUtil.isElementOfListAssignedTo(element, "TEMPLATE_CONTEXT_PROCESSORS");
    }

    private static boolean inLogClasses(PsiElement element) {
        return LOG_CLASS_PATTERN.accepts((Object)element.getFirstChild(), new ProcessingContext());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/ref/DjangoSettingsPyReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/ref/DjangoSettingsPyReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SqlitePathFileReferenceSet
    extends PyStringLiteralFileReferenceSet {
        SqlitePathFileReferenceSet(PyStringLiteralExpression stringLiteral) {
            super(stringLiteral);
        }

        public FileReference createFileReference(TextRange range, int index, String text2) {
            return new WeakFileReference(this, range, index, text2){

                public Object @NotNull [] getVariants() {
                    ArrayList<Object> variants = new ArrayList<Object>(Arrays.asList(super.getVariants()));
                    if (this.getIndex() == 0) {
                        variants.add(":memory:");
                    }
                    Object[] objectArray = variants.toArray();
                    if (objectArray == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return objectArray;
                }

                @Override
                @Nullable
                public HighlightSeverity getUnresolvedHighlightSeverity(TypeEvalContext context) {
                    if (this.getText().contains(":memory:")) {
                        return null;
                    }
                    return super.getUnresolvedHighlightSeverity(context);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/django/ref/DjangoSettingsPyReferenceProvider$SqlitePathFileReferenceSet$1", "getVariants"));
                }
            };
        }

        @Override
        @NotNull
        public Collection<PsiFileSystemItem> computeDefaultContexts() {
            PsiFile file2 = this.getContainingFile();
            if (file2 == null) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    SqlitePathFileReferenceSet.$$$reportNull$$$0(0);
                }
                return list;
            }
            if (this.isAbsolutePathReference()) {
                Collection<PsiFileSystemItem> collection = super.computeDefaultContexts();
                if (collection == null) {
                    SqlitePathFileReferenceSet.$$$reportNull$$$0(1);
                }
                return collection;
            }
            PsiDirectory root = DjangoUtil.getProjectRoot((PsiFileSystemItem)file2);
            if (root != null) {
                ArrayList arrayList = Lists.newArrayList((Object[])new PsiFileSystemItem[]{root});
                if (arrayList == null) {
                    SqlitePathFileReferenceSet.$$$reportNull$$$0(2);
                }
                return arrayList;
            }
            List<PsiFileSystemItem> list = DjangoDirectoryReferenceSet.getModuleRoots((PsiElement)file2);
            if (list == null) {
                SqlitePathFileReferenceSet.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/django/ref/DjangoSettingsPyReferenceProvider$SqlitePathFileReferenceSet", "computeDefaultContexts"));
        }
    }
}

