/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.lang.template.psi.DjangoTagName;
import com.jetbrains.django.lang.template.psi.impl.DjangoTagElementImpl;
import com.jetbrains.django.model.DjangoClosingTagTools;
import com.jetbrains.django.model.DjangoTagLibrary;
import com.jetbrains.django.model.TemplateLanguageTagLibraries;
import com.jetbrains.django.model.TemplateLanguageTagLibrary;
import com.jetbrains.django.util.DjangoTemplateUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagLibrary {
    private final Map<PyFile, CustomTagCachedData> myCustomLoadedTags = ContainerUtil.createConcurrentSoftMap();
    private static final Set<String> UNRESOLVED_CORE_TAGS = Sets.newHashSet((Object[])new String[]{"extends", "include", "block", "empty", "else", "plural", "elif"});

    public static boolean isUnresolvedTag(@NotNull DjangoTagName tag) {
        if (tag == null) {
            TagLibrary.$$$reportNull$$$0(0);
        }
        return !DjangoClosingTagTools.isStartsWithEndPrefix(tag.getTagName()) && !TagLibrary.isUnresolvedCoreTag(tag.getTagName()) && (tag.getReference() == null || tag.getReference().resolve() == null);
    }

    public static TagLibrary getInstance(Project project) {
        return (TagLibrary)ServiceManager.getService((Project)project, TagLibrary.class);
    }

    public static boolean isUnresolvedCoreTag(String tagName) {
        return UNRESOLVED_CORE_TAGS.contains(tagName);
    }

    public static boolean isIf(@NotNull String name) {
        if (name == null) {
            TagLibrary.$$$reportNull$$$0(1);
        }
        return "if".equals(name) || "ifequal".equals(name) || "ifnotequal".equals(name) || "ifchanged".equals(name);
    }

    public static boolean isEndIf(@NotNull String name) {
        String opening;
        if (name == null) {
            TagLibrary.$$$reportNull$$$0(2);
        }
        if ((opening = DjangoClosingTagTools.getOpeningByClosing(name)) == null) {
            return false;
        }
        return TagLibrary.isIf(opening);
    }

    public boolean isContainerFor(@NotNull String tagName, @NotNull DjangoTagName container) {
        if (tagName == null) {
            TagLibrary.$$$reportNull$$$0(3);
        }
        if (container == null) {
            TagLibrary.$$$reportNull$$$0(4);
        }
        return this.isContainerFor(container, tagName, container.getTagName());
    }

    public boolean isContainerFor(@NotNull PsiElement tag, @NotNull String tagName, @NotNull String containerName) {
        TemplateLanguageTagLibrary library;
        if (tag == null) {
            TagLibrary.$$$reportNull$$$0(5);
        }
        if (tagName == null) {
            TagLibrary.$$$reportNull$$$0(6);
        }
        if (containerName == null) {
            TagLibrary.$$$reportNull$$$0(7);
        }
        if ((library = TagLibrary.getTagLibrary(tag)) == null) {
            return false;
        }
        String[] innerTags = library.getInnerTags(containerName);
        for (String name : innerTags) {
            if (!tagName.equals(name)) continue;
            return true;
        }
        for (CustomTagCachedData customTagCachedData : Lists.newArrayList(this.myCustomLoadedTags.values())) {
            Set inner = (Set)customTagCachedData.myInnerTags.get(containerName);
            if (inner == null || !inner.contains(tagName)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getCustomInnerTags(@NotNull String containerName) {
        if (containerName == null) {
            TagLibrary.$$$reportNull$$$0(8);
        }
        HashSet result = Sets.newHashSet();
        for (CustomTagCachedData customTagCachedData : Lists.newArrayList(this.myCustomLoadedTags.values())) {
            Set inner = (Set)customTagCachedData.myInnerTags.get(containerName);
            if (inner == null) continue;
            result.addAll(inner);
        }
        return result;
    }

    public static boolean isEmpty(@NotNull String name) {
        if (name == null) {
            TagLibrary.$$$reportNull$$$0(9);
        }
        return "empty".equals(name);
    }

    public static boolean isElse(@NotNull String name) {
        if (name == null) {
            TagLibrary.$$$reportNull$$$0(10);
        }
        return "else".equals(name);
    }

    public static boolean isElif(@NotNull String name) {
        if (name == null) {
            TagLibrary.$$$reportNull$$$0(11);
        }
        return "elif".equals(name);
    }

    public static boolean isMiddle(String name) {
        return TagLibrary.isElse(name) || TagLibrary.isEmpty(name) || "plural".equals(name) || TagLibrary.isElif(name);
    }

    public boolean isPair(@NotNull DjangoTagElementImpl startTag, @NotNull DjangoTagElementImpl endTag) {
        if (startTag == null) {
            TagLibrary.$$$reportNull$$$0(12);
        }
        if (endTag == null) {
            TagLibrary.$$$reportNull$$$0(13);
        }
        String startTagName = DjangoTemplateUtil.getTagName(startTag);
        String endTagName = DjangoTemplateUtil.getTagName(endTag);
        if (startTagName == null || endTagName == null) {
            return false;
        }
        return TagLibrary.isStartEndTags(startTagName, endTagName) || TagLibrary.isElse(endTagName) && TagLibrary.isIf(startTagName) || TagLibrary.isElse(startTagName) && TagLibrary.isEndIf(endTagName) || this.isContainerFor((PsiElement)startTag, endTagName, startTagName) || this.isContainerFor((PsiElement)startTag, startTagName, endTagName.replaceFirst("^end", ""));
    }

    public static boolean isStartEndTags(@NotNull String startTagName, @NotNull String endTagName) {
        if (startTagName == null) {
            TagLibrary.$$$reportNull$$$0(14);
        }
        if (endTagName == null) {
            TagLibrary.$$$reportNull$$$0(15);
        }
        String closing = DjangoClosingTagTools.getOpeningByClosing(endTagName);
        return startTagName.equals(closing);
    }

    private static void addCloseTag(List<? super LookupElement> result, String tag) {
        result.add((LookupElement)LookupElementBuilder.create((String)DjangoClosingTagTools.suggestClosingTag(tag)));
    }

    public static boolean startsWithEndPrefix(@NotNull DjangoTagName tagName) {
        if (tagName == null) {
            TagLibrary.$$$reportNull$$$0(16);
        }
        return TagLibrary.startsWithEndPrefix(tagName.getTagName());
    }

    public static boolean startsWithEndPrefix(String tagName) {
        return tagName != null && DjangoClosingTagTools.isStartsWithEndPrefix(tagName);
    }

    public static String withoutEnd(@NotNull String name) {
        String suggestedOpeningTag;
        if (name == null) {
            TagLibrary.$$$reportNull$$$0(17);
        }
        if ((suggestedOpeningTag = DjangoClosingTagTools.getOpeningByClosing(name)) != null) {
            return suggestedOpeningTag;
        }
        return name;
    }

    public boolean requiresCloseTag(DjangoTagName tagName) {
        String name = tagName.getTagName();
        if (name.startsWith("if") || TagLibrary.isBlockTag(tagName, name)) {
            return true;
        }
        for (CustomTagCachedData customTagCachedData : Lists.newArrayList(this.myCustomLoadedTags.values())) {
            if (!customTagCachedData.myBlockTags.contains(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean isBlockTag(DjangoTagName tagName, String name) {
        TemplateLanguageTagLibrary library = TagLibrary.getTagLibrary(tagName);
        return library != null && library.isBlockTag(name);
    }

    @Nullable
    public static TemplateLanguageTagLibrary getTagLibrary(@NotNull PsiElement element) {
        if (element == null) {
            TagLibrary.$$$reportNull$$$0(18);
        }
        return (TemplateLanguageTagLibrary)TemplateLanguageTagLibraries.INSTANCE.forLanguage(element.getContainingFile().getLanguage());
    }

    public static LookupElement @NotNull [] getFilterLookUpElements(@NotNull PsiFile template) {
        TemplateLanguageTagLibrary tagLibrary;
        if (template == null) {
            TagLibrary.$$$reportNull$$$0(19);
        }
        if ((tagLibrary = TagLibrary.getTagLibrary((PsiElement)template)) == null) {
            if (LookupElement.EMPTY_ARRAY == null) {
                TagLibrary.$$$reportNull$$$0(20);
            }
            return LookupElement.EMPTY_ARRAY;
        }
        LookupElement[] lookupElementArray = TagLibrary.createLookupElements(tagLibrary.collectLoadedFilters(template));
        if (lookupElementArray == null) {
            TagLibrary.$$$reportNull$$$0(21);
        }
        return lookupElementArray;
    }

    public void updateCustomTagsCache(PyFile file2) {
        CustomTagCachedData cachedData = this.myCustomLoadedTags.get(file2);
        if (cachedData == null || cachedData.myModificationStamp != file2.getModificationStamp()) {
            cachedData = TagLibrary.initCustomTagsCache(file2);
            this.myCustomLoadedTags.put(file2, cachedData);
        }
    }

    public static LookupElement[] createLookupElements(Collection<? extends Pair<String, PyFunction>> filters) {
        ArrayList results = Lists.newArrayList();
        for (Pair<String, PyFunction> pair : filters) {
            results.add(LookupElementBuilder.create((Object)pair.getSecond(), (String)((String)pair.getFirst())));
        }
        return results.toArray(LookupElement.EMPTY_ARRAY);
    }

    private static CustomTagCachedData initCustomTagsCache(PyFile file2) {
        final CustomTagCachedData result = new CustomTagCachedData();
        result.myModificationStamp = file2.getModificationStamp();
        DjangoTagLibrary.processRegisteredTags(file2, new DjangoTagLibrary.TagProcessor(){

            @Override
            public void processTag(String name, PyElement declaration) {
                if (declaration instanceof PyFunction) {
                    if (TagLibrary.referencesEndTag(name, (PyFunction)declaration)) {
                        result.myBlockTags.add(name);
                    }
                    result.myInnerTags.put(name, TagLibrary.collectInnerTags((PyFunction)declaration));
                }
            }
        });
        return result;
    }

    private static Set<String> collectInnerTags(PyFunction declaration) {
        InnerTagsFinder finder = new InnerTagsFinder();
        declaration.acceptChildren(finder);
        return finder.found;
    }

    private static boolean referencesEndTag(String name, PyFunction declaration) {
        EndTagNameFinder finder = new EndTagNameFinder("end" + name);
        declaration.acceptChildren(finder);
        return finder.found;
    }

    public void addInnerCompletionVariants(@Nullable PsiElement element, final List<LookupElement> result) {
        this.processPrecedingOpenedTags(element, new OpenTagProcessor(){

            @Override
            public boolean process(@NotNull DjangoTagName tag, boolean open2) {
                if (tag == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (open2) {
                    TagLibrary.this.addInnerCompletion(tag, result);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/jetbrains/django/model/TagLibrary$2", "process"));
            }
        });
    }

    public boolean processTagIfNotClosed(PsiElement tagElement, Stack<DjangoTagName> closeTags, OpenTagProcessor processor2) {
        PsiElement[] elements;
        for (PsiElement e : elements = PsiTreeUtil.collectElements((PsiElement)tagElement, element -> element instanceof DjangoTagName)) {
            DjangoTagName tag = (DjangoTagName)e;
            if (tag == null) continue;
            if (TagLibrary.startsWithEndPrefix(tag.getTagName())) {
                closeTags.push(tag);
                continue;
            }
            if (this.requiresCloseTag(tag)) {
                DjangoTagName lastClosed = null;
                if (!closeTags.isEmpty()) {
                    lastClosed = closeTags.peek();
                }
                if (lastClosed == null) {
                    if (processor2.process(tag, true)) continue;
                    return false;
                }
                String name = DjangoClosingTagTools.getOpeningByClosingIfPossible(lastClosed.getTagName());
                if (!tag.getTagName().equals(name)) {
                    if (processor2.process(tag, true)) continue;
                    return false;
                }
                closeTags.pop();
                if (processor2.process(tag, false)) continue;
                return false;
            }
            if (processor2.process(tag, true)) continue;
            return false;
        }
        return true;
    }

    public void processPrecedingOpenedTags(PsiElement element, OpenTagProcessor processor2) {
        DjangoTagElementImpl parent = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)element, DjangoTagElementImpl.class);
        Stack<DjangoTagName> closeTags = new Stack<DjangoTagName>();
        while (((parent = (DjangoTagElementImpl)PsiTreeUtil.getPrevSiblingOfType((PsiElement)parent, DjangoTagElementImpl.class)) == null || this.processTagIfNotClosed((PsiElement)parent, closeTags, processor2)) && parent != null) {
        }
    }

    private void addInnerCompletion(DjangoTagName tag, List<LookupElement> result) {
        String tagName = tag.getTagName();
        TemplateLanguageTagLibrary library = TagLibrary.getTagLibrary(tag);
        if (library != null) {
            String[] innerTags = library.getInnerTags(tagName);
            for (String innerTag : innerTags) {
                result.add((LookupElement)LookupElementBuilder.create((String)innerTag));
            }
            if (this.requiresCloseTag(tag)) {
                TagLibrary.addCloseTag(result, tagName);
            }
        }
        Set<String> customInnerTags = this.getCustomInnerTags(tagName);
        for (String customTag : customInnerTags) {
            result.add((LookupElement)LookupElementBuilder.create((String)customTag));
        }
    }

    public static boolean isCloseTagFor(@NotNull DjangoTagName close2, @NotNull DjangoTagName open2) {
        if (close2 == null) {
            TagLibrary.$$$reportNull$$$0(22);
        }
        if (open2 == null) {
            TagLibrary.$$$reportNull$$$0(23);
        }
        return TagLibrary.isCloseTagFor(close2.getTagName(), open2.getTagName());
    }

    public static boolean isCloseTagFor(@Nullable String closeTag, @Nullable String openTag) {
        if (openTag != null && closeTag != null) {
            return TagLibrary.isStartEndTags(openTag, closeTag);
        }
        return false;
    }

    public static boolean isDefaultTag(DjangoTagName tagName) {
        Language language = tagName.getContainingFile().getLanguage();
        String name = tagName.getTagName();
        return TagLibrary.isDefaultTag(language, name);
    }

    public static boolean isDefaultTag(Language language, String name) {
        TemplateLanguageTagLibrary tagLibrary;
        String suggestedOpeningTag = DjangoClosingTagTools.getOpeningByClosingIfPossible(name);
        if (suggestedOpeningTag != null) {
            name = suggestedOpeningTag;
        }
        return (tagLibrary = (TemplateLanguageTagLibrary)TemplateLanguageTagLibraries.INSTANCE.forLanguage(language)).isBlockTag(name) || tagLibrary.getCoreTags().contains(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startTag";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endTag";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startTagName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endTagName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/TagLibrary";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "close";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "open";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/TagLibrary";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterLookUpElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUnresolvedTag";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isIf";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEndIf";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isContainerFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCustomInnerTags";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isElse";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isElif";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isPair";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isStartEndTags";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "startsWithEndPrefix";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "withoutEnd";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTagLibrary";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFilterLookUpElements";
                break;
            }
            case 20: 
            case 21: {
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isCloseTagFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface OpenTagProcessor {
        public boolean process(@NotNull DjangoTagName var1, boolean var2);
    }

    private static class EndTagNameFinder
    extends PyRecursiveElementVisitor {
        private final String name;
        private boolean found;

        EndTagNameFinder(String name) {
            this.name = name;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                EndTagNameFinder.$$$reportNull$$$0(0);
            }
            if (this.found) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
            if (this.name.equals(node.getStringValue())) {
                this.found = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/django/model/TagLibrary$EndTagNameFinder", "visitElement"));
        }
    }

    private static class InnerTagsFinder
    extends PyRecursiveElementVisitor {
        private final Set<String> found = Sets.newHashSet();

        private InnerTagsFinder() {
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
            if (InnerTagsFinder.argOfParse(node)) {
                this.found.add(node.getStringValue());
            }
        }

        private static boolean argOfParse(PyStringLiteralExpression node) {
            PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)node, PyCallExpression.class);
            return call != null && call.getCallee() != null && "parse".equals(call.getCallee().getName());
        }
    }

    private static class CustomTagCachedData {
        private long myModificationStamp;
        private final Set<String> myBlockTags = Sets.newHashSet();
        private final Map<String, Set<String>> myInnerTags = Maps.newHashMap();

        private CustomTagCachedData() {
        }
    }
}

