/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.editor;

import com.intellij.codeInsight.editorActions.HtmlSelectioner;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.lang.template.DjangoTemplateLanguage;
import com.jetbrains.django.lang.template.psi.DjangoTagName;
import com.jetbrains.django.lang.template.psi.impl.DjangoTagElementImpl;
import com.jetbrains.django.model.TagLibrary;
import com.jetbrains.django.util.DjangoTemplateUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DjangoTemplateTagSelectionHandler
extends HtmlSelectioner {
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            DjangoTemplateTagSelectionHandler.$$$reportNull$$$0(0);
        }
        return e.getContainingFile().getViewProvider().getPsi((Language)DjangoTemplateLanguage.INSTANCE) != null;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor2) {
        if (e == null) {
            DjangoTemplateTagSelectionHandler.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            DjangoTemplateTagSelectionHandler.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            DjangoTemplateTagSelectionHandler.$$$reportNull$$$0(3);
        }
        List result = super.select(e, editorText, cursorOffset, editor2);
        DjangoTagElementImpl tag = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)e, DjangoTagElementImpl.class);
        if (tag == null) {
            tag = DjangoTemplateTagSelectionHandler.findClosestOpenDjangoTagBeforeCursor(e, cursorOffset, null);
        } else {
            result.add(tag.getTextRange());
        }
        if (tag != null) {
            DjangoTagName name = DjangoTemplateUtil.getTagNameElement(tag);
            List<DjangoTagName> open2 = DjangoTemplateUtil.getOpenedTags(tag);
            if (!DjangoTemplateUtil.isEndTag(name)) {
                DjangoTagName tagName = DjangoTemplateUtil.getTagNameElement(tag);
                if (tagName != null) {
                    open2.add(0, tagName);
                }
                tag = (DjangoTagElementImpl)PsiTreeUtil.getNextSiblingOfType((PsiElement)tag, DjangoTagElementImpl.class);
            }
            List<DjangoTagElementImpl> endTags = DjangoTemplateUtil.getEndTags(tag);
            int i = 0;
            for (DjangoTagName openTag : open2) {
                for (int j = i; j < endTags.size(); ++j) {
                    DjangoTagElementImpl closeTag = endTags.get(j);
                    if (!TagLibrary.isCloseTagFor(DjangoTemplateUtil.getTagName(closeTag), openTag.getTagName())) continue;
                    DjangoTemplateTagSelectionHandler.pair(result, (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)openTag, DjangoTagElementImpl.class), closeTag);
                    i = j + 1;
                }
            }
        }
        return result;
    }

    private static DjangoTagElementImpl findClosestOpenDjangoTagBeforeCursor(PsiElement e, int cursorOffset, DjangoTagElementImpl tag) {
        PsiElement[] tags = DjangoTemplateUtil.findElementsBeforeOfType((PsiElement)e.getContainingFile().getViewProvider().getPsi((Language)DjangoTemplateLanguage.INSTANCE), cursorOffset, DjangoTagElementImpl.class);
        if (tags == null) {
            return tag;
        }
        int min = Integer.MAX_VALUE;
        for (PsiElement el : tags) {
            if (DjangoTemplateUtil.isEndTag(DjangoTemplateUtil.getTagNameElement((DjangoTagElementImpl)el)) || cursorOffset - el.getTextOffset() >= min) continue;
            tag = (DjangoTagElementImpl)el;
        }
        return tag;
    }

    private static void pair(List<TextRange> result, DjangoTagElementImpl openTag, DjangoTagElementImpl closeTag) {
        result.add(DjangoTemplateUtil.betweenTags((PsiElement)openTag, (PsiElement)closeTag));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/django/lang/template/editor/DjangoTemplateTagSelectionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

