/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.codeInsight;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.DjangoFunctionParams;
import com.jetbrains.django.codeInsight.DjangoManagerStrategy;
import com.jetbrains.django.codeInsight.DjangoQuerySetMethod;
import com.jetbrains.django.codeInsight.DjangoQuerySetMethodsKt;
import com.jetbrains.django.codeInsight.DjangoQuerySetStrategy;
import com.jetbrains.django.codeInsight.DjangoReturnCustomTypeStrategy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.DjangoModel;
import com.jetbrains.django.model.fieldsAsArguments.fieldReferencesObtainer.DjangoFieldReferencesObtainer;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.extensions.python.PyCallExpressionExtKt;
import com.jetbrains.python.PyCustomType;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyTypeProviderBase;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoTypeProvider
extends PyTypeProviderBase {
    private static final DjangoReturnCustomTypeStrategy @NotNull [] QUERY_SET_AS_MANAGER_STRATEGIES = new DjangoReturnCustomTypeStrategy[]{new DjangoManagerStrategy(), new DjangoQuerySetStrategy()};
    public static final Map<String, String> FIELD_INSTANCE_TYPES = new ImmutableMap.Builder().put((Object)"django.db.models.fields.AutoField", (Object)"int").put((Object)"django.db.models.fields.BigIntegerField", (Object)"int").put((Object)"django.db.models.fields.BooleanField", (Object)"bool").put((Object)"django.db.models.fields.CharField", (Object)"unicode").put((Object)"django.db.models.fields.CommaSeparatedIntegerField", (Object)"unicode").put((Object)"django.db.models.fields.DateField", (Object)"datetime.date").put((Object)"django.db.models.fields.DateTimeField", (Object)"datetime.datetime").put((Object)"django.db.models.fields.DecimalField", (Object)"decimal.Decimal").put((Object)"django.db.models.fields.EmailField", (Object)"unicode").put((Object)"django.db.models.fields.files.FileField", (Object)"django.db.models.fields.files.FieldFile").put((Object)"django.db.models.fields.FilePathField", (Object)"unicode").put((Object)"django.db.models.fields.FloatField", (Object)"float").put((Object)"django.db.models.fields.files.ImageField", (Object)"django.db.models.fields.files.ImageFieldFile").put((Object)"django.db.models.fields.IntegerField", (Object)"int").put((Object)"django.db.models.fields.IPAddressField", (Object)"unicode").put((Object)"django.db.models.fields.NullBooleanField", (Object)"bool or None").put((Object)"django.db.models.fields.PositiveIntegerField", (Object)"int").put((Object)"django.db.models.fields.PositiveSmallIntegerField", (Object)"int").put((Object)"django.db.models.fields.SlugField", (Object)"unicode").put((Object)"django.db.models.fields.SmallIntegerField", (Object)"int").put((Object)"django.db.models.fields.TextField", (Object)"unicode").put((Object)"django.db.models.fields.TimeField", (Object)"datetime.time").put((Object)"django.db.models.fields.URLField", (Object)"unicode").put((Object)"django.db.models.fields.XMLField", (Object)"unicode").build();
    private static final ImmutableSet<String> QUERYSET_RETURNING_METHODS = ImmutableSet.of((Object)"all", (Object)"filter", (Object)"exclude", (Object)"order_by", (Object)"annotate", (Object)"reverse", (Object[])new String[]{"distinct", "select_related", "extra", "defer", "only", "get_queryset", "using"});
    public static final Key<PyClass> MODEL_CLASS_KEY = Key.create((String)"django.ModelTypeKey");
    public static final Key<PyCallExpression> RELATED_KEY = Key.create((String)"django.Related");

    @Override
    @Nullable
    public Ref<PyType> getReferenceType(@NotNull PsiElement referenceTarget, @NotNull TypeEvalContext context, @Nullable PsiElement anchor) {
        if (referenceTarget == null) {
            DjangoTypeProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DjangoTypeProvider.$$$reportNull$$$0(1);
        }
        return PyTypeUtil.notNullToRef(DjangoTypeProvider.getReferenceTypeStatic(referenceTarget, context, anchor));
    }

    @Nullable
    public static PyType getReferenceTypeStatic(@NotNull PsiElement referenceTarget, TypeEvalContext context, @Nullable PsiElement anchor) {
        if (referenceTarget == null) {
            DjangoTypeProvider.$$$reportNull$$$0(2);
        }
        if (anchor != null && DjangoModelApi.notDjangoModule(anchor)) {
            return null;
        }
        if (referenceTarget instanceof PyTargetExpression) {
            String name;
            PyCallExpression fieldInitCall;
            PyClass cls;
            if (!DjangoFacet.isInProject(referenceTarget)) {
                return null;
            }
            PyTargetExpression target = (PyTargetExpression)referenceTarget;
            if (!(ScopeUtil.getScopeOwner(target) instanceof PyClass)) {
                return null;
            }
            PyExpression value2 = target.findAssignedValue();
            if (value2 instanceof PyCallExpression && (cls = PyCallExpressionHelper.resolveCalleeClass(fieldInitCall = (PyCallExpression)value2)) != null && (name = cls.getQualifiedName()) != null) {
                if (NameResolverTools.isNameShortCut(cls, DjangoFQNamesProvider.RELATION_FOREIGN_KEY, DjangoFQNamesProvider.RELATION_ONE_TO_ONE_KEY)) {
                    return DjangoTypeProvider.getForeignKeyType(fieldInitCall);
                }
                if (NameResolverTools.isNameShortCut(cls, DjangoFQNamesProvider.RELATION_MANY_TO_MANY_KEY)) {
                    return DjangoModel.createMultiRelationType(DjangoTypeProvider.getForeignKeyType(fieldInitCall), fieldInitCall);
                }
                PyType type = DjangoTypeProvider.getToPythonType(cls, context);
                if (type != null) {
                    return type;
                }
                for (PyClass ancestor : cls.getAncestorClasses(context)) {
                    type = DjangoTypeProvider.getToPythonType(ancestor, context);
                    if (type == null) continue;
                    return type;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Ref<PyType> getParameterType(@NotNull PyNamedParameter param, @NotNull PyFunction func, @NotNull TypeEvalContext context) {
        if (param == null) {
            DjangoTypeProvider.$$$reportNull$$$0(3);
        }
        if (func == null) {
            DjangoTypeProvider.$$$reportNull$$$0(4);
        }
        if (context == null) {
            DjangoTypeProvider.$$$reportNull$$$0(5);
        }
        if (DjangoModelApi.notDjangoModule(param)) {
            return null;
        }
        PsiFile file2 = func.getContainingFile();
        if (file2 instanceof PyFile && ("views.py".equals(file2.getName()) || DjangoTypeProvider.underViewsModule((PsiFileSystemItem)file2)) && func.getContainingClass() == null && Objects.equals(param.getName(), "request") && func.getParameterList().getParameters().length > 0 && func.getParameterList().getParameters()[0] == param) {
            return Ref.create((Object)PyUnionType.createWeakType(PyTypeParser.getTypeByName(param, "django.core.handlers.wsgi.WSGIRequest", context)));
        }
        return null;
    }

    private static boolean underViewsModule(PsiFileSystemItem f) {
        while (f != null) {
            if ("views".equals(f.getName())) {
                return true;
            }
            f = f.getParent();
        }
        return false;
    }

    @Nullable
    private static PyType getToPythonType(PyClass cls, TypeEvalContext context) {
        PyType typeByField = (PyType)CachedValuesManager.getCachedValue((PsiElement)cls, () -> CachedValueProvider.Result.create((Object)DjangoTypeProvider.getTypeByField(cls), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (typeByField != null) {
            return typeByField;
        }
        if (DjangoModel.isDjangoFieldDescendant(cls, context)) {
            return PyUnionType.union(DjangoTypeProvider.getToPythonFunctionReturnType(cls, context), new PyClassTypeImpl(cls, false));
        }
        return null;
    }

    private static PyType getTypeByField(@NotNull PyClass fieldClass) {
        String name;
        if (fieldClass == null) {
            DjangoTypeProvider.$$$reportNull$$$0(6);
        }
        if ((name = fieldClass.getQualifiedName()) == null) {
            return null;
        }
        String s = FIELD_INSTANCE_TYPES.get(name);
        if (s != null) {
            return PyTypeParser.getTypeByName((PsiElement)fieldClass, s);
        }
        return null;
    }

    @Nullable
    private static PyType getToPythonFunctionReturnType(PyClass clazz, TypeEvalContext context) {
        PyFunction toPython = clazz.findMethodByName("to_python", false, null);
        if (toPython != null) {
            return toPython.getReturnStatementType(context);
        }
        return null;
    }

    @Nullable
    private static PyClassType getForeignKeyType(PyCallExpression fieldCall) {
        PyExpression foreignKeyClass = fieldCall.getArgument(DjangoFunctionParams.FOREIGN_KEY_TO, PyExpression.class);
        if (foreignKeyClass instanceof PyReferenceExpression) {
            PsiElement foreignKeyResult = ((PyReferenceExpression)foreignKeyClass).getReference().resolve();
            if (foreignKeyResult instanceof PyClass) {
                return new PyClassTypeImpl((PyClass)foreignKeyResult, false);
            }
        } else if (foreignKeyClass instanceof PyStringLiteralExpression) {
            String fkModelName = ((PyStringLiteralExpression)foreignKeyClass).getStringValue();
            if (fkModelName.equals("self")) {
                PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)fieldCall, PyClass.class);
                return containingClass != null ? new PyClassTypeImpl(containingClass, false) : null;
            }
            String shortName = fkModelName;
            int pos = fkModelName.lastIndexOf(46);
            if (pos < 0) {
                fkModelName = DjangoModel.getAppModelName(fieldCall.getContainingFile(), fkModelName);
            } else {
                shortName = fkModelName.substring(pos + 1);
            }
            Collection<PyClass> classes = PyClassNameIndex.find(shortName, fieldCall.getProject(), true);
            for (PyClass aClass : classes) {
                if (!DjangoModel.getAppModelName(aClass.getContainingFile(), aClass.getName()).equals(fkModelName)) continue;
                return new PyClassTypeImpl(aClass, false);
            }
            for (PsiReference classReference : foreignKeyClass.getReferences()) {
                PyClass foreignClass = PyUtil.as(classReference.resolve(), PyClass.class);
                if (foreignClass == null) continue;
                return new PyClassTypeImpl(foreignClass, false);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public final Ref<PyType> getCallType(@NotNull PyFunction function, @NotNull PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        PyClass containingClass;
        if (function == null) {
            DjangoTypeProvider.$$$reportNull$$$0(7);
        }
        if (callSite == null) {
            DjangoTypeProvider.$$$reportNull$$$0(8);
        }
        if (context == null) {
            DjangoTypeProvider.$$$reportNull$$$0(9);
        }
        if (!(callSite instanceof PyCallExpression) || DjangoModelApi.notDjangoModule((PsiElement)callSite)) {
            return null;
        }
        PyCallExpression callExpr = (PyCallExpression)callSite;
        Optional<Ref> optionalResult = Arrays.stream(QUERY_SET_AS_MANAGER_STRATEGIES).map(strategy -> DjangoTypeProvider.getTypeFromStrategy(context, callExpr, strategy)).filter(Objects::nonNull).findFirst().map(Ref::create);
        if (optionalResult.isPresent()) {
            return optionalResult.get();
        }
        String functionName = function.getName();
        DjangoQuerySetMethod querySetMethod = DjangoQuerySetMethodsKt.findQuerySetMethod(functionName);
        if ((QUERYSET_RETURNING_METHODS.contains((Object)functionName) || querySetMethod != null) && (containingClass = function.getContainingClass()) != null && ("django.db.models.manager.Manager".equals(containingClass.getQualifiedName()) || NameResolverTools.isName(containingClass, DjangoFQNamesProvider.MANAGER_CLASS) || "django.db.models.query.QuerySet".equals(containingClass.getQualifiedName()))) {
            PyExpression callee = callExpr.getCallee();
            if (!(callee instanceof PyQualifiedExpression)) {
                return null;
            }
            PyExpression qualifier = ((PyQualifiedExpression)callee).getQualifier();
            if (qualifier == null) {
                return null;
            }
            PyType type = context.getType(qualifier);
            PyClass modelClass = null;
            if (type instanceof PyClassTypeImpl) {
                modelClass = (PyClass)((PyClassTypeImpl)type).getUserData(MODEL_CLASS_KEY);
            }
            if (modelClass == null && callee instanceof PyReferenceExpression) {
                modelClass = DjangoFieldReferencesObtainer.getModel((PyReferenceExpression)callee, context);
            }
            if (modelClass != null) {
                PyClassTypeImpl modelClassType = new PyClassTypeImpl(modelClass, false);
                if (querySetMethod != null) {
                    return Ref.create((Object)querySetMethod.getReturns().getReturnTypeByModelType(modelClassType));
                }
                List<PyType> elementTypes = Collections.singletonList(modelClassType);
                PyCollectionTypeImpl result = PyCollectionTypeImpl.createTypeByQName((PsiElement)modelClass, "django.db.models.query.QuerySet", false, elementTypes);
                if (result != null) {
                    return Ref.create((Object)result.withUserData(MODEL_CLASS_KEY, modelClass));
                }
            }
            if (QUERYSET_RETURNING_METHODS.contains((Object)functionName)) {
                return Ref.create((Object)PyClassTypeImpl.createTypeByQName(function, "django.db.models.query.QuerySet", false));
            }
        }
        if ("get_object_or_404".equals(functionName)) {
            return Optional.ofNullable(callExpr.getArgument(0, PyReferenceExpression.class)).map(modelClassRef -> modelClassRef.getReference().resolve()).map(element -> PyUtil.as(element, PyClass.class)).map(pyClass -> new PyClassTypeImpl((PyClass)pyClass, false)).map(Ref::create).orElse(null);
        }
        return null;
    }

    @Nullable
    private static PyClassLikeType getTypeFromStrategy(@NotNull TypeEvalContext context, @NotNull PyCallExpression callExpression, @NotNull DjangoReturnCustomTypeStrategy strategy) {
        PyClassLikeType[] result;
        PyReferenceExpression callee;
        if (context == null) {
            DjangoTypeProvider.$$$reportNull$$$0(10);
        }
        if (callExpression == null) {
            DjangoTypeProvider.$$$reportNull$$$0(11);
        }
        if (strategy == null) {
            DjangoTypeProvider.$$$reportNull$$$0(12);
        }
        if ((callee = PyUtil.as(callExpression.getCallee(), PyReferenceExpression.class)) == null) {
            return null;
        }
        PyExpression qualifier = callee.getQualifier();
        if (qualifier == null) {
            return null;
        }
        PyClassType classType = PyUtil.as(context.getType(qualifier), PyClassType.class);
        if (classType == null) {
            return null;
        }
        if (PyCallExpressionExtKt.isCalleeName(callExpression, strategy.getFunction()) && (result = strategy.getTypes(callExpression, classType.getPyClass(), context)) != null) {
            return new PyCustomType(null, strategy.getFilter(), strategy.isInstance(), false, result);
        }
        return null;
    }

    @Override
    @Nullable
    public final PyType getReferenceExpressionType(@NotNull PyReferenceExpression referenceExpression, @NotNull TypeEvalContext context) {
        PyClass model;
        if (referenceExpression == null) {
            DjangoTypeProvider.$$$reportNull$$$0(13);
        }
        if (context == null) {
            DjangoTypeProvider.$$$reportNull$$$0(14);
        }
        if (DjangoModelApi.notDjangoModule((PsiElement)referenceExpression)) {
            return null;
        }
        String name = referenceExpression.getName();
        if (name == null) {
            return null;
        }
        if ("model".equals(referenceExpression.getName()) && (model = DjangoFieldReferencesObtainer.getModel(referenceExpression, context)) != null) {
            return new PyClassTypeImpl(model, true);
        }
        for (DjangoReturnCustomTypeStrategy strategy : QUERY_SET_AS_MANAGER_STRATEGIES) {
            PyCallExpression callExpression;
            if (!NameResolverTools.isContainsName(name, (FQNamesProvider)strategy.getFunction()) || !NameResolverTools.isName(referenceExpression, strategy.getFunction()) || (callExpression = PyUtil.as(referenceExpression.getParent(), PyCallExpression.class)) == null) continue;
            return new PyCustomType(null, null, false, false, DjangoTypeProvider.getTypeFromStrategy(context, callExpression, strategy));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceTarget";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/django/codeInsight/DjangoTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceTypeStatic";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeByField";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallType";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeFromStrategy";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceExpressionType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

