/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cython.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cython.parser.CythonTokenTypes;
import com.jetbrains.cython.psi.CythonNameDecl;
import com.jetbrains.cython.psi.CythonNamedElement;
import com.jetbrains.cython.psi.CythonNamedParameter;
import com.jetbrains.cython.psi.CythonPsiUtil;
import com.jetbrains.cython.psi.CythonRecursiveElementVisitor;
import com.jetbrains.cython.psi.CythonScopeOwner;
import com.jetbrains.cython.psi.CythonVariable;
import com.jetbrains.cython.psi.elementTypes.CythonElementTypes;
import com.jetbrains.cython.types.CythonFunctionType;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.impl.PyFunctionImpl;
import com.jetbrains.python.psi.impl.PyParameterListImpl;
import com.jetbrains.python.psi.stubs.PyFunctionStub;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CythonFunction
extends PyFunctionImpl
implements CythonNamedElement,
CythonScopeOwner {
    private static final TokenSet CDEF_TOKENS = TokenSet.create((IElementType[])new IElementType[]{CythonTokenTypes.CDEF_KEYWORD, CythonTokenTypes.CPDEF_KEYWORD});

    public CythonFunction(ASTNode astNode) {
        super(astNode);
    }

    public CythonFunction(PyFunctionStub stub) {
        super(stub, (IStubElementType)CythonElementTypes.FUNCTION_DECLARATION);
    }

    @Override
    @NotNull
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            CythonFunction.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = CythonPsiUtil.setName(this, name);
        if (psiElement == null) {
            CythonFunction.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        return CythonPsiUtil.getNameNode(this);
    }

    @Override
    @NotNull
    public PyParameterList getParameterList() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            PyParameterList pyParameterList = super.getParameterList();
            if (pyParameterList == null) {
                CythonFunction.$$$reportNull$$$0(2);
            }
            return pyParameterList;
        }
        PyParameterList parameterList = this.getNameDecl().getParameterList();
        if (parameterList == null) {
            return new PyParameterListImpl((ASTNode)new DummyParameterList((IElementType)PyElementTypes.PARAMETER_LIST, ""));
        }
        PyParameterList pyParameterList = parameterList;
        if (pyParameterList == null) {
            CythonFunction.$$$reportNull$$$0(3);
        }
        return pyParameterList;
    }

    @Override
    @NotNull
    public CythonNameDecl getNameDecl() {
        CythonNameDecl decl = (CythonNameDecl)this.findChildByClass(CythonNameDecl.class);
        if (decl == null) assert (false) : "No name declaration in Cython function";
        CythonNameDecl cythonNameDecl = decl;
        if (cythonNameDecl == null) {
            CythonFunction.$$$reportNull$$$0(4);
        }
        return cythonNameDecl;
    }

    @Override
    public boolean isForwardDeclaration() {
        return this.getStatementList().getStatements().length == 0;
    }

    @Override
    public List<? extends CythonNamedElement> getCythonNamedElements() {
        final ArrayList<CythonNamedParameter> result = new ArrayList<CythonNamedParameter>();
        this.getStatementList().accept(new CythonRecursiveElementVisitor(){

            @Override
            public void visitCythonVariable(CythonVariable node) {
                result.add(node);
            }
        });
        for (PyParameter param : this.getParameterList().getParameters()) {
            if (!(param instanceof CythonNamedParameter)) continue;
            result.add((CythonNamedParameter)param);
        }
        return result;
    }

    @Override
    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            CythonFunction.$$$reportNull$$$0(5);
        }
        if (key == null) {
            CythonFunction.$$$reportNull$$$0(6);
        }
        return new CythonFunctionType(this);
    }

    public boolean isCythonLevel() {
        return this.findChildByType(CDEF_TOKENS) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cython/psi/CythonFunction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cython/psi/CythonFunction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameDecl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DummyParameterList
    extends LazyParseableElement {
        DummyParameterList(@NotNull IElementType type, CharSequence text2) {
            if (type == null) {
                DummyParameterList.$$$reportNull$$$0(0);
            }
            super(type, text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cython/psi/CythonFunction$DummyParameterList", "<init>"));
        }
    }
}

