/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cython.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cython.parser.CythonDeclParsing;
import com.jetbrains.cython.parser.CythonParsingContext;
import com.jetbrains.cython.parser.CythonTokenTypes;
import com.jetbrains.cython.psi.elementTypes.CythonElementTypes;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.parsing.FunctionParsing;
import org.jetbrains.annotations.NotNull;

public class CythonFunctionParsing
extends FunctionParsing {
    public CythonFunctionParsing(CythonParsingContext context) {
        super(context);
    }

    @Override
    public CythonParsingContext getParsingContext() {
        return (CythonParsingContext)this.myContext;
    }

    @Override
    protected IElementType getFunctionType() {
        return CythonElementTypes.FUNCTION_DECLARATION;
    }

    @Override
    protected IElementType getReferenceType() {
        return CythonElementTypes.REFERENCE_EXPRESSION;
    }

    @Override
    protected void parseFunctionInnards(@NotNull PsiBuilder.Marker functionMarker, boolean async) {
        if (functionMarker == null) {
            CythonFunctionParsing.$$$reportNull$$$0(0);
        }
        this.myBuilder.advanceLexer();
        PsiBuilder.Marker mark = this.myBuilder.mark();
        this.parseIdentifierOrSkip(PyTokenTypes.LPAR);
        this.parseParameterList();
        this.parseReturnTypeAnnotation();
        mark.done((IElementType)CythonElementTypes.NAME_DECL);
        this.checkMatches(PyTokenTypes.COLON, PyPsiBundle.message("PARSE.expected.colon", new Object[0]));
        CythonParsingContext context = this.getParsingContext();
        context.pushScope(context.getScope().withFunction(async));
        this.getStatementParser().parseSuite(functionMarker, this.getFunctionType());
        context.popScope();
    }

    @Override
    protected boolean parseParameter(IElementType endToken, boolean isLambda) {
        if (this.parseSingleStarParameter(endToken)) {
            return true;
        }
        if (isLambda || this.atAnyOfTokens(PyTokenTypes.MULT, PyTokenTypes.EXP)) {
            return super.parseParameter(endToken, isLambda);
        }
        if (this.atToken(endToken)) {
            return false;
        }
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (this.atToken(PyTokenTypes.DOT)) {
            this.parseEllipsis();
            marker.done((IElementType)CythonElementTypes.ELLIPSIS_DECL);
        } else {
            CythonDeclParsing declParser = this.getParsingContext().getDeclParser();
            declParser.parseBaseTypeDecl(true);
            declParser.parseNameDecl(false, false, false);
            if (this.atAnyOfTokens(PyTokenTypes.NOT_KEYWORD, PyTokenTypes.OR_KEYWORD)) {
                this.nextToken();
                if (this.atToken(PyTokenTypes.NONE_KEYWORD) || this.atToken(PyTokenTypes.IDENTIFIER, "None")) {
                    this.nextToken();
                } else {
                    this.myBuilder.error(PythonProBundle.message("cython.expected.symbol", "'None'"));
                }
            }
            this.parseParameterAnnotation();
            if (this.atToken(PyTokenTypes.EQ)) {
                this.nextToken();
                if (this.atAnyOfTokens(CythonTokenTypes.QUESTION, PyTokenTypes.MULT)) {
                    this.nextToken();
                } else {
                    this.getExpressionParser().parseSingleExpression(false);
                }
            }
            marker.done((IElementType)CythonElementTypes.NAMED_PARAMETER);
        }
        return true;
    }

    @Override
    public void parseParameterAnnotation() {
        super.parseParameterAnnotation(false);
    }

    @Override
    public void parseReturnTypeAnnotation() {
        super.parseReturnTypeAnnotation(false);
    }

    @Override
    protected void parseDeclarationAfterDecorator(PsiBuilder.Marker endMarker, boolean async) {
        if (this.atAnyOfTokens(CythonTokenTypes.CDEF_KEYWORD, CythonTokenTypes.CPDEF_KEYWORD)) {
            this.nextToken();
            this.getParsingContext().getStatementParser().parseCdefStatement(endMarker);
        } else if (this.atToken(PyTokenTypes.DEF_KEYWORD)) {
            this.parseFunctionInnards(endMarker, async);
        } else if (this.atToken(PyTokenTypes.CLASS_KEYWORD)) {
            this.getStatementParser().parseClassDeclaration(endMarker);
        } else {
            PsiBuilder.Marker nameDecl = this.myBuilder.mark();
            this.myBuilder.error(PyPsiBundle.message("PARSE.expected.@.or.def", new Object[0]));
            PsiBuilder.Marker parameterList = this.myBuilder.mark();
            parameterList.done(PyElementTypes.PARAMETER_LIST);
            nameDecl.done((IElementType)CythonElementTypes.NAME_DECL);
            this.myBuilder.mark().done((IElementType)PyElementTypes.STATEMENT_LIST);
            endMarker.done(this.getFunctionType());
        }
    }

    @Override
    protected void parseParameterSubList() {
        this.assertCurrentToken(PyTokenTypes.LPAR);
        CythonDeclParsing declParser = this.getParsingContext().getDeclParser();
        PsiBuilder.Marker marker = this.myBuilder.mark();
        declParser.parseBaseTypeDecl(true);
        declParser.parseNameDecl(false, false, false);
        marker.done((IElementType)CythonElementTypes.NAMED_PARAMETER);
    }

    private boolean parseSingleStarParameter(IElementType endToken) {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (this.atToken(PyTokenTypes.MULT)) {
            this.nextToken();
            if (this.atAnyOfTokens(endToken, PyTokenTypes.COMMA)) {
                marker.drop();
                return true;
            }
        }
        marker.rollbackTo();
        return false;
    }

    private void parseEllipsis() {
        String msg = "'...' expected";
        if (this.checkMatches(PyTokenTypes.DOT, "'...' expected") && this.checkMatches(PyTokenTypes.DOT, "'...' expected")) {
            this.checkMatches(PyTokenTypes.DOT, "'...' expected");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionMarker", "com/jetbrains/cython/parser/CythonFunctionParsing", "parseFunctionInnards"));
    }
}

