/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurableBase;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.facet.AppEngineFacetConfiguration;
import com.jetbrains.appengine.facet.AppEngineFacetType;
import com.jetbrains.appengine.facet.AppEngineWizardSettingsHolder;
import com.jetbrains.appengine.facet.CreateProjectSettingsEditor;
import com.jetbrains.appengine.run.AppEngineServerRunConfigurationType;
import com.jetbrains.appengine.ui.AppEngineBundle;
import com.jetbrains.appengine.util.AppEngineProjectCreator;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.django.util.ModuleUtil;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.run.PyRunConfigurationFactory;
import com.jetbrains.python.run.PyRunConfigurationFactoryEx;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class AppEngineFacetSupportProvider
extends FacetBasedFrameworkSupportProvider<AppEngineFacet> {
    private AppEngineWizardSettingsHolder mySettingsHolder;

    public AppEngineFacetSupportProvider() {
        super((FacetType)AppEngineFacetType.getInstance());
    }

    protected void setupConfiguration(AppEngineFacet facet, ModifiableRootModel model, FrameworkVersion frameworkVersion) {
        AppEngineFacetConfiguration config = (AppEngineFacetConfiguration)facet.getConfiguration();
        config.setProjectRoot(ModuleUtil.getFirstContentRoot(model).getPath());
        config.setSdkFolder(this.mySettingsHolder.getAppEngineSdkFolder());
    }

    public boolean isEnabledForModuleType(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            AppEngineFacetSupportProvider.$$$reportNull$$$0(0);
        }
        return moduleType.equals((Object)PythonModuleTypeBase.getInstance());
    }

    @NotNull
    public FrameworkSupportConfigurableBase createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            AppEngineFacetSupportProvider.$$$reportNull$$$0(1);
        }
        return new CreateProjectSettingsEditor(this, model);
    }

    protected void onFacetCreated(AppEngineFacet facet, ModifiableRootModel rootModel, FrameworkVersion version) {
        super.onFacetCreated((Facet)facet, rootModel, version);
        Sdk sdk = rootModel.getSdk();
        if (sdk != null && sdk.getSdkType() instanceof PythonSdkType) {
            VirtualFile root = ModuleUtil.getFirstContentRoot(rootModel);
            try {
                AppEngineProjectCreator.createProject(root, this.mySettingsHolder);
                String templatesFolder = this.mySettingsHolder.getTemplatesFolder();
                if (templatesFolder != null) {
                    VfsUtil.createDirectoryIfMissing((String)(root.getPath() + File.separator + templatesFolder));
                }
            }
            catch (IOException e) {
                Messages.showInfoMessage((String)AppEngineBundle.message("facet-wizard-error.create-templates", new Object[0]), (String)AppEngineBundle.message("project-create-error", new Object[0]));
            }
            Module module = rootModel.getModule();
            StartupManager.getInstance((Project)rootModel.getProject()).runWhenProjectIsInitialized(() -> {
                AppEngineUtil.initAppEngineModuleLibrary(module, null, this.mySettingsHolder.getAppEngineSdkFolder(), root.getPath());
                ((PyRunConfigurationFactoryEx)PyRunConfigurationFactory.getInstance()).createRunConfiguration(module, AppEngineServerRunConfigurationType.getInstance().getConfigurationFactory());
            });
        } else {
            Messages.showInfoMessage((String)AppEngineBundle.message("facet-wizard-error.no-python-sdk", new Object[0]), (String)AppEngineBundle.message("project-create-error", new Object[0]));
        }
    }

    void setSettingsHolder(AppEngineWizardSettingsHolder holder) {
        this.mySettingsHolder = holder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/appengine/facet/AppEngineFacetSupportProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForModuleType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createConfigurable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

