/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.appengine.lang.gql.GqlLanguage;
import com.jetbrains.appengine.lang.gql.psi.GqlElementTypes;
import com.jetbrains.appengine.lang.gql.psi.GqlFrom;
import com.jetbrains.appengine.lang.gql.psi.GqlOrder;
import com.jetbrains.appengine.lang.gql.psi.GqlProperty;
import com.jetbrains.appengine.lang.gql.psi.GqlQuery;
import com.jetbrains.appengine.lang.gql.psi.GqlSelect;
import com.jetbrains.appengine.lang.gql.psi.GqlWhere;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlAscDescImpl;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GqlKeywordCompletionContributor
extends CompletionContributor {
    public GqlKeywordCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withLanguage((Language)GqlLanguage.GQL), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (String keyword : GqlKeywordCompletionContributor.getKeywords(parameters.getPosition())) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)keyword));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/appengine/completion/GqlKeywordCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static Set<String> getKeywords(PsiElement elem) {
        HashSet<String> keywords = new HashSet<String>();
        PsiElement prevElement = null;
        for (int offset = elem.getTextOffset() - 1; offset > 0 && (prevElement == null || prevElement instanceof PsiWhiteSpace); --offset) {
            prevElement = elem.getContainingFile().findElementAt(offset);
        }
        GqlQuery query = (GqlQuery)PsiTreeUtil.getParentOfType((PsiElement)elem, GqlQuery.class);
        if (query == null) {
            return keywords;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)elem.getProject()).getInjectionHost((PsiElement)query);
        boolean isEntityGql = host instanceof PyStringLiteralExpression && AppEngineUtil.isEntityGql((PyStringLiteralExpression)host);
        Set<IElementType> classes = GqlKeywordCompletionContributor.getClausesBeforeElement(query, elem);
        if (GqlKeywordCompletionContributor.under(elem, GqlWhere.class)) {
            if (GqlKeywordCompletionContributor.under(elem, GqlProperty.class)) {
                keywords.add("ANCESTOR IS");
                return keywords;
            }
        } else if (GqlKeywordCompletionContributor.under(prevElement, GqlOrder.class) && !GqlKeywordCompletionContributor.under(prevElement, GqlAscDescImpl.class)) {
            keywords.add("ASC");
            keywords.add("DESC");
        }
        if (!GqlKeywordCompletionContributor.under(elem, GqlSelect.class) && !GqlKeywordCompletionContributor.under(elem, GqlFrom.class)) {
            if (!isEntityGql && !classes.contains(GqlElementTypes.SELECT)) {
                keywords.add("SELECT");
                return keywords;
            }
            if (!classes.contains(GqlElementTypes.FROM)) {
                keywords.add("FROM");
                return keywords;
            }
            if (!classes.contains(GqlElementTypes.WHERE)) {
                keywords.add("WHERE");
            } else if (!classes.contains(GqlElementTypes.ORDER)) {
                keywords.add("AND");
            }
            if (!classes.contains(GqlElementTypes.ORDER)) {
                keywords.add("ORDER BY");
            }
            if (!classes.contains(GqlElementTypes.LIMIT)) {
                keywords.add("LIMIT");
            }
            if (!classes.contains(GqlElementTypes.OFFSET)) {
                keywords.add("OFFSET");
            }
        }
        return keywords;
    }

    private static Set<IElementType> getClausesBeforeElement(GqlQuery q, PsiElement anchor) {
        HashSet<IElementType> result = new HashSet<IElementType>();
        for (PsiElement elem : q.getChildren()) {
            if (PsiTreeUtil.isAncestor((PsiElement)elem, (PsiElement)anchor, (boolean)false)) break;
            ASTNode node = elem.getNode();
            if (node == null) continue;
            result.add(node.getElementType());
        }
        if (result.contains(GqlElementTypes.OFFSET)) {
            result.add(GqlElementTypes.LIMIT);
        }
        if (result.contains(GqlElementTypes.LIMIT)) {
            result.add(GqlElementTypes.ORDER);
        }
        if (result.contains(GqlElementTypes.ORDER)) {
            result.add(GqlElementTypes.WHERE);
        }
        return result;
    }

    private static <T extends PsiElement> boolean under(PsiElement elem, Class<T> parentClass) {
        return PsiTreeUtil.getParentOfType((PsiElement)elem, parentClass) != null;
    }
}

