/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.completion;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.icons.AllIcons;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.util.StringUtils;
import com.jetbrains.appengine.util.YamlUtil;
import icons.PythonUltimateIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLCompoundValue;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLSequenceItem;

public class AppYamlKeyCompletionContributor
extends CompletionContributor {
    private static final String KEY_HANDLERS = "handlers";
    private static final String KEY_APPLICATION = "application";
    private static final String KEY_VERSION = "version";
    public static final String KEY_RUNTIME = "runtime";
    private static final String KEY_API_VERSION = "api_version";
    private static final String KEY_THREADSAFE = "threadsafe";
    private static final ImmutableSet<String> TOP_LEVEL_KEYS = ImmutableSet.of((Object)"application", (Object)"version", (Object)"runtime", (Object)"api_version", (Object)"default_expiration", (Object)"handlers", (Object[])new String[]{"skip_files", "inbound_services", "threadsafe", "builtins", "includes", "inbound_services", "admin_console", "error_handlers", "skip_files"});
    private static final String KEY_URL = "url";
    public static final String TYPE_SCRIPT = "script";
    private static final String TYPE_STATIC_FILES = "static_files";
    private static final String TYPE_STATIC_DIR = "static_dir";
    private static final String KEY_MIME_TYPE = "mime_type";
    private static final String KEY_EXPIRATION = "expiration";
    private static final String KEY_UPLOAD = "upload";
    private static final String KEY_AUTH_FAIL_ACTION = "auth_fail_action";
    private static final String KEY_SECURE = "secure";
    private static final String KEY_LOGIN = "login";
    private static final ImmutableSet<String> REQUIRED_KEYS = ImmutableSet.of((Object)"application", (Object)"version", (Object)"runtime", (Object)"api_version", (Object)"handlers", (Object)"url", (Object[])new String[]{"script", "static_dir", "static_files"});
    private static final ImmutableSet<String> HANDLER_TYPE_KEYS = ImmutableSet.of((Object)"script", (Object)"static_files", (Object)"static_dir");
    private static final ImmutableSet<String> STATIC_DIR_KEYS = ImmutableSet.of((Object)"mime_type", (Object)"expiration");
    private static final ImmutableSet<String> STATIC_FILES_KEYS = ImmutableSet.of((Object)"mime_type", (Object)"expiration", (Object)"upload");
    private static final ImmutableMap<String, List<String>> VALUE_COMPLETION_VARIANTS = new ImmutableMap.Builder().put((Object)"login", (Object)ImmutableList.of((Object)"required", (Object)"admin")).put((Object)"auth_fail_action", (Object)ImmutableList.of((Object)"unauthorized", (Object)"redirect")).put((Object)"secure", (Object)ImmutableList.of((Object)"optional", (Object)"never", (Object)"always")).put((Object)"threadsafe", (Object)ImmutableList.of((Object)"true", (Object)"false")).build();

    public AppYamlKeyCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(YAMLCompoundValue.class), this.createProvider());
    }

    private CompletionProvider<CompletionParameters> createProvider() {
        return new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters completionParameters, @NotNull ProcessingContext processingContext, @NotNull CompletionResultSet result) {
                PsiElement elem;
                if (completionParameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (processingContext == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!AppEngineFacet.isPresent(elem = completionParameters.getPosition())) {
                    return;
                }
                PsiElement parent = elem.getParent();
                if (parent instanceof YAMLKeyValue) {
                    parent = parent.getParent();
                }
                Set<String> existingKeys = YamlUtil.getChildKeys(parent);
                if (parent instanceof YAMLDocument) {
                    AppYamlKeyCompletionContributor.addKeys((Iterable)TOP_LEVEL_KEYS, existingKeys, result);
                }
                if (AppYamlKeyCompletionContributor.isHandlersSequence(parent.getParent()) && AppYamlKeyCompletionContributor.isKeyCompletion(elem.getParent())) {
                    ArrayList<String> keys = new ArrayList<String>();
                    keys.add(AppYamlKeyCompletionContributor.KEY_URL);
                    String type = StringUtils.intersection(existingKeys, (Set<String>)HANDLER_TYPE_KEYS);
                    if (type != null) {
                        if (AppYamlKeyCompletionContributor.TYPE_STATIC_DIR.equals(type)) {
                            keys.addAll((Collection<String>)STATIC_DIR_KEYS);
                        }
                        if (AppYamlKeyCompletionContributor.TYPE_STATIC_FILES.equals(type)) {
                            keys.addAll((Collection<String>)STATIC_FILES_KEYS);
                        }
                    } else {
                        keys.addAll((Collection<String>)HANDLER_TYPE_KEYS);
                    }
                    keys.add(AppYamlKeyCompletionContributor.KEY_SECURE);
                    keys.add(AppYamlKeyCompletionContributor.KEY_LOGIN);
                    keys.add(AppYamlKeyCompletionContributor.KEY_AUTH_FAIL_ACTION);
                    AppYamlKeyCompletionContributor.addKeys(keys, existingKeys, result);
                }
                if (elem.getParent() instanceof YAMLKeyValue && elem == ((YAMLKeyValue)elem.getParent()).getValue()) {
                    String keyText = ((YAMLKeyValue)elem.getParent()).getKeyText();
                    List values = (List)VALUE_COMPLETION_VARIANTS.get((Object)keyText);
                    if (values != null) {
                        for (String value2 : values) {
                            result.addElement((LookupElement)LookupElementBuilder.create((String)value2));
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "completionParameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "processingContext";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/appengine/completion/AppYamlKeyCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isKeyCompletion(PsiElement elem) {
        String text2 = elem.getText();
        for (int currentPos = text2.indexOf("IntellijIdeaRulezzz"); currentPos >= 0; --currentPos) {
            char c = text2.charAt(currentPos);
            if (c == ':') {
                return false;
            }
            if (c != '\r' && c != '\n') continue;
            return true;
        }
        return true;
    }

    private static void addKeys(Iterable<String> keys, Set<String> existingKeys, CompletionResultSet result) {
        for (String key : keys) {
            if (existingKeys.contains(key)) continue;
            LookupElementBuilder item = LookupElementBuilder.create((String)key).withIcon(REQUIRED_KEYS.contains((Object)key) ? PythonUltimateIcons.Appengine.Required : AllIcons.Nodes.EmptyNode);
            result.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)item, (TailType)new CharTailType(':')));
        }
    }

    private static boolean isHandlersSequence(PsiElement elem) {
        if (elem instanceof YAMLSequenceItem) {
            YAMLKeyValue parent = YamlUtil.getParent((YAMLSequenceItem)elem);
            return parent != null && KEY_HANDLERS.equals(parent.getKeyText());
        }
        return false;
    }
}

