/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.gdpr.ConsentConfigurable;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerKt;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.FUStateUsagesLogger;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class RecordStateStatisticsEventLogAction
extends DumbAwareAction {
    private final boolean myShowNotification;

    public RecordStateStatisticsEventLogAction() {
        this(true);
    }

    public RecordStateStatisticsEventLogAction(boolean showNotification) {
        super(ActionsBundle.message((String)"action.RecordStateCollectors.text", (Object[])new Object[0]), ActionsBundle.message((String)"action.RecordStateCollectors.description", (Object[])new Object[0]), AllIcons.Ide.IncomingChangesOn);
        this.myShowNotification = showNotification;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            RecordStateStatisticsEventLogAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        if (!RecordStateStatisticsEventLogAction.checkLogRecordingEnabled(project, "FUS")) {
            return;
        }
        String message = StatisticsBundle.message((String)"stats.collecting.feature.usages.in.event.log", (Object[])new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, message, false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                FeatureUsageLogger.INSTANCE.rollOver();
                EventLogFile logFile = FeatureUsageLogger.INSTANCE.getConfig().getActiveLogFile();
                VirtualFile logVFile = logFile != null ? LocalFileSystem.getInstance().findFileByIoFile(logFile.getFile()) : null;
                Holder.myStatesLogger.logApplicationStates();
                Holder.myStatesLogger.logProjectStates(project, indicator);
                if (!RecordStateStatisticsEventLogAction.this.myShowNotification) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    Notification notification = new Notification("FeatureUsageStatistics", StatisticsBundle.message((String)"stats.feature.usage.statistics", (Object[])new Object[0]), "Finished collecting and recording events", NotificationType.INFORMATION);
                    if (logVFile != null) {
                        notification.addAction((AnAction)NotificationAction.createSimple((Supplier)StatisticsBundle.messagePointer((String)"action.NotificationAction.RecordStateStatisticsEventLogAction.text.show.log.file", (Object[])new Object[0]), () -> FileEditorManager.getInstance((Project)project).openFile(logVFile, true)));
                    }
                    notification.notify(project);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/internal/statistic/actions/RecordStateStatisticsEventLogAction$1", "run"));
            }
        });
    }

    public static boolean checkLogRecordingEnabled(Project project, String recorderId) {
        if (StatisticsEventLoggerKt.getEventLogProvider((String)recorderId).isRecordEnabled()) {
            return true;
        }
        Notification notification = new Notification("FeatureUsageStatistics", StatisticsBundle.message((String)"stats.feature.usage.statistics", (Object[])new Object[0]), StatisticsBundle.message((String)"stats.logging.is.disabled", (Object[])new Object[0]), NotificationType.WARNING);
        notification.addAction((AnAction)NotificationAction.createSimple((Supplier)StatisticsBundle.messagePointer((String)"stats.enable.data.sharing", (Object[])new Object[0]), () -> new SingleConfigurableEditor(project, (Configurable)new ConsentConfigurable()).show()));
        notification.notify(project);
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/statistic/actions/RecordStateStatisticsEventLogAction", "actionPerformed"));
    }

    private static class Holder {
        private static final FUStateUsagesLogger myStatesLogger = new FUStateUsagesLogger();

        private Holder() {
        }
    }
}

