/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jetbrains.plugins.webDeployment.DeploymentAppSettingsListener;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.ui.PublishOptionsConfigForm;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PublishOptionsConfigurable
implements SearchableConfigurable {
    private JPanel myContentPane;
    private PublishOptionsConfigForm myForm;
    private final Project myProject;

    public PublishOptionsConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myForm.setPublishConfig(PublishConfig.getInstance(this.myProject));
        this.myForm.setShowMessage(!project.isDefault());
    }

    public JComponent createComponent() {
        return this.myContentPane;
    }

    public boolean isModified() {
        return this.myForm.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myForm.apply();
        ((DeploymentConfigChangeListener)this.myProject.getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).optionsChanged();
        ((DeploymentAppSettingsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_APP_SETTINGS)).connectionOptionsChanged();
    }

    public void reset() {
        this.myForm.reset();
    }

    @Nls
    public String getDisplayName() {
        return WDBundle.message("publish.options.configurable.name", new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.settings.deploy.options";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            PublishOptionsConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void disposeUIResources() {
        PublishConfig.getInstance(this.myProject).setTempAutoUploadState(null);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        PublishOptionsConfigForm publishOptionsConfigForm;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myForm = publishOptionsConfigForm = new PublishOptionsConfigForm();
        JComponent jComponent = publishOptionsConfigForm.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/PublishOptionsConfigurable", "getId"));
    }
}

