/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config.sockets;

import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.sockets.MySftpSocketFactory;
import com.intellij.ssh.sockets.SocketUtils;
import com.intellij.util.EventDispatcher;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.sockets.MyFtpServerSocketFactoryBase;
import com.jetbrains.plugins.webDeployment.config.sockets.MyFtpSocketFactoryBase;
import com.jetbrains.plugins.webDeployment.config.sockets.MyFtpsServerSocketFactoryWrapper;
import com.jetbrains.plugins.webDeployment.config.sockets.MyFtpsSocketFactoryWrapper;
import com.jetbrains.plugins.webDeployment.connections.platform.PlatformSftpFileSystemConfigBuilder;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftps.ServerSocketFactoryWrapper;
import org.apache.commons.vfs2.provider.ftps.SocketFactoryWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentSocketUtils {
    private DeploymentSocketUtils() {
    }

    public static void patchSftpSockets(@NotNull FileSystemOptions options, @NotNull FileTransferConfig ftc, @Nullable EventDispatcher<ForceDisconnectListener> disconnectTrigger) {
        if (options == null) {
            DeploymentSocketUtils.$$$reportNull$$$0(0);
        }
        if (ftc == null) {
            DeploymentSocketUtils.$$$reportNull$$$0(1);
        }
        if (disconnectTrigger != null || DeploymentSocketUtils.shouldPatchSocketsOnMacForIPv6(ftc)) {
            PlatformSftpFileSystemConfigBuilder.getInstance().setForceDisconnectListenerDispatcher(options, disconnectTrigger);
        }
    }

    public static void patchFtpSocketsIfNeeded(@NotNull FileSystemOptions options, @NotNull FileTransferConfig ftc, @Nullable EventDispatcher<ForceDisconnectListener> disconnectTrigger) {
        if (options == null) {
            DeploymentSocketUtils.$$$reportNull$$$0(2);
        }
        if (ftc == null) {
            DeploymentSocketUtils.$$$reportNull$$$0(3);
        }
        if (disconnectTrigger != null || DeploymentSocketUtils.shouldPatchSocketsOnMacForIPv6(ftc)) {
            FtpFileSystemConfigBuilder.getInstance().setSocketFactory(options, (SocketFactory)new MyFtpSocketFactoryBase(disconnectTrigger));
        }
        if (disconnectTrigger != null) {
            FtpFileSystemConfigBuilder.getInstance().setServerSocketFactory(options, MyFtpServerSocketFactoryBase.createInstance(disconnectTrigger));
        }
    }

    public static void patchFtpsSocketsIfNeeded(@NotNull FileSystemOptions options, @NotNull FileTransferConfig ftc, @Nullable EventDispatcher<ForceDisconnectListener> disconnectTrigger) {
        if (options == null) {
            DeploymentSocketUtils.$$$reportNull$$$0(4);
        }
        if (ftc == null) {
            DeploymentSocketUtils.$$$reportNull$$$0(5);
        }
        if (disconnectTrigger != null || DeploymentSocketUtils.shouldPatchSocketsOnMacForIPv6(ftc)) {
            MyFtpsSocketFactoryWrapper socketFactoryWrapper = new MyFtpsSocketFactoryWrapper(disconnectTrigger);
            FtpsFileSystemConfigBuilder.getInstance().setSocketFactoryWrapper(options, (SocketFactoryWrapper)socketFactoryWrapper);
            FtpFileSystemConfigBuilder.getInstance().setSocketFactory(options, SocketFactory.getDefault());
        }
        if (disconnectTrigger != null) {
            FtpsFileSystemConfigBuilder.getInstance().setServerSocketFactoryWrapper(options, (ServerSocketFactoryWrapper)new MyFtpsServerSocketFactoryWrapper(disconnectTrigger));
        }
    }

    public static boolean hasProperEqualsAndHash(Object value) {
        return value instanceof MySftpSocketFactory || value instanceof MyFtpSocketFactoryBase || value instanceof MyFtpServerSocketFactoryBase || value == SocketFactory.getDefault() || value instanceof MyFtpsSocketFactoryWrapper || value instanceof MyFtpsServerSocketFactoryWrapper;
    }

    private static boolean shouldPatchSocketsOnMacForIPv6(FileTransferConfig fileTransferConfig) {
        return SocketUtils.shouldPatchSocketsOnMacForIPv6((String)fileTransferConfig.getHost());
    }

    static InetAddress getProperAddressIfNeeded(@NotNull InetAddress inetAddress) throws SocketException, UnknownHostException {
        NetworkInterface networkInterface;
        if (inetAddress == null) {
            DeploymentSocketUtils.$$$reportNull$$$0(6);
        }
        if (SocketUtils.systemIsPatchable() && inetAddress instanceof Inet6Address && (networkInterface = SocketUtils.findProperIpv6HostNetworkInterface()) != null) {
            return DeploymentSocketUtils.createAddressForInterface(networkInterface, (Inet6Address)inetAddress);
        }
        return null;
    }

    @NotNull
    private static InetAddress createAddressForInterface(@NotNull NetworkInterface anInterface, Inet6Address address) throws UnknownHostException {
        if (anInterface == null) {
            DeploymentSocketUtils.$$$reportNull$$$0(7);
        }
        Inet6Address inet6Address = Inet6Address.getByAddress(address.getHostAddress(), address.getAddress(), anInterface.getIndex());
        if (inet6Address == null) {
            DeploymentSocketUtils.$$$reportNull$$$0(8);
        }
        return inet6Address;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ftc";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inetAddress";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anInterface";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/sockets/DeploymentSocketUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/sockets/DeploymentSocketUtils";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddressForInterface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "patchSftpSockets";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "patchFtpSocketsIfNeeded";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "patchFtpsSocketsIfNeeded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getProperAddressIfNeeded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createAddressForInterface";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

