/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.autoupload;

import com.intellij.application.Topics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.jetbrains.plugins.webDeployment.AutoUploadComponent;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.autoupload.AutoUploadSaveActionsListener;
import com.jetbrains.plugins.webDeployment.autoupload.AutoUploader;
import com.jetbrains.plugins.webDeployment.autoupload.MuteFilter;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoUploadAsyncFileListener
implements VirtualFileListener,
Disposable {
    @NotNull
    private final Project myProject;
    private PublishConfig myPublishConfig;
    private volatile boolean myUploadExternalChanges;
    private final List<AutoUploader> myUploaders;
    private final AutoUploadComponent.MuteHandler myMuteHandler;
    @NotNull
    private volatile UploadStatus myUploadStatus;
    private volatile Disposable myActionListenerDisposable;
    private final Queue<AutoUploadEvent> myEventsToProcess;
    private final List<AutoUploadEvent> myEventsWaitingForSaveAll;
    private final ExecutorService myExecutorService;

    public AutoUploadAsyncFileListener(@NotNull Project project, PublishConfig publishConfig, List<WebServerConfig> servers, @Nullable AutoUploadComponent.MuteHandler muteHandler) {
        if (project == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(0);
        }
        this(project, publishConfig, muteHandler, ContainerUtil.map(servers, server -> new AutoUploader(project, publishConfig, (WebServerConfig)server)));
    }

    AutoUploadAsyncFileListener(@NotNull Project project, PublishConfig publishConfig, @Nullable AutoUploadComponent.MuteHandler muteHandler, List<AutoUploader> uploaders) {
        if (project == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(1);
        }
        this.myMuteHandler = new AutoUploadComponent.MuteHandler();
        this.myEventsToProcess = new ConcurrentLinkedQueue<AutoUploadEvent>();
        this.myEventsWaitingForSaveAll = new ArrayList<AutoUploadEvent>();
        this.myProject = project;
        this.myPublishConfig = publishConfig;
        this.myUploadExternalChanges = this.myPublishConfig.isAutoUploadExternalChanges();
        this.myUploaders = Collections.synchronizedList(uploaders);
        this.myUploadStatus = AutoUploadAsyncFileListener.getUploadStatus(this.myPublishConfig);
        this.myMuteHandler.load(muteHandler);
        this.myExecutorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)WDBundle.message("auto.upload.events.handler", new Object[0]));
    }

    private static UploadStatus getUploadStatus(@NotNull PublishConfig config) {
        PublishConfig.AutoUploadState state;
        if (config == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(2);
        }
        if ((state = config.getAutoUploadState()) == PublishConfig.AutoUploadState.ALWAYS) {
            return UploadStatus.UPLOAD_ALWAYS;
        }
        AutoUploadComponent.LOG.assertTrue(state != PublishConfig.AutoUploadState.NEVER);
        return UploadStatus.UPLOAD_ON_SAVE_ALL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopUploaders() {
        List<AutoUploader> list = this.myUploaders;
        synchronized (list) {
            for (AutoUploader uploader : this.myUploaders) {
                uploader.stopUpload();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigs(PublishConfig publishConfig, List<WebServerConfig> defaultServers) {
        UploadStatus oldUploadStatus;
        List<AutoUploader> list = this.myUploaders;
        synchronized (list) {
            oldUploadStatus = this.myUploadStatus;
            this.stopUploaders();
            this.myPublishConfig = publishConfig.clone();
            this.myUploadExternalChanges = this.myPublishConfig.isAutoUploadExternalChanges();
            this.myUploadStatus = AutoUploadAsyncFileListener.getUploadStatus(this.myPublishConfig);
            ArrayList<WebServerConfig> newServers = new ArrayList<WebServerConfig>(defaultServers);
            Iterator<AutoUploader> iterator = this.myUploaders.iterator();
            while (iterator.hasNext()) {
                AutoUploader next = iterator.next();
                if (!newServers.remove(next.getServer())) {
                    iterator.remove();
                    continue;
                }
                next.setConfig(publishConfig);
            }
            for (WebServerConfig server : newServers) {
                this.myUploaders.add(new AutoUploader(this.myProject, publishConfig, server));
            }
        }
        if (this.myUploadStatus == UploadStatus.UPLOAD_ALWAYS && oldUploadStatus == UploadStatus.UPLOAD_ON_SAVE_ALL) {
            this.uploadAllChangesOnSaveAllAction();
        }
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(3);
        }
        this.contentsChanged(event.isFromSave(), event.getFile().isDirectory(), event.getFile().getPath());
    }

    void contentsChanged(boolean isFromSave, boolean isDirectory, @NotNull String path) {
        if (path == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(4);
        }
        if (AutoUploadComponent.LOG.isTraceEnabled()) {
            AutoUploadComponent.LOG.trace("Contents changed event for " + path);
        }
        this.fileEventAndProcess(new ContentsChangedEvent(isFromSave, isDirectory, path));
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(5);
        }
        if (!"name".equals(event.getPropertyName())) {
            return;
        }
        VirtualFile parent = event.getParent();
        String parentPath = parent == null ? null : parent.getPath();
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (parentPath == null || !(oldValue instanceof String) || !(newValue instanceof String) || newValue.equals(oldValue)) {
            return;
        }
        this.propertyChanged(event.isFromRefresh(), event.getFile().isDirectory(), parentPath, (String)oldValue, (String)newValue);
    }

    void propertyChanged(boolean fromRefresh, boolean isDirectory, @NotNull String parentPath, @NotNull String oldValue, @NotNull String newValue) {
        if (parentPath == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(6);
        }
        if (oldValue == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(7);
        }
        if (newValue == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(8);
        }
        if (AutoUploadComponent.LOG.isTraceEnabled()) {
            AutoUploadComponent.LOG.trace("Property changed event for " + parentPath + "/" + newValue);
        }
        this.fileEventAndProcess(new PropertyChangedEvent(fromRefresh, isDirectory, parentPath, oldValue, newValue));
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(9);
        }
        this.fileCreated(event.isFromRefresh(), event.getFile().isDirectory(), event.getFile().getPath());
    }

    void fileCreated(boolean fromRefresh, boolean isDirectory, @NotNull String path) {
        if (path == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(10);
        }
        if (AutoUploadComponent.LOG.isTraceEnabled()) {
            AutoUploadComponent.LOG.trace("File created event for " + path);
        }
        this.fileEventAndProcess(new FileCreatedEvent(fromRefresh, isDirectory, path));
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(11);
        }
        this.fileDeleted(event.isFromRefresh(), event.getFile().isDirectory(), event.getFile().getPath());
    }

    void fileDeleted(boolean fromRefresh, boolean isDirectory, @NotNull String path) {
        if (path == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(12);
        }
        if (AutoUploadComponent.LOG.isTraceEnabled()) {
            AutoUploadComponent.LOG.trace("File deleted event for " + path);
        }
        this.fileEventAndProcess(new FileDeletedEvent(fromRefresh, isDirectory, path));
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(13);
        }
        this.fileMoved(event.isFromRefresh(), event.getFile().isDirectory(), event.getFileName(), event.getOldParent().getPath(), event.getNewParent().getPath());
    }

    void fileMoved(boolean fromRefresh, boolean isDirectory, String fileName, String oldParentPath, String newParentPath) {
        if (AutoUploadComponent.LOG.isTraceEnabled()) {
            AutoUploadComponent.LOG.trace("File moved event for " + newParentPath);
        }
        this.fileEventAndProcess(new FileMovedEvent(fromRefresh, isDirectory, fileName, oldParentPath, newParentPath));
    }

    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        if (event == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(14);
        }
        this.fileCopied(event.isFromRefresh(), event.getFile().isDirectory(), event.getFile().getPath());
    }

    void fileCopied(boolean fromRefresh, boolean isDirectory, @NotNull String path) {
        if (path == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(15);
        }
        if (AutoUploadComponent.LOG.isTraceEnabled()) {
            AutoUploadComponent.LOG.trace("File copied event for " + path);
        }
        this.fileEventAndProcess(new FileCopiedEvent(fromRefresh, isDirectory, path));
    }

    protected void fileEventAndProcess(AutoUploadEvent e) {
        UploadStatus status = this.myUploadStatus;
        switch (status) {
            case UPLOAD_ALWAYS: {
                this.myEventsToProcess.add(e);
                this.ensureEventsAreProcessed();
                return;
            }
            case UPLOAD_ON_SAVE_ALL: {
                this.myEventsWaitingForSaveAll.add(e);
            }
        }
    }

    private void ensureEventsAreProcessed() {
        this.myExecutorService.execute(() -> {
            HashSet<String> justUploadedFiles = new HashSet<String>();
            AutoUploadEvent currentEvent;
            while ((currentEvent = this.myEventsToProcess.poll()) != null) {
                if (AutoUploadComponent.LOG.isTraceEnabled()) {
                    AutoUploadComponent.LOG.trace("Applying " + currentEvent);
                }
                currentEvent.apply(justUploadedFiles);
            }
            return;
        });
    }

    public void mutePaths(@NotNull MuteFilter filter, @NotNull AutoUploadComponent.MuteLock lock) {
        if (filter == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(16);
        }
        if (lock == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(17);
        }
        MuteEvent event = new MuteEvent(lock, filter);
        if (AutoUploadComponent.LOG.isTraceEnabled()) {
            AutoUploadComponent.LOG.trace("Added mute event " + event);
        }
        this.fileEventAndProcess(event);
    }

    public void unmutePaths(@NotNull AutoUploadComponent.MuteLock lock) {
        if (lock == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(18);
        }
        UnmuteEvent event = new UnmuteEvent(lock);
        if (AutoUploadComponent.LOG.isTraceEnabled()) {
            AutoUploadComponent.LOG.trace("Added unmute event " + event);
        }
        this.fileEventAndProcess(event);
    }

    public void registerActionListener() {
        Disposable disposable = this.myActionListenerDisposable;
        if (disposable == null) {
            this.myActionListenerDisposable = disposable = Disposer.newDisposable();
            Topics.subscribe((Topic)AnActionListener.TOPIC, (Disposable)disposable, (Object)new AutoUploadSaveActionsListener(this.myProject, this));
        }
    }

    public void unregisterActionListener() {
        Disposable disposable = this.myActionListenerDisposable;
        if (disposable != null) {
            this.myActionListenerDisposable = null;
            Disposer.dispose((Disposable)disposable);
        }
    }

    public boolean isUploadOnSaveAll() {
        return this.myUploadStatus == UploadStatus.UPLOAD_ON_SAVE_ALL;
    }

    public void uploadAllChangesOnSaveAllAction() {
        ApplicationManager.getApplication().assertIsWriteThread();
        this.myEventsToProcess.addAll(this.myEventsWaitingForSaveAll);
        this.myEventsWaitingForSaveAll.clear();
        this.ensureEventsAreProcessed();
    }

    public void uploadFile(@NotNull VirtualFile target) {
        if (target == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(19);
        }
        new FileCreatedEvent(false, target.isDirectory(), target.getPath()).apply(null);
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeVirtualFileListener((VirtualFileListener)this);
        this.unregisterActionListener();
        this.myEventsWaitingForSaveAll.clear();
        this.myEventsToProcess.clear();
        this.stopUploaders();
    }

    static void withPathsOfUploadedFiles(@Nullable Set<String> pathsOfUploadedFiles, @NotNull String path, @NotNull Runnable action) {
        if (path == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(20);
        }
        if (action == null) {
            AutoUploadAsyncFileListener.$$$reportNull$$$0(21);
        }
        if (pathsOfUploadedFiles != null && pathsOfUploadedFiles.contains(path)) {
            return;
        }
        action.run();
        if (pathsOfUploadedFiles != null) {
            pathsOfUploadedFiles.add(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFileCreatedEvent(String path, boolean isDirectory, boolean isFromRefresh) {
        List<AutoUploader> list = this.myUploaders;
        synchronized (list) {
            for (AutoUploader uploader : this.myUploaders) {
                uploader.onCreate(path, isDirectory, isFromRefresh, null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lock";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/autoupload/AutoUploadAsyncFileListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getUploadStatus";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "contentsChanged";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCreated";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "fileDeleted";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "fileMoved";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCopied";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "mutePaths";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "unmutePaths";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "uploadFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "withPathsOfUploadedFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class FileCopiedEvent
    extends AutoUploadFileEvent {
        private final String myPath;

        private FileCopiedEvent(boolean fromRefresh, @NotNull boolean isDirectory, String path) {
            if (path == null) {
                FileCopiedEvent.$$$reportNull$$$0(0);
            }
            super(fromRefresh, isDirectory);
            this.myPath = path;
        }

        @Override
        protected void doApply(@Nullable Set<String> pathsOfUploadedFiles) {
            if (AutoUploadAsyncFileListener.this.myMuteHandler.isMuted(this.myPath)) {
                return;
            }
            AutoUploadAsyncFileListener.withPathsOfUploadedFiles(pathsOfUploadedFiles, this.myPath, () -> AutoUploadAsyncFileListener.this.handleFileCreatedEvent(this.myPath, this.isDirectory, this.isFromRefresh));
        }

        @NonNls
        public String toString() {
            return "FileCopiedEvent{" + this.myPath + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/webDeployment/autoupload/AutoUploadAsyncFileListener$FileCopiedEvent", "<init>"));
        }
    }

    private class FileMovedEvent
    extends AutoUploadFileEvent {
        private final String myFileName;
        private final String myOldParentPath;
        private final String myNewParentPath;

        private FileMovedEvent(boolean fromRefresh, boolean isDirectory, String fileName, String oldParentPath, String newParentPath) {
            super(fromRefresh, isDirectory);
            this.myFileName = fileName;
            this.myOldParentPath = oldParentPath;
            this.myNewParentPath = newParentPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doApply(@Nullable Set<String> pathsOfUploadedFiles) {
            boolean sourceMuted = AutoUploadAsyncFileListener.this.myMuteHandler.isMuted(this.myOldParentPath, this.myFileName);
            boolean targetMuted = AutoUploadAsyncFileListener.this.myMuteHandler.isMuted(this.myNewParentPath, this.myFileName);
            if (sourceMuted && targetMuted) {
                return;
            }
            String oldPath = DeploymentPathUtils.join(this.myOldParentPath, this.myFileName);
            String newPath = DeploymentPathUtils.join(this.myNewParentPath, this.myFileName);
            List list = AutoUploadAsyncFileListener.this.myUploaders;
            synchronized (list) {
                for (AutoUploader uploader : AutoUploadAsyncFileListener.this.myUploaders) {
                    uploader.handleFileMovedEvent(sourceMuted, targetMuted, oldPath, newPath, this.isDirectory);
                }
            }
            if (pathsOfUploadedFiles != null) {
                String deletedFile = null;
                String eventFilenameSuffix = "/" + this.myFileName;
                for (String filePath : pathsOfUploadedFiles) {
                    String parentPath;
                    if (!filePath.endsWith(eventFilenameSuffix) || !(parentPath = StringUtil.trimEnd((String)filePath, (String)eventFilenameSuffix)).equals(this.myOldParentPath)) continue;
                    deletedFile = filePath;
                    break;
                }
                if (deletedFile != null) {
                    pathsOfUploadedFiles.remove(deletedFile);
                }
            }
        }

        @NonNls
        public String toString() {
            return "FileMovedEvent{myFileName=" + this.myFileName + ", myOldParent=" + this.myOldParentPath + ", myNewParent=" + this.myNewParentPath + '}';
        }
    }

    private class FileDeletedEvent
    extends AutoUploadFileEvent {
        private final String myPath;

        private FileDeletedEvent(boolean fromRefresh, @NotNull boolean isDirectory, String path) {
            if (path == null) {
                FileDeletedEvent.$$$reportNull$$$0(0);
            }
            super(fromRefresh, isDirectory);
            this.myPath = path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doApply(@Nullable Set<String> pathsOfUploadedFiles) {
            if (AutoUploadAsyncFileListener.this.myMuteHandler.isMuted(this.myPath)) {
                return;
            }
            if (pathsOfUploadedFiles != null) {
                pathsOfUploadedFiles.remove(this.myPath);
            }
            List list = AutoUploadAsyncFileListener.this.myUploaders;
            synchronized (list) {
                for (AutoUploader uploader : AutoUploadAsyncFileListener.this.myUploaders) {
                    uploader.onDelete(this.myPath, this.isDirectory, null);
                }
            }
        }

        @NonNls
        public String toString() {
            return "FileDeletedEvent{" + this.myPath + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/webDeployment/autoupload/AutoUploadAsyncFileListener$FileDeletedEvent", "<init>"));
        }
    }

    private class FileCreatedEvent
    extends AutoUploadFileEvent {
        @NotNull
        private final String myPath;

        private FileCreatedEvent(boolean fromRefresh, @NotNull boolean isDirectory, String path) {
            if (path == null) {
                FileCreatedEvent.$$$reportNull$$$0(0);
            }
            super(fromRefresh, isDirectory);
            this.myPath = path;
        }

        @Override
        protected void doApply(@Nullable Set<String> pathsOfUploadedFiles) {
            if (AutoUploadAsyncFileListener.this.myMuteHandler.isMuted(this.myPath)) {
                return;
            }
            AutoUploadAsyncFileListener.withPathsOfUploadedFiles(pathsOfUploadedFiles, this.myPath, () -> AutoUploadAsyncFileListener.this.handleFileCreatedEvent(this.myPath, this.isDirectory, this.isFromRefresh));
        }

        @NonNls
        public String toString() {
            return "FileCreatedEvent{" + this.myPath + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/webDeployment/autoupload/AutoUploadAsyncFileListener$FileCreatedEvent", "<init>"));
        }
    }

    private class PropertyChangedEvent
    extends AutoUploadFileEvent {
        private final String myParentPath;
        private final String myOldValue;
        private final String myNewValue;

        PropertyChangedEvent(boolean fromRefresh, @NotNull boolean isDirectory, @NotNull String parentPath, @NotNull String oldValue, String newValue) {
            if (parentPath == null) {
                PropertyChangedEvent.$$$reportNull$$$0(0);
            }
            if (oldValue == null) {
                PropertyChangedEvent.$$$reportNull$$$0(1);
            }
            if (newValue == null) {
                PropertyChangedEvent.$$$reportNull$$$0(2);
            }
            super(fromRefresh, isDirectory);
            this.myParentPath = parentPath;
            this.myOldValue = oldValue;
            this.myNewValue = newValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doApply(@Nullable Set<String> pathsOfUploadedFiles) {
            boolean sourceMuted = AutoUploadAsyncFileListener.this.myMuteHandler.isMuted(this.myParentPath, this.myOldValue);
            boolean targetMuted = AutoUploadAsyncFileListener.this.myMuteHandler.isMuted(this.myParentPath, this.myNewValue);
            if (sourceMuted && targetMuted) {
                return;
            }
            String oldPath = DeploymentPathUtils.join(this.myParentPath, this.myOldValue);
            String newPath = DeploymentPathUtils.join(this.myParentPath, this.myNewValue);
            List list = AutoUploadAsyncFileListener.this.myUploaders;
            synchronized (list) {
                for (AutoUploader uploader : AutoUploadAsyncFileListener.this.myUploaders) {
                    uploader.handlePropertyChangeEvent(sourceMuted, targetMuted, oldPath, newPath, this.isDirectory);
                }
            }
            if (pathsOfUploadedFiles != null) {
                String deletedFile = null;
                for (String filePath : pathsOfUploadedFiles) {
                    String fileName;
                    if (!filePath.startsWith(this.myParentPath) || !(fileName = StringUtil.trimStart((String)filePath, (String)(this.myParentPath + "/"))).equals(this.myOldValue) && !fileName.equals(this.myNewValue)) continue;
                    deletedFile = filePath;
                    break;
                }
                if (deletedFile != null) {
                    pathsOfUploadedFiles.remove(deletedFile);
                }
            }
        }

        @NonNls
        public String toString() {
            return "PropertyChangedEvent{, myParent=" + this.myParentPath + ", oldValue=" + this.myOldValue + ", newValue=" + this.myNewValue + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newValue";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/plugins/webDeployment/autoupload/AutoUploadAsyncFileListener$PropertyChangedEvent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ContentsChangedEvent
    extends AutoUploadFileEvent {
        private final boolean isFromSave;
        private final String myPath;

        private ContentsChangedEvent(boolean fromSave, boolean isDirectory, String path) {
            super(!fromSave, isDirectory);
            this.isFromSave = fromSave;
            this.myPath = path;
        }

        @Override
        public void apply(@Nullable Set<String> pathsOfUploadedFiles) {
            if (!AutoUploadAsyncFileListener.this.myUploadExternalChanges && !this.isFromSave) {
                return;
            }
            if (AutoUploadAsyncFileListener.this.myMuteHandler.isMuted(this.myPath)) {
                return;
            }
            AutoUploadAsyncFileListener.withPathsOfUploadedFiles(pathsOfUploadedFiles, this.myPath, () -> {
                AutoUploadComponent.LOG.assertTrue(!this.isDirectory, (Object)("Contents changed fired for a directory " + this.myPath));
                List list = AutoUploadAsyncFileListener.this.myUploaders;
                synchronized (list) {
                    for (AutoUploader uploader : AutoUploadAsyncFileListener.this.myUploaders) {
                        uploader.onFileModified(this.myPath);
                    }
                }
            });
        }

        @Override
        protected void doApply(@Nullable Set<String> pathsOfUploadedFiles) {
        }

        @NonNls
        public String toString() {
            return "ContentsChangedEvent{" + this.myPath + '}';
        }
    }

    private abstract class AutoUploadFileEvent
    implements AutoUploadEvent {
        protected final boolean isFromRefresh;
        protected final boolean isDirectory;

        protected AutoUploadFileEvent(boolean fromRefresh, boolean isDirectory) {
            this.isFromRefresh = fromRefresh;
            this.isDirectory = isDirectory;
        }

        @Override
        public void apply(@Nullable Set<String> pathsOfUploadedFiles) {
            if (!AutoUploadAsyncFileListener.this.myUploadExternalChanges && this.isFromRefresh) {
                return;
            }
            this.doApply(pathsOfUploadedFiles);
        }

        protected abstract void doApply(@Nullable Set<String> var1);
    }

    private class UnmuteEvent
    implements AutoUploadEvent {
        private final AutoUploadComponent.MuteLock myLock;

        private UnmuteEvent(AutoUploadComponent.MuteLock lock) {
            this.myLock = lock;
        }

        @Override
        public void apply(@Nullable Set<String> pathsOfUploadedFiles) {
            AutoUploadAsyncFileListener.this.myMuteHandler.unmutePaths(this.myLock);
        }

        @NonNls
        public String toString() {
            return "UnmuteEvent{myLock=" + this.myLock + '}';
        }
    }

    private class MuteEvent
    implements AutoUploadEvent {
        private final AutoUploadComponent.MuteLock myLock;
        private final MuteFilter myFilter;

        private MuteEvent(AutoUploadComponent.MuteLock lock, MuteFilter filter) {
            this.myLock = lock;
            this.myFilter = filter;
        }

        @Override
        public void apply(@Nullable Set<String> pathsOfUploadedFiles) {
            AutoUploadAsyncFileListener.this.myMuteHandler.mutePaths(this.myFilter, this.myLock);
        }

        @NonNls
        public String toString() {
            return "MuteEvent{myLock=" + this.myLock + ", \nmyFilter=" + this.myFilter + '}';
        }
    }

    protected static interface AutoUploadEvent {
        public void apply(@Nullable Set<String> var1);
    }

    private static enum UploadStatus {
        UPLOAD_ALWAYS,
        UPLOAD_ON_SAVE_ALL;

    }
}

