/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.impl.util.editor.CssFoldingBuilder;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.psi.SASSFile;
import org.jetbrains.plugins.scss.psi.SASSSCSSElementVisitor;
import org.jetbrains.plugins.scss.psi.SassScssBlock;
import org.jetbrains.plugins.scss.psi.SassScssFunctionBodyImpl;
import org.jetbrains.plugins.scss.psi.SassScssFunctionDeclarationImpl;
import org.jetbrains.plugins.scss.psi.SassScssMapImpl;
import org.jetbrains.plugins.scss.psi.SassScssRuleset;

public class SassScssFoldingBuilder
extends CssFoldingBuilder {
    protected FoldingDescriptor createDescriptor(PsiElement element, TextRange textRange) {
        PsiElement prevSibling;
        if (element.getContainingFile() instanceof SASSFile && (element.getParent() instanceof SassScssRuleset || element.getParent() instanceof CssRuleset) && (prevSibling = SassScssFoldingBuilder.getPrevNewLine(element)) != null) {
            textRange = TextRange.create((int)prevSibling.getTextRange().getStartOffset(), (int)textRange.getEndOffset());
        }
        return super.createDescriptor(element, textRange);
    }

    protected void buildLanguageFoldRegions(final @NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement psiElement, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            SassScssFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (psiElement == null) {
            SassScssFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            SassScssFoldingBuilder.$$$reportNull$$$0(2);
        }
        super.buildLanguageFoldRegions(descriptors, psiElement, document, quick);
        CssStylesheet stylesheet = SassScssFoldingBuilder.getStylesheet((PsiElement)psiElement);
        if (stylesheet == null) {
            return;
        }
        stylesheet.accept((PsiElementVisitor)new SASSSCSSElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                element.acceptChildren((PsiElementVisitor)this);
            }

            @Override
            public void visitFunctionDeclaration(SassScssFunctionDeclarationImpl functionDeclaration) {
                TextRange textRange;
                SassScssFunctionBodyImpl body = functionDeclaration.getBody();
                if (body != null && (textRange = body.getTextRange()).getLength() > 1) {
                    descriptors.add(SassScssFoldingBuilder.this.createDescriptor((PsiElement)body, textRange));
                }
                super.visitFunctionDeclaration(functionDeclaration);
            }

            @Override
            public void visitMap(SassScssMapImpl map) {
                descriptors.add(SassScssFoldingBuilder.this.createDescriptor((PsiElement)map, map.getTextRange()));
                super.visitMap(map);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/sass/editor/SassScssFoldingBuilder$1", "visitElement"));
            }
        });
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            SassScssFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (range == null) {
            SassScssFoldingBuilder.$$$reportNull$$$0(4);
        }
        if (node instanceof SassScssBlock) {
            return ((SassScssBlock)node).getContainingFile() instanceof SASSFile ? "..." : "{...}";
        }
        if (node instanceof SassScssMapImpl) {
            return "(...)";
        }
        return super.getLanguagePlaceholderText(node, range);
    }

    @Nullable
    private static PsiElement getPrevNewLine(PsiElement element) {
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)element, (boolean)true);
        while (prevLeaf != null && !"\n".equals(prevLeaf.getText())) {
            if (!StringUtil.isEmptyOrSpaces((String)prevLeaf.getText())) {
                return null;
            }
            prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)prevLeaf, (boolean)true);
        }
        return prevLeaf;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/sass/editor/SassScssFoldingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

