/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.PerformanceCareRule;
import org.jetbrains.annotations.NotNull;

public class UtilExpressionWhiteListRule
extends PerformanceCareRule
implements FUSRule {
    @NotNull
    private final FUSRule myRule;
    @NotNull
    private final String myPrefix;
    @NotNull
    private final String mySuffix;

    public UtilExpressionWhiteListRule(@NotNull FUSRule rule, @NotNull String prefix, @NotNull String suffix) {
        if (rule == null) {
            UtilExpressionWhiteListRule.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            UtilExpressionWhiteListRule.$$$reportNull$$$0(1);
        }
        if (suffix == null) {
            UtilExpressionWhiteListRule.$$$reportNull$$$0(2);
        }
        this.myRule = rule;
        this.myPrefix = prefix;
        this.mySuffix = suffix;
    }

    @Override
    @NotNull
    public ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        String escapedData;
        if (data == null) {
            UtilExpressionWhiteListRule.$$$reportNull$$$0(3);
        }
        if (context == null) {
            UtilExpressionWhiteListRule.$$$reportNull$$$0(4);
        }
        if (this.acceptPrefix(escapedData = StatisticsEventEscaper.escape((String)data)) && this.acceptSuffix(escapedData)) {
            ValidationResultType validationResultType = this.myRule.validate(escapedData.substring(this.myPrefix.length(), escapedData.length() - this.mySuffix.length()), context);
            if (validationResultType == null) {
                UtilExpressionWhiteListRule.$$$reportNull$$$0(5);
            }
            return validationResultType;
        }
        ValidationResultType validationResultType = ValidationResultType.REJECTED;
        if (validationResultType == null) {
            UtilExpressionWhiteListRule.$$$reportNull$$$0(6);
        }
        return validationResultType;
    }

    private boolean acceptPrefix(@NotNull String data) {
        if (data == null) {
            UtilExpressionWhiteListRule.$$$reportNull$$$0(7);
        }
        return this.myPrefix.isEmpty() || data.startsWith(this.myPrefix);
    }

    private boolean acceptSuffix(@NotNull String data) {
        if (data == null) {
            UtilExpressionWhiteListRule.$$$reportNull$$$0(8);
        }
        return this.mySuffix.isEmpty() || data.endsWith(this.mySuffix);
    }

    public String toString() {
        return "UtilExpressionWhiteListRule: myPrefix=" + this.myPrefix + ",mySuffix=" + this.mySuffix + ",myRule=" + this.myRule;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/UtilExpressionWhiteListRule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/UtilExpressionWhiteListRule";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doValidate";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptPrefix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "acceptSuffix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

