/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.console.RemoteDataProducer;
import com.jetbrains.plugins.remotesdk.console.SshConsoleOptionsProvider;
import com.jetbrains.plugins.remotesdk.console.SshTerminalCachingRunner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.TerminalView;

public class RunSshConsoleAction
extends AnAction
implements DumbAware {
    private static final Logger LOGGER = Logger.getInstance(RunSshConsoleAction.class);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunSshConsoleAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RunSshConsoleAction.$$$reportNull$$$0(1);
        }
        this.runSshConsole(e);
    }

    public void runSshConsole(AnActionEvent event) {
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        SshConsoleOptionsProvider optionsProvider = SshConsoleOptionsProvider.getInstance(project);
        new RemoteDataProducer().withActionEvent(event).withShowProjectLevelServers(true).produceRemoteData(optionsProvider.getConnectionType(), optionsProvider.getConnectionId(), optionsProvider.getAdditionalData(), (Consumer<? super RemoteCredentials>)((Consumer)data -> {
            SshTerminalCachingRunner runner = new SshTerminalCachingRunner(project, (RemoteCredentials)data, optionsProvider.getCharset());
            UIUtil.invokeLaterIfNeeded(() -> RunSshConsoleAction.connectToSshUnderProgress(project, runner, data));
        }));
    }

    private static void connectToSshUnderProgress(final Project project, final SshTerminalCachingRunner runner, final RemoteCredentials data) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Connecting to " + runner.runningTargetName(), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                RunSshConsoleAction.createTerminalSession(indicator, runner, data, project, this.getTitle());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/remotesdk/console/RunSshConsoleAction$1", "run"));
            }
        });
    }

    private static void createTerminalSession(@NotNull ProgressIndicator indicator, SshTerminalCachingRunner runner, RemoteCredentials data, Project project, String title) {
        block3: {
            if (indicator == null) {
                RunSshConsoleAction.$$$reportNull$$$0(2);
            }
            try {
                runner.connect();
                AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> TerminalView.getInstance((Project)project).createNewSession((AbstractTerminalRunner)runner));
            }
            catch (RemoteSdkException e) {
                if (indicator.isCanceled()) break block3;
                LOGGER.warn("unable to get session for " + data, (Throwable)e);
                AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)title));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/remotesdk/console/RunSshConsoleAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createTerminalSession";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

